#ifndef _ISO2022JP_HDR_
#define _ISO2022JP_HDR_
/*
 * iso-2022-jp support by Norihisa Washitake <nori@washitake.com>
 *  this patch may include some bugs, please see
 *  http://www.chimons.org/~wassy/courier/ for the latest version.
 *
 * $Id: iso2022jp.h,v 1.2 2002/05/08 04:09:47 mrsam Exp $ 
 */

#if (JIS_DEBUG > 0) && defined(JIS_BUILD_APP)
#include <stdlib.h>
#include <stdio.h>
#include <wchar.h>
#include <string.h>

/* Definitions from unicode.h */
typedef wchar_t unicode_char;
struct unicode_info {
  const char *chset;
  unicode_char *(*c2u)(const char *, int *);
  char *(*u2c)(const unicode_char *, int *);
  char *(*toupper_func)(const char *, int *);
  char *(*tolower_func)(const char *, int *);
  char *(*totitle_func)(const char *, int *);
};
#else
#include "unicode.h"
#endif /* JIS_BUILD_APP */

/*
 * Some characters are unique in ISO-2022-JP character set,
 * so define them specially.
 */

#define JIS_CHAR_ESC    0x1B
#define JIS_CHAR_SO     0x0E
#define JIS_CHAR_SI     0x0F

#define JIS_TYPE_ASCII      0x0
#define JIS_TYPE_ROMAN      0x1
#define JIS_TYPE_7BITKANA   0x2
#define JIS_TYPE_8BITKANA   0x3
#define JIS_TYPE_KANJI      0x4
#define JIS_TYPE_BINARY     0x5

struct jischar_t {
  int type;
  int value;
};


/* map: iso-2022-jp to Unicode */
static const unicode_char jis2uni_tbl_21[] = {
  0x3000, 0x3001, 0x3002, 0xFF0C, 0xFF0E, 0x30FB, 0xFF1A, 0xFF1B, 
  0xFF1F, 0xFF01, 0x309B, 0x309C, 0x00B4, 0xFF40, 0x00A8, 0xFF3E, 
  0xFFE3, 0xFF3F, 0x30FD, 0x30FE, 0x309D, 0x309E, 0x3003, 0x4EDD, 
  0x3005, 0x3006, 0x3007, 0x30FC, 0x003F, 0x2010, 0xFF0F, 0x005C, 
  0x301C, 0x2016, 0xFF5C, 0x2026, 0x2025, 0x2018, 0x2019, 0x201C, 
  0x201D, 0xFF08, 0xFF09, 0x3014, 0x3015, 0xFF3B, 0xFF3D, 0xFF5B, 
  0xFF5D, 0x3008, 0x3009, 0x300A, 0x300B, 0x300C, 0x300D, 0x300E, 
  0x300F, 0x3010, 0x3011, 0xFF0B, 0x2212, 0x00B1, 0x00D7, 0x00F7, 
  0xFF1D, 0x2260, 0xFF1C, 0xFF1E, 0x2266, 0x2267, 0x221E, 0x2234, 
  0x2642, 0x2640, 0x00B0, 0x2032, 0x2033, 0x2103, 0xFFE5, 0xFF04, 
  0x00A2, 0x00A3, 0xFF05, 0xFF03, 0xFF06, 0xFF0A, 0xFF20, 0x00A7, 
  0x2606, 0x2605, 0x25CB, 0x25CF, 0x25CE, 0x25C7
};
static const unicode_char jis2uni_tbl_22[] = {
  0x25C6, 0x25A1, 0x25A0, 0x25B3, 0x25B2, 0x25BD, 0x25BC, 0x203B, 
  0x3012, 0x2192, 0x2190, 0x2191, 0x2193, 0x3013, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x2208, 0x220B, 0x2286, 0x2287, 0x2282, 0x2283, 0x222A, 
  0x2229, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x2227, 0x2228, 0x00AC, 0x21D2, 0x21D4, 0x2200, 0x2203, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x2220, 0x22A5, 0x2312, 0x2202, 0x2207, 
  0x2261, 0x2252, 0x226A, 0x226B, 0x221A, 0x223D, 0x221D, 0x2235, 
  0x222B, 0x222C, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x212B, 0x2030, 0x266F, 0x266D, 0x266A, 0x2020, 0x2021, 
  0x00B6, 0x003F, 0x003F, 0x003F, 0x003F, 0x25EF
};
static const unicode_char jis2uni_tbl_23[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0xFF10, 
  0xFF11, 0xFF12, 0xFF13, 0xFF14, 0xFF15, 0xFF16, 0xFF17, 0xFF18, 
  0xFF19, 0xFF1A, 0xFF1B, 0xFF1C, 0xFF1D, 0xFF1E, 0xFF1F, 0xFF20, 
  0xFF21, 0xFF22, 0xFF23, 0xFF24, 0xFF25, 0xFF26, 0xFF27, 0xFF28, 
  0xFF29, 0xFF2A, 0xFF2B, 0xFF2C, 0xFF2D, 0xFF2E, 0xFF2F, 0xFF30, 
  0xFF31, 0xFF32, 0xFF33, 0xFF34, 0xFF35, 0xFF36, 0xFF37, 0xFF38, 
  0xFF39, 0xFF3A, 0xFF3B, 0xFF3C, 0xFF3D, 0xFF3E, 0xFF3F, 0xFF40, 
  0xFF41, 0xFF42, 0xFF43, 0xFF44, 0xFF45, 0xFF46, 0xFF47, 0xFF48, 
  0xFF49, 0xFF4A, 0xFF4B, 0xFF4C, 0xFF4D, 0xFF4E, 0xFF4F, 0xFF50, 
  0xFF51, 0xFF52, 0xFF53, 0xFF54, 0xFF55, 0xFF56, 0xFF57, 0xFF58, 
  0xFF59, 0xFF5A, 0xFF5B, 0x003F, 0x003F, 0x003F
};
static const unicode_char jis2uni_tbl_24[] = {
  0x3041, 0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047, 0x3048, 
  0x3049, 0x304A, 0x304B, 0x304C, 0x304D, 0x304E, 0x304F, 0x3050, 
  0x3051, 0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3057, 0x3058, 
  0x3059, 0x305A, 0x305B, 0x305C, 0x305D, 0x305E, 0x305F, 0x3060, 
  0x3061, 0x3062, 0x3063, 0x3064, 0x3065, 0x3066, 0x3067, 0x3068, 
  0x3069, 0x306A, 0x306B, 0x306C, 0x306D, 0x306E, 0x306F, 0x3070, 
  0x3071, 0x3072, 0x3073, 0x3074, 0x3075, 0x3076, 0x3077, 0x3078, 
  0x3079, 0x307A, 0x307B, 0x307C, 0x307D, 0x307E, 0x307F, 0x3080, 
  0x3081, 0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087, 0x3088, 
  0x3089, 0x308A, 0x308B, 0x308C, 0x308D, 0x308E, 0x308F, 0x3090, 
  0x3091, 0x3092, 0x3093, 0x3094, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unicode_char jis2uni_tbl_25[] = {
  0x30A1, 0x30A2, 0x30A3, 0x30A4, 0x30A5, 0x30A6, 0x30A7, 0x30A8, 
  0x30A9, 0x30AA, 0x30AB, 0x30AC, 0x30AD, 0x30AE, 0x30AF, 0x30B0, 
  0x30B1, 0x30B2, 0x30B3, 0x30B4, 0x30B5, 0x30B6, 0x30B7, 0x30B8, 
  0x30B9, 0x30BA, 0x30BB, 0x30BC, 0x30BD, 0x30BE, 0x30BF, 0x30C0, 
  0x30C1, 0x30C2, 0x30C3, 0x30C4, 0x30C5, 0x30C6, 0x30C7, 0x30C8, 
  0x30C9, 0x30CA, 0x30CB, 0x30CC, 0x30CD, 0x30CE, 0x30CF, 0x30D0, 
  0x30D1, 0x30D2, 0x30D3, 0x30D4, 0x30D5, 0x30D6, 0x30D7, 0x30D8, 
  0x30D9, 0x30DA, 0x30DB, 0x30DC, 0x30DD, 0x30DE, 0x30DF, 0x30E0, 
  0x30E1, 0x30E2, 0x30E3, 0x30E4, 0x30E5, 0x30E6, 0x30E7, 0x30E8, 
  0x30E9, 0x30EA, 0x30EB, 0x30EC, 0x30ED, 0x30EE, 0x30EF, 0x30F0, 
  0x30F1, 0x30F2, 0x30F3, 0x30F4, 0x30F5, 0x30F6, 0x30F7, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unicode_char jis2uni_tbl_26[] = {
  0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 
  0x0399, 0x039A, 0x039B, 0x039C, 0x039D, 0x039E, 0x039F, 0x03A0, 
  0x03A1, 0x03A3, 0x03A4, 0x03A5, 0x03A6, 0x03A7, 0x03A8, 0x03A9, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7, 0x03B8, 
  0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD, 0x03BE, 0x03BF, 0x03C0, 
  0x03C1, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7, 0x03C8, 0x03C9, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unicode_char jis2uni_tbl_27[] = {
  0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0401, 0x0416, 
  0x0417, 0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 
  0x041F, 0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 
  0x0427, 0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 
  0x042F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0451, 0x0436, 
  0x0437, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 
  0x043F, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 
  0x0447, 0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 
  0x044F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unicode_char jis2uni_tbl_28[] = {
  0x2500, 0x2502, 0x250C, 0x2510, 0x2518, 0x2514, 0x251C, 0x252C, 
  0x2524, 0x2534, 0x253C, 0x2501, 0x2503, 0x250F, 0x2513, 0x251B, 
  0x2517, 0x2523, 0x2533, 0x252B, 0x253B, 0x254B, 0x2520, 0x252F, 
  0x2528, 0x2537, 0x253F, 0x251D, 0x2530, 0x2525, 0x2538, 0x2542, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unicode_char jis2uni_tbl_30[] = {
  0x4E9C, 0x5516, 0x5A03, 0x963F, 0x54C0, 0x611B, 0x6328, 0x59F6, 
  0x9022, 0x8475, 0x831C, 0x7A50, 0x60AA, 0x63E1, 0x6E25, 0x65ED, 
  0x8466, 0x82A6, 0x9BF5, 0x6893, 0x5727, 0x65A1, 0x6271, 0x5B9B, 
  0x59D0, 0x867B, 0x98F4, 0x7D62, 0x7DBE, 0x9B8E, 0x6216, 0x7C9F, 
  0x88B7, 0x5B89, 0x5EB5, 0x6309, 0x6697, 0x6848, 0x95C7, 0x978D, 
  0x674F, 0x4EE8, 0x4F0A, 0x4F4D, 0x4F9D, 0x5049, 0x56F2, 0x5937, 
  0x59D4, 0x5A01, 0x5C09, 0x60DF, 0x610F, 0x6170, 0x6613, 0x6905, 
  0x70BA, 0x754F, 0x7570, 0x79FB, 0x7DAD, 0x7DEF, 0x80C3, 0x840E, 
  0x8863, 0x8B02, 0x9055, 0x907A, 0x533B, 0x4F40, 0x4F42, 0x57DF, 
  0x80B2, 0x90C1, 0x78EF, 0x4F52, 0x58F1, 0x6EA2, 0x9038, 0x7A32, 
  0x8328, 0x828B, 0x9C2F, 0x5141, 0x5370, 0x54BD, 0x54E1, 0x56E0, 
  0x59FB, 0x5F15, 0x98F2, 0x6DEB, 0x80E4, 0x852D
};
static const unicode_char jis2uni_tbl_31[] = {
  0x9662, 0x9670, 0x96A0, 0x97FB, 0x540B, 0x53F3, 0x5B87, 0x70CF, 
  0x7FBD, 0x8FC2, 0x96E8, 0x536F, 0x9D5C, 0x7ABA, 0x4FB2, 0x7893, 
  0x81FC, 0x6E26, 0x5618, 0x5504, 0x6B1D, 0x851A, 0x9C3B, 0x59E5, 
  0x53A9, 0x6D66, 0x74DC, 0x958F, 0x5642, 0x4FCD, 0x904B, 0x96F2, 
  0x834F, 0x990C, 0x53E1, 0x55B6, 0x5B30, 0x5F71, 0x6620, 0x66F3, 
  0x6804, 0x6C38, 0x6CF3, 0x6D29, 0x745B, 0x76C8, 0x7A4E, 0x9834, 
  0x82F1, 0x885B, 0x8A60, 0x92ED, 0x6DB2, 0x75AB, 0x76CA, 0x99C5, 
  0x60A6, 0x8B01, 0x8D8A, 0x95B2, 0x698E, 0x53AD, 0x5186, 0x5712, 
  0x5830, 0x5944, 0x5BB4, 0x5EF6, 0x6028, 0x63A9, 0x63F4, 0x6CBF, 
  0x6F14, 0x708E, 0x7114, 0x7159, 0x71D5, 0x733F, 0x7E01, 0x8276, 
  0x82D1, 0x8597, 0x9060, 0x925B, 0x9D1B, 0x5869, 0x65BC, 0x6C5A, 
  0x7525, 0x51F9, 0x592E, 0x5965, 0x5F80, 0x5FDC
};
static const unicode_char jis2uni_tbl_32[] = {
  0x62BC, 0x65FA, 0x6A2A, 0x6B27, 0x6BB4, 0x738B, 0x7FC1, 0x8956, 
  0x9D2C, 0x9D0E, 0x9EC4, 0x5CA1, 0x6C96, 0x837B, 0x5104, 0x5C4B, 
  0x61B6, 0x81C6, 0x6876, 0x7261, 0x50C7, 0x50CC, 0x5378, 0x6069, 
  0x6E29, 0x7A4F, 0x97F3, 0x50DC, 0x5316, 0x50DF, 0x50E2, 0x50E4, 
  0x50E6, 0x50E8, 0x52A0, 0x53EF, 0x5609, 0x590F, 0x5AC1, 0x5BB6, 
  0x5BE1, 0x79D1, 0x6687, 0x679C, 0x67B6, 0x6B4C, 0x6CB3, 0x706B, 
  0x73C2, 0x798D, 0x79BE, 0x7A3C, 0x7B87, 0x82B1, 0x82DB, 0x8304, 
  0x8377, 0x83EF, 0x83D3, 0x8766, 0x8AB2, 0x5629, 0x8CA8, 0x8FE6, 
  0x904E, 0x971E, 0x868A, 0x5139, 0x5CE8, 0x6211, 0x7259, 0x753B, 
  0x81E5, 0x82BD, 0x86FE, 0x8CC0, 0x96C5, 0x9913, 0x99D5, 0x5183, 
  0x5184, 0x89E3, 0x56DE, 0x584A, 0x58CA, 0x5EFB, 0x5FEB, 0x602A, 
  0x6094, 0x6062, 0x61D0, 0x6212, 0x62D0, 0x6539
};
static const unicode_char jis2uni_tbl_33[] = {
  0x9B41, 0x6666, 0x68B0, 0x6D77, 0x7070, 0x754C, 0x7686, 0x7D75, 
  0x82A5, 0x87F9, 0x958B, 0x968E, 0x8C9D, 0x51F4, 0x52BE, 0x5916, 
  0x54B3, 0x5BB3, 0x5D16, 0x6168, 0x6982, 0x6DAF, 0x788D, 0x84CB, 
  0x8857, 0x8A72, 0x93A7, 0x9AB8, 0x6D6C, 0x99A8, 0x86D9, 0x57A3, 
  0x67FF, 0x86CE, 0x920E, 0x5283, 0x5687, 0x5404, 0x5ED3, 0x62E1, 
  0x64B9, 0x683C, 0x6838, 0x6BBB, 0x7372, 0x78BA, 0x7A6B, 0x899A, 
  0x89D2, 0x8D6B, 0x8F03, 0x90ED, 0x95A3, 0x9694, 0x9769, 0x5B66, 
  0x5CB3, 0x697D, 0x984D, 0x984E, 0x639B, 0x7B20, 0x6A2B, 0x6A7F, 
  0x68B6, 0x9C0D, 0x6F5F, 0x52BD, 0x559D, 0x6070, 0x62EC, 0x6D3B, 
  0x6E07, 0x6ED1, 0x845B, 0x8910, 0x8F44, 0x52DB, 0x9C39, 0x53F6, 
  0x691B, 0x6A3A, 0x9784, 0x682A, 0x52EC, 0x7AC3, 0x84B2, 0x91DC, 
  0x938C, 0x565B, 0x9D28, 0x6822, 0x8305, 0x8431
};
static const unicode_char jis2uni_tbl_34[] = {
  0x7CA5, 0x5311, 0x82C5, 0x74E6, 0x531B, 0x531C, 0x531E, 0x5BD2, 
  0x5325, 0x5327, 0x5328, 0x5DFB, 0x559A, 0x582A, 0x59E6, 0x5B8C, 
  0x5B98, 0x5BDB, 0x5E72, 0x5E79, 0x60A3, 0x611F, 0x6163, 0x61BE, 
  0x63DB, 0x6562, 0x67D1, 0x6853, 0x68FA, 0x6B3E, 0x6B53, 0x6C57, 
  0x6F22, 0x6F97, 0x6F45, 0x74B0, 0x7518, 0x76E3, 0x770B, 0x7AFF, 
  0x7BA1, 0x7C21, 0x7DE9, 0x7F36, 0x7FF0, 0x809D, 0x8266, 0x839E, 
  0x89B3, 0x8ACC, 0x8CAB, 0x9084, 0x9451, 0x9593, 0x9591, 0x95A2, 
  0x9665, 0x97D3, 0x9928, 0x8218, 0x53DA, 0x542B, 0x5CB8, 0x5DCC, 
  0x73A9, 0x764C, 0x773C, 0x5CA9, 0x7FEB, 0x8D0B, 0x96C1, 0x9811, 
  0x9854, 0x9858, 0x542F, 0x5431, 0x5434, 0x559C, 0x5668, 0x57FA, 
  0x5947, 0x5B09, 0x5BC4, 0x5C90, 0x5E0C, 0x5E7E, 0x5FCC, 0x63EE, 
  0x673A, 0x65D7, 0x65E2, 0x671F, 0x68CB, 0x68C4
};
static const unicode_char jis2uni_tbl_35[] = {
  0x6A5F, 0x5E30, 0x6BC5, 0x6C17, 0x6C7D, 0x757F, 0x7948, 0x5B63, 
  0x7A00, 0x7D00, 0x5FBD, 0x898F, 0x8A18, 0x8CB4, 0x8D77, 0x8ECC, 
  0x8F1D, 0x98E2, 0x9A0E, 0x9B3C, 0x54B9, 0x54BA, 0x54BB, 0x5993, 
  0x5B9C, 0x622F, 0x6280, 0x64EC, 0x6B3A, 0x72A0, 0x7591, 0x7947, 
  0x7FA9, 0x87FB, 0x8ABC, 0x8B70, 0x63AC, 0x83CA, 0x97A0, 0x5508, 
  0x5509, 0x55AB, 0x6854, 0x6A58, 0x8A70, 0x7827, 0x6775, 0x9ECD, 
  0x5535, 0x5BA2, 0x811A, 0x8650, 0x9006, 0x5541, 0x5547, 0x5549, 
  0x554A, 0x554D, 0x5550, 0x5BAE, 0x5F13, 0x6025, 0x6551, 0x673D, 
  0x6C42, 0x6C72, 0x6CE3, 0x7078, 0x7403, 0x7A76, 0x7AAE, 0x7B08, 
  0x7D1A, 0x7CFE, 0x7D66, 0x65E7, 0x725B, 0x5593, 0x5C45, 0x5DE8, 
  0x62D2, 0x62E0, 0x6319, 0x6E20, 0x865A, 0x8A31, 0x8DDD, 0x92F8, 
  0x6F01, 0x79A6, 0x9B5A, 0x55CE, 0x55D1, 0x55D2
};
static const unicode_char jis2uni_tbl_36[] = {
  0x55D3, 0x55D7, 0x55D8, 0x55DB, 0x7AF6, 0x55E2, 0x55E9, 0x55F6, 
  0x55FF, 0x5605, 0x5608, 0x560A, 0x5883, 0x5CE1, 0x5F37, 0x5F4A, 
  0x602F, 0x6050, 0x606D, 0x631F, 0x6559, 0x6A4B, 0x6CC1, 0x72C2, 
  0x72ED, 0x77EF, 0x80F8, 0x8105, 0x8208, 0x854E, 0x90F7, 0x93E1, 
  0x97FF, 0x9957, 0x9A5A, 0x564B, 0x564D, 0x5C2D, 0x6681, 0x696D, 
  0x5C40, 0x66F2, 0x6975, 0x7389, 0x6850, 0x7C81, 0x566D, 0x566F, 
  0x5747, 0x5DFE, 0x9326, 0x65A4, 0x6B23, 0x6B3D, 0x7434, 0x7981, 
  0x79BD, 0x7B4B, 0x7DCA, 0x82B9, 0x83CC, 0x887F, 0x895F, 0x8B39, 
  0x8FD1, 0x91D1, 0x56AB, 0x9280, 0x56AD, 0x56B1, 0x56B3, 0x56B7, 
  0x72D7, 0x7396, 0x77E9, 0x82E6, 0x8EAF, 0x99C6, 0x99C8, 0x99D2, 
  0x56CD, 0x611A, 0x865E, 0x56DD, 0x7A7A, 0x56E1, 0x5BD3, 0x9047, 
  0x9685, 0x56E7, 0x6ADB, 0x91E7, 0x5C51, 0x5C48
};
static const unicode_char jis2uni_tbl_37[] = {
  0x6398, 0x7A9F, 0x6C93, 0x9774, 0x8F61, 0x7AAA, 0x718A, 0x9688, 
  0x7C82, 0x6817, 0x7E70, 0x6851, 0x936C, 0x5722, 0x5723, 0x85AB, 
  0x8A13, 0x7FA4, 0x8ECD, 0x90E1, 0x572E, 0x8888, 0x7941, 0x5734, 
  0x573D, 0x573E, 0x573F, 0x5745, 0x5746, 0x73EA, 0x578B, 0x5951, 
  0x5F62, 0x5F84, 0x6075, 0x6176, 0x6167, 0x61A9, 0x63B2, 0x643A, 
  0x656C, 0x666F, 0x6842, 0x6E13, 0x7566, 0x7A3D, 0x7CFB, 0x7D4C, 
  0x7D99, 0x7E4B, 0x7F6B, 0x830E, 0x834A, 0x86CD, 0x8A08, 0x8A63, 
  0x8B66, 0x8EFD, 0x981A, 0x9D8F, 0x82B8, 0x8FCE, 0x9BE8, 0x5795, 
  0x621F, 0x6483, 0x6FC0, 0x9699, 0x6841, 0x57BD, 0x6B20, 0x6C7A, 
  0x6F54, 0x7A74, 0x7D50, 0x8840, 0x8A23, 0x6708, 0x57E6, 0x57E7, 
  0x57E9, 0x57ED, 0x57F0, 0x57F5, 0x57F6, 0x57F8, 0x57FD, 0x5805, 
  0x5ACC, 0x5EFA, 0x61B2, 0x61F8, 0x62F3, 0x6372
};
static const unicode_char jis2uni_tbl_38[] = {
  0x691C, 0x6A29, 0x727D, 0x72AC, 0x732E, 0x7814, 0x786F, 0x7D79, 
  0x770C, 0x80A9, 0x898B, 0x8B19, 0x8CE2, 0x8ED2, 0x9063, 0x9375, 
  0x967A, 0x9855, 0x9A13, 0x9E78, 0x5864, 0x5867, 0x5868, 0x5E7B, 
  0x5F26, 0x6E1B, 0x6E90, 0x7384, 0x73FE, 0x7D43, 0x8237, 0x8A00, 
  0x8AFA, 0x9650, 0x588F, 0x5890, 0x5894, 0x5896, 0x589D, 0x59D1, 
  0x5B64, 0x5DF1, 0x5EAB, 0x5F27, 0x6238, 0x6545, 0x67AF, 0x6E56, 
  0x72D0, 0x7CCA, 0x88B4, 0x80A1, 0x80E1, 0x83F0, 0x864E, 0x8A87, 
  0x8DE8, 0x9237, 0x96C7, 0x9867, 0x9F13, 0x58F3, 0x5905, 0x5906, 
  0x590B, 0x590C, 0x5912, 0x5A2F, 0x5F8C, 0x8641, 0x609F, 0x68A7, 
  0x6A8E, 0x745A, 0x7881, 0x8A9E, 0x8AA4, 0x8B77, 0x9190, 0x5936, 
  0x9BC9, 0x5943, 0x5946, 0x5952, 0x5953, 0x5959, 0x595B, 0x595D, 
  0x595E, 0x595F, 0x5961, 0x5963, 0x596B, 0x596D
};
static const unicode_char jis2uni_tbl_39[] = {
  0x596F, 0x5972, 0x5975, 0x5976, 0x597D, 0x5B54, 0x5B5D, 0x5B8F, 
  0x5DE5, 0x5DE7, 0x5DF7, 0x5E78, 0x5E83, 0x5E9A, 0x5EB7, 0x5F18, 
  0x6052, 0x614C, 0x6297, 0x62D8, 0x63A7, 0x653B, 0x6602, 0x6643, 
  0x66F4, 0x676D, 0x6821, 0x6897, 0x69CB, 0x6C5F, 0x6D2A, 0x6D69, 
  0x6E2F, 0x6E9D, 0x7532, 0x7687, 0x786C, 0x7A3F, 0x7CE0, 0x7D05, 
  0x7D18, 0x7D5E, 0x7DB1, 0x8015, 0x8003, 0x80AF, 0x80B1, 0x8154, 
  0x818F, 0x822A, 0x8352, 0x884C, 0x8861, 0x8B1B, 0x8CA2, 0x8CFC, 
  0x90CA, 0x9175, 0x9271, 0x783F, 0x92FC, 0x95A4, 0x964D, 0x9805, 
  0x9999, 0x9AD8, 0x9D3B, 0x5A65, 0x5A67, 0x5A6D, 0x5A77, 0x5A7A, 
  0x62F7, 0x6FE0, 0x8C6A, 0x8F5F, 0x9EB9, 0x5A96, 0x5A99, 0x5A9C, 
  0x5A9E, 0x7A40, 0x9177, 0x9D60, 0x9ED2, 0x7344, 0x6F09, 0x8170, 
  0x7511, 0x5FFD, 0x60DA, 0x9AA8, 0x72DB, 0x8FBC
};
static const unicode_char jis2uni_tbl_3a[] = {
  0x6B64, 0x9803, 0x5AC8, 0x5ACF, 0x5ADA, 0x5ADC, 0x5AE0, 0x6068, 
  0x61C7, 0x660F, 0x6606, 0x6839, 0x68B1, 0x6DF7, 0x75D5, 0x7D3A, 
  0x826E, 0x9B42, 0x5B19, 0x5B1B, 0x5B1D, 0x5B21, 0x5D6F, 0x5DE6, 
  0x5DEE, 0x67FB, 0x6C99, 0x7473, 0x7802, 0x8A50, 0x9396, 0x88DF, 
  0x5B6E, 0x5EA7, 0x632B, 0x5B7D, 0x5B7E, 0x5B7F, 0x6700, 0x5B84, 
  0x5B86, 0x5B8A, 0x5BB0, 0x5F69, 0x624D, 0x63A1, 0x683D, 0x6B73, 
  0x6E08, 0x707D, 0x91C7, 0x7280, 0x7815, 0x7826, 0x796D, 0x658E, 
  0x7D30, 0x83DC, 0x88C1, 0x8F09, 0x969B, 0x5BCF, 0x5BD6, 0x6750, 
  0x7F6A, 0x8CA1, 0x5BDA, 0x5BE0, 0x962A, 0x5BF1, 0x698A, 0x80B4, 
  0x5C0C, 0x5D0E, 0x5C1E, 0x7895, 0x9DFA, 0x5C26, 0x5C29, 0x5C2B, 
  0x643E, 0x6628, 0x6714, 0x67F5, 0x7A84, 0x7B56, 0x7D22, 0x932F, 
  0x685C, 0x9BAD, 0x7B39, 0x5C67, 0x5C68, 0x5C69
};
static const unicode_char jis2uni_tbl_3b[] = {
  0x5C6D, 0x62F6, 0x64AE, 0x64E6, 0x672D, 0x6BBA, 0x85A9, 0x96D1, 
  0x7690, 0x9BD6, 0x634C, 0x9306, 0x9BAB, 0x76BF, 0x6652, 0x5CA0, 
  0x5CA2, 0x5CA3, 0x5CA6, 0x60E8, 0x6492, 0x6563, 0x685F, 0x71E6, 
  0x73CA, 0x7523, 0x7B97, 0x7E82, 0x8695, 0x8B83, 0x8CDB, 0x9178, 
  0x9910, 0x65AC, 0x66AB, 0x6B8B, 0x5D12, 0x5D2B, 0x5D23, 0x5D24, 
  0x5D26, 0x5D27, 0x5D31, 0x5D34, 0x5D39, 0x5D3D, 0x5D3F, 0x5D42, 
  0x5D43, 0x5D46, 0x5D48, 0x5E02, 0x5E2B, 0x5FD7, 0x601D, 0x6307, 
  0x652F, 0x5D61, 0x65AF, 0x65BD, 0x65E8, 0x679D, 0x6B62, 0x6B7B, 
  0x6C0F, 0x7345, 0x7949, 0x79C1, 0x7CF8, 0x7D19, 0x7D2B, 0x80A2, 
  0x8102, 0x81F3, 0x8996, 0x8A5E, 0x8A69, 0x8A66, 0x8A8C, 0x8AEE, 
  0x8CC7, 0x8CDC, 0x96CC, 0x98FC, 0x6B6F, 0x5DC3, 0x5DC7, 0x5DCB, 
  0x5DD0, 0x5DCE, 0x5DD8, 0x6148, 0x6301, 0x6642
};
static const unicode_char jis2uni_tbl_3c[] = {
  0x6B21, 0x6ECB, 0x6CBB, 0x723E, 0x74BD, 0x75D4, 0x78C1, 0x793A, 
  0x800C, 0x8033, 0x81EA, 0x8494, 0x8F9E, 0x6C50, 0x9E7F, 0x5F0F, 
  0x8B58, 0x9D2B, 0x7AFA, 0x8EF8, 0x5E51, 0x96EB, 0x5E58, 0x5E5B, 
  0x5E5C, 0x5E5E, 0x5E68, 0x5E6A, 0x6089, 0x6E7F, 0x6F06, 0x75BE, 
  0x8CEA, 0x5E80, 0x8500, 0x7BE0, 0x5EA2, 0x67F4, 0x829D, 0x5EA8, 
  0x854A, 0x7E1E, 0x820E, 0x5EB3, 0x5EBD, 0x6368, 0x8D66, 0x659C, 
  0x716E, 0x793E, 0x7D17, 0x8005, 0x8B1D, 0x8ECA, 0x906E, 0x86C7, 
  0x90AA, 0x5EE5, 0x5EEB, 0x5F02, 0x6753, 0x707C, 0x7235, 0x914C, 
  0x91C8, 0x932B, 0x82E5, 0x5F21, 0x5F31, 0x60F9, 0x5F24, 0x5F28, 
  0x5F2B, 0x624B, 0x6731, 0x6B8A, 0x72E9, 0x73E0, 0x7A2E, 0x816B, 
  0x8DA3, 0x9152, 0x9996, 0x5F45, 0x5F47, 0x5F4D, 0x5F50, 0x6388, 
  0x6A39, 0x7DAC, 0x9700, 0x5F63, 0x5F64, 0x5F67
};
static const unicode_char jis2uni_tbl_3d[] = {
  0x5F6F, 0x5F72, 0x5F74, 0x5F75, 0x6101, 0x62FE, 0x6D32, 0x79C0, 
  0x79CB, 0x7D42, 0x7E4D, 0x7FD2, 0x81ED, 0x821F, 0x8490, 0x8846, 
  0x8972, 0x8B90, 0x8E74, 0x8F2F, 0x9031, 0x914B, 0x916C, 0x96C6, 
  0x919C, 0x5FC8, 0x5FC9, 0x5FCB, 0x5FD0, 0x5FD1, 0x620E, 0x67D4, 
  0x6C41, 0x6E0B, 0x7363, 0x7E26, 0x91CD, 0x9283, 0x5FEA, 0x5FEC, 
  0x5FED, 0x6DD1, 0x795D, 0x7E2E, 0x7C9B, 0x5FF6, 0x719F, 0x5FFC, 
  0x8853, 0x8FF0, 0x600D, 0x6013, 0x6625, 0x77AC, 0x7AE3, 0x821C, 
  0x99FF, 0x6024, 0x602D, 0x65EC, 0x696F, 0x6B89, 0x6DF3, 0x6E96, 
  0x6F64, 0x76FE, 0x7D14, 0x6054, 0x9075, 0x9187, 0x9806, 0x6061, 
  0x6067, 0x6240, 0x6691, 0x66D9, 0x6E1A, 0x6086, 0x7DD2, 0x7F72, 
  0x66F8, 0x85AF, 0x85F7, 0x8AF8, 0x6098, 0x609D, 0x609E, 0x60A2, 
  0x60A4, 0x60A5, 0x92E4, 0x9664, 0x60B1, 0x60B7
};
static const unicode_char jis2uni_tbl_3e[] = {
  0x60BB, 0x60BE, 0x60C2, 0x60C4, 0x60C8, 0x60C9, 0x60CA, 0x60CB, 
  0x60CE, 0x60CF, 0x60D4, 0x60D5, 0x60D9, 0x60DB, 0x60DD, 0x60DE, 
  0x60E2, 0x60E5, 0x60F2, 0x60F5, 0x627F, 0x6284, 0x62DB, 0x638C, 
  0x6377, 0x6607, 0x660C, 0x662D, 0x6676, 0x677E, 0x68A2, 0x6A1F, 
  0x6A35, 0x6CBC, 0x6D88, 0x6E09, 0x6E58, 0x713C, 0x7126, 0x7167, 
  0x75C7, 0x7701, 0x785D, 0x7901, 0x7965, 0x79F0, 0x7AE0, 0x7B11, 
  0x7CA7, 0x7D39, 0x8096, 0x83D6, 0x848B, 0x8549, 0x885D, 0x88F3, 
  0x8A1F, 0x8A3C, 0x8A54, 0x8A73, 0x8C61, 0x8CDE, 0x91A4, 0x9266, 
  0x937E, 0x9418, 0x969C, 0x9798, 0x619C, 0x619D, 0x619F, 0x61A0, 
  0x61A5, 0x61A8, 0x61AA, 0x61AD, 0x61B8, 0x61B9, 0x61BC, 0x61C0, 
  0x64FE, 0x6761, 0x6756, 0x6D44, 0x72B6, 0x7573, 0x7A63, 0x84B8, 
  0x8B72, 0x91B8, 0x9320, 0x61E7, 0x61E9, 0x98FE
};
static const unicode_char jis2uni_tbl_3f[] = {
  0x62ED, 0x690D, 0x6B96, 0x71ED, 0x7E54, 0x8077, 0x8272, 0x89E6, 
  0x98DF, 0x8755, 0x8FB1, 0x6222, 0x6223, 0x6227, 0x6229, 0x622B, 
  0x6239, 0x623D, 0x6242, 0x6243, 0x6244, 0x632F, 0x65B0, 0x664B, 
  0x68EE, 0x699B, 0x6D78, 0x6DF1, 0x7533, 0x75B9, 0x771F, 0x795E, 
  0x79E6, 0x7D33, 0x81E3, 0x82AF, 0x85AA, 0x89AA, 0x8A3A, 0x8EAB, 
  0x8F9B, 0x9032, 0x91DD, 0x9707, 0x62B7, 0x62BA, 0x62BE, 0x62BF, 
  0x62C4, 0x62CE, 0x751A, 0x62D6, 0x814E, 0x8A0A, 0x8FC5, 0x9663, 
  0x976D, 0x7B25, 0x8ACF, 0x9808, 0x9162, 0x630B, 0x630D, 0x9017, 
  0x6313, 0x6316, 0x6318, 0x63A8, 0x6C34, 0x708A, 0x7761, 0x7C8B, 
  0x7FE0, 0x8870, 0x9042, 0x9154, 0x9310, 0x9318, 0x968F, 0x745E, 
  0x9AC4, 0x634E, 0x6352, 0x6570, 0x67A2, 0x8DA8, 0x96DB, 0x636E, 
  0x6749, 0x6919, 0x83C5, 0x9817, 0x96C0, 0x88FE
};
static const unicode_char jis2uni_tbl_40[] = {
  0x6F84, 0x647A, 0x637D, 0x637F, 0x702C, 0x755D, 0x662F, 0x638A, 
  0x6390, 0x6394, 0x6395, 0x6399, 0x639A, 0x639E, 0x653F, 0x6574, 
  0x661F, 0x6674, 0x68F2, 0x6816, 0x6B63, 0x6E05, 0x7272, 0x751F, 
  0x76DB, 0x7CBE, 0x8056, 0x63D5, 0x88FD, 0x897F, 0x8AA0, 0x8A93, 
  0x8ACB, 0x901D, 0x9192, 0x9752, 0x9759, 0x6589, 0x7A0E, 0x8106, 
  0x96BB, 0x6412, 0x6414, 0x6418, 0x65A5, 0x6614, 0x6790, 0x77F3, 
  0x7A4D, 0x7C4D, 0x7E3E, 0x810A, 0x8CAC, 0x8D64, 0x8DE1, 0x8E5F, 
  0x78A9, 0x644F, 0x6451, 0x6452, 0x6453, 0x6454, 0x8A2D, 0x7A83, 
  0x7BC0, 0x8AAC, 0x96EA, 0x7D76, 0x820C, 0x8749, 0x646D, 0x6473, 
  0x6474, 0x647B, 0x647D, 0x6485, 0x6487, 0x648F, 0x6490, 0x6491, 
  0x64B0, 0x6813, 0x6834, 0x6CC9, 0x6D45, 0x6D17, 0x67D3, 0x6F5C, 
  0x714E, 0x717D, 0x65CB, 0x7A7F, 0x7BAD, 0x7DDA
};
static const unicode_char jis2uni_tbl_41[] = {
  0x7E4A, 0x7FA8, 0x817A, 0x821B, 0x8239, 0x85A6, 0x8A6E, 0x8CCE, 
  0x8DF5, 0x9078, 0x9077, 0x92AD, 0x9291, 0x9583, 0x9BAE, 0x64F0, 
  0x64F5, 0x6F38, 0x7136, 0x64FF, 0x7985, 0x7E55, 0x81B3, 0x7CCE, 
  0x650A, 0x650F, 0x6513, 0x6514, 0x66FE, 0x66FD, 0x695A, 0x72D9, 
  0x758F, 0x758E, 0x790E, 0x7956, 0x79DF, 0x7C97, 0x7D20, 0x7D44, 
  0x8607, 0x8A34, 0x963B, 0x9061, 0x9F20, 0x6552, 0x6554, 0x655F, 
  0x6560, 0x6567, 0x656B, 0x657A, 0x657D, 0x723D, 0x6585, 0x658A, 
  0x6592, 0x6595, 0x6598, 0x659D, 0x65A0, 0x65A3, 0x65A6, 0x65AE, 
  0x65E9, 0x66F9, 0x65B4, 0x69CD, 0x69FD, 0x6F15, 0x71E5, 0x65CE, 
  0x75E9, 0x76F8, 0x7A93, 0x7CDF, 0x7DCF, 0x7D9C, 0x8061, 0x8349, 
  0x8358, 0x846C, 0x84BC, 0x85FB, 0x88C5, 0x8D70, 0x9001, 0x906D, 
  0x9397, 0x971C, 0x9A12, 0x6615, 0x6616, 0x661D
};
static const unicode_char jis2uni_tbl_42[] = {
  0x81D3, 0x8535, 0x8D08, 0x9020, 0x6624, 0x6626, 0x6629, 0x662A, 
  0x662B, 0x662C, 0x675F, 0x6E2C, 0x8DB3, 0x901F, 0x6639, 0x6637, 
  0x8CCA, 0x6645, 0x7D9A, 0x664A, 0x8896, 0x6651, 0x664E, 0x6657, 
  0x6658, 0x6659, 0x665B, 0x6751, 0x905C, 0x6661, 0x66FB, 0x666A, 
  0x6C70, 0x8A51, 0x667E, 0x6673, 0x6675, 0x667F, 0x6677, 0x67C1, 
  0x8235, 0x6955, 0x9640, 0x99C4, 0x9A28, 0x668C, 0x668D, 0x6690, 
  0x8010, 0x6699, 0x669A, 0x669B, 0x669C, 0x669F, 0x66A0, 0x66FF, 
  0x6CF0, 0x6EDE, 0x80CE, 0x817F, 0x82D4, 0x888B, 0x8CB8, 0x9000, 
  0x902E, 0x968A, 0x9EDB, 0x9BDB, 0x66CF, 0x66D4, 0x66DB, 0x7B2C, 
  0x918D, 0x984C, 0x9DF9, 0x6EDD, 0x7027, 0x6705, 0x6707, 0x670E, 
  0x6713, 0x6719, 0x671C, 0x6CA2, 0x6FEF, 0x7422, 0x8A17, 0x9438, 
  0x6FC1, 0x8AFE, 0x8338, 0x6754, 0x86F8, 0x675D
};
static const unicode_char jis2uni_tbl_43[] = {
  0x6766, 0x676C, 0x9054, 0x8FB0, 0x6776, 0x8131, 0x6781, 0x7AEA, 
  0x8FBF, 0x68DA, 0x8C37, 0x72F8, 0x9C48, 0x6A3D, 0x8AB0, 0x679B, 
  0x67B0, 0x67B1, 0x67B2, 0x67B5, 0x67BB, 0x67BC, 0x6B4E, 0x6DE1, 
  0x6E5B, 0x70AD, 0x77ED, 0x7AEF, 0x7BAA, 0x7DBB, 0x803D, 0x80C6, 
  0x86CB, 0x8A95, 0x935B, 0x67E6, 0x67F0, 0x67F2, 0x67F6, 0x67F7, 
  0x6A80, 0x6BB5, 0x7537, 0x8AC7, 0x681F, 0x77E5, 0x6827, 0x682C, 
  0x682D, 0x682F, 0x6C60, 0x75F4, 0x7A1A, 0x7F6E, 0x81F4, 0x8718, 
  0x9045, 0x99B3, 0x7BC9, 0x755C, 0x7AF9, 0x7B51, 0x84C4, 0x9010, 
  0x79E9, 0x7A92, 0x8336, 0x6871, 0x7740, 0x6875, 0x6879, 0x687A, 
  0x687B, 0x687C, 0x6882, 0x6884, 0x6CE8, 0x866B, 0x8877, 0x8A3B, 
  0x914E, 0x92F3, 0x99D0, 0x6A17, 0x7026, 0x732A, 0x82E7, 0x8457, 
  0x8CAF, 0x68BB, 0x68C5, 0x68C8, 0x68CC, 0x68CF
};
static const unicode_char jis2uni_tbl_44[] = {
  0x68D0, 0x68D1, 0x68D3, 0x68D6, 0x68D9, 0x68DC, 0x68DD, 0x68E5, 
  0x68E8, 0x68EA, 0x68EB, 0x6F6E, 0x7252, 0x753A, 0x773A, 0x8074, 
  0x8139, 0x8178, 0x8776, 0x8ABF, 0x8ADC, 0x8D85, 0x8DF3, 0x929A, 
  0x9577, 0x9802, 0x9CE5, 0x6917, 0x6931, 0x76F4, 0x6935, 0x6C88, 
  0x73CD, 0x8CC3, 0x93AE, 0x9673, 0x6D25, 0x6957, 0x695B, 0x69CC, 
  0x8FFD, 0x939A, 0x75DB, 0x901A, 0x6969, 0x696C, 0x6970, 0x69FB, 
  0x6972, 0x6F2C, 0x697B, 0x8FBB, 0x8526, 0x7DB4, 0x9354, 0x6996, 
  0x6F70, 0x69A1, 0x69A5, 0x69A6, 0x7D2C, 0x722A, 0x69AD, 0x91E3, 
  0x9DB4, 0x69B8, 0x69BA, 0x69BC, 0x69C5, 0x69C8, 0x8C9E, 0x69D6, 
  0x69D7, 0x69E2, 0x69E5, 0x69EE, 0x69EF, 0x69F1, 0x69F3, 0x69F5, 
  0x69FE, 0x6A00, 0x6A01, 0x6A03, 0x6C40, 0x7887, 0x798E, 0x7A0B, 
  0x7DE0, 0x8247, 0x8A02, 0x8AE6, 0x8E44, 0x9013
};
static const unicode_char jis2uni_tbl_45[] = {
  0x90B8, 0x912D, 0x91D8, 0x9F0E, 0x6CE5, 0x6A45, 0x6A46, 0x6A49, 
  0x6EF4, 0x7684, 0x7B1B, 0x9069, 0x93D1, 0x6EBA, 0x6A56, 0x6A5B, 
  0x6A64, 0x8F4D, 0x8FED, 0x9244, 0x6A73, 0x6A7E, 0x6A81, 0x6A83, 
  0x6A86, 0x6DFB, 0x7E8F, 0x751C, 0x8CBC, 0x8EE2, 0x985B, 0x70B9, 
  0x6A9F, 0x6BBF, 0x6FB1, 0x7530, 0x96FB, 0x6AB1, 0x6AB4, 0x6ABD, 
  0x6ABE, 0x6ABF, 0x6AC6, 0x6AC9, 0x6AC8, 0x6ACC, 0x6E21, 0x767B, 
  0x83DF, 0x8CED, 0x9014, 0x90FD, 0x934D, 0x7825, 0x783A, 0x6AF0, 
  0x6AF1, 0x6AF2, 0x6AFC, 0x6AFD, 0x6B02, 0x6B03, 0x6B06, 0x6B07, 
  0x6B09, 0x6B0F, 0x6B10, 0x6B11, 0x6B17, 0x6B1B, 0x6B1E, 0x6B24, 
  0x6B28, 0x6B2B, 0x6B2C, 0x6B2F, 0x6B35, 0x6B36, 0x6B3B, 0x76D7, 
  0x6DD8, 0x6E6F, 0x6D9B, 0x706F, 0x71C8, 0x6B58, 0x75D8, 0x7977, 
  0x7B49, 0x7B54, 0x7B52, 0x7CD6, 0x7D71, 0x6B7D
};
static const unicode_char jis2uni_tbl_46[] = {
  0x8463, 0x8569, 0x85E4, 0x8A0E, 0x8B04, 0x8C46, 0x8E0F, 0x9003, 
  0x900F, 0x9419, 0x9676, 0x982D, 0x9A30, 0x95D8, 0x6BB0, 0x6BB8, 
  0x6BB9, 0x6BBD, 0x6BBE, 0x6BC3, 0x6BC4, 0x6D1E, 0x77B3, 0x7AE5, 
  0x80F4, 0x8404, 0x9053, 0x9285, 0x6BE7, 0x9D07, 0x6BF1, 0x6BF7, 
  0x6BF9, 0x6D9C, 0x7279, 0x7763, 0x79BF, 0x7BE4, 0x6C0D, 0x72EC, 
  0x8AAD, 0x6C12, 0x6C19, 0x6C1F, 0x7A81, 0x6C27, 0x6C28, 0x9CF6, 
  0x82EB, 0x6C33, 0x9149, 0x701E, 0x6C3A, 0x6C3B, 0x6C3F, 0x6C4A, 
  0x6C8C, 0x8C5A, 0x9041, 0x9813, 0x6C54, 0x6C59, 0x920D, 0x6C5C, 
  0x90A3, 0x6C6D, 0x6C6F, 0x6C74, 0x8599, 0x8B0E, 0x7058, 0x6C7B, 
  0x934B, 0x6C86, 0x99B4, 0x7E04, 0x7577, 0x6C95, 0x6C97, 0x8EDF, 
  0x96E3, 0x6C9F, 0x6CB0, 0x6CB2, 0x6CB4, 0x8FE9, 0x6CC6, 0x8CD1, 
  0x8089, 0x8679, 0x6CD1, 0x6CD2, 0x6CD4, 0x6CD6
};
static const unicode_char jis2uni_tbl_47[] = {
  0x6CDA, 0x6CDC, 0x97EE, 0x6CE7, 0x6CE9, 0x6CEB, 0x8A8D, 0x6FE1, 
  0x79B0, 0x7962, 0x6D04, 0x8471, 0x732B, 0x71B1, 0x6D0F, 0x6D11, 
  0x6D13, 0x6D1A, 0x71C3, 0x7C98, 0x6D28, 0x6C67, 0x6D2E, 0x6D2F, 
  0x6D31, 0x6D39, 0x6FC3, 0x7D0D, 0x80FD, 0x8133, 0x81BF, 0x8FB2, 
  0x8997, 0x86A4, 0x6D6F, 0x6D70, 0x6D7C, 0x8987, 0x6D87, 0x6D91, 
  0x6D92, 0x7436, 0x7834, 0x6D97, 0x7F75, 0x82AD, 0x99AC, 0x6DB4, 
  0x6DB7, 0x6DB9, 0x6DBD, 0x6DBF, 0x6DC4, 0x76C3, 0x724C, 0x80CC, 
  0x80BA, 0x8F29, 0x914D, 0x6DDD, 0x6DDF, 0x6DE0, 0x6DE2, 0x6DE5, 
  0x7164, 0x72FD, 0x8CB7, 0x6DF4, 0x8CE0, 0x966A, 0x9019, 0x877F, 
  0x79E4, 0x77E7, 0x8429, 0x6E32, 0x6E36, 0x6E39, 0x6E3B, 0x6E3C, 
  0x6E44, 0x767D, 0x7B94, 0x7C95, 0x8236, 0x8584, 0x8FEB, 0x6E52, 
  0x6F20, 0x7206, 0x7E1B, 0x83AB, 0x99C1, 0x9EA6
};
static const unicode_char jis2uni_tbl_48[] = {
  0x6E62, 0x7BB1, 0x7872, 0x7BB8, 0x8087, 0x7B48, 0x6E8D, 0x6E93, 
  0x808C, 0x7551, 0x7560, 0x6EAD, 0x9262, 0x6EB1, 0x767A, 0x9197, 
  0x9AEA, 0x6EC0, 0x7F70, 0x6EC3, 0x7B4F, 0x95A5, 0x9CE9, 0x6ECD, 
  0x6ECE, 0x86E4, 0x96BC, 0x6EED, 0x6EEE, 0x6EF9, 0x6EFB, 0x6EFD, 
  0x6F04, 0x6F08, 0x6F0A, 0x6F0C, 0x6F0D, 0x6F16, 0x7248, 0x72AF, 
  0x73ED, 0x7554, 0x7E41, 0x822C, 0x85E9, 0x8CA9, 0x7BC4, 0x91C6, 
  0x7169, 0x9812, 0x98EF, 0x6F4F, 0x6F51, 0x756A, 0x76E4, 0x78D0, 
  0x8543, 0x86EE, 0x6F5D, 0x6F5E, 0x6F61, 0x6F62, 0x6F68, 0x6F6C, 
  0x6F7D, 0x6F7E, 0x6F83, 0x6F87, 0x6F88, 0x6F8B, 0x6F8C, 0x75B2, 
  0x76AE, 0x7891, 0x79D8, 0x7DCB, 0x7F77, 0x80A5, 0x88AB, 0x8AB9, 
  0x8CBB, 0x907F, 0x975E, 0x98DB, 0x6FAE, 0x7C38, 0x6FB0, 0x6FB5, 
  0x6FB6, 0x6FBC, 0x6FC5, 0x7435, 0x7709, 0x7F8E
};
static const unicode_char jis2uni_tbl_49[] = {
  0x9F3B, 0x6FDE, 0x7A17, 0x6FE9, 0x758B, 0x9AED, 0x6FF9, 0x819D, 
  0x83F1, 0x8098, 0x7005, 0x7006, 0x7562, 0x7B46, 0x903C, 0x7020, 
  0x7023, 0x702F, 0x7D10, 0x767E, 0x8B2C, 0x703C, 0x7043, 0x7044, 
  0x7048, 0x7049, 0x74E2, 0x7968, 0x8868, 0x8A55, 0x8C79, 0x705E, 
  0x704E, 0x75C5, 0x79D2, 0x82D7, 0x9328, 0x92F2, 0x849C, 0x86ED, 
  0x9C2D, 0x7085, 0x7086, 0x7094, 0x7095, 0x7096, 0x8CA7, 0x8CD3, 
  0x983B, 0x70A4, 0x74F6, 0x70B0, 0x70B1, 0x70B4, 0x70B7, 0x70CA, 
  0x70D1, 0x70D3, 0x70D4, 0x70D5, 0x70D6, 0x70D8, 0x70DC, 0x70E4, 
  0x70FA, 0x7103, 0x7236, 0x7B26, 0x8150, 0x819A, 0x8299, 0x8B5C, 
  0x8CA0, 0x8CE6, 0x8D74, 0x961C, 0x9644, 0x712F, 0x7130, 0x7131, 
  0x821E, 0x8461, 0x856A, 0x90E8, 0x7147, 0x714A, 0x98A8, 0x847A, 
  0x8557, 0x7157, 0x715A, 0x715C, 0x715E, 0x7160
};
static const unicode_char jis2uni_tbl_4a[] = {
  0x798F, 0x8179, 0x8907, 0x8986, 0x7187, 0x718C, 0x7192, 0x719A, 
  0x719B, 0x7269, 0x9B92, 0x71AF, 0x71B0, 0x71B2, 0x71B3, 0x71BA, 
  0x71BF, 0x71C0, 0x71C1, 0x7C89, 0x7CDE, 0x7D1B, 0x96F0, 0x71D6, 
  0x805E, 0x71DA, 0x71DC, 0x71F8, 0x71FE, 0x7200, 0x7207, 0x7208, 
  0x7209, 0x7213, 0x853D, 0x9589, 0x965B, 0x7C73, 0x9801, 0x722B, 
  0x722F, 0x7656, 0x78A7, 0x7239, 0x77A5, 0x8511, 0x7B86, 0x7245, 
  0x724E, 0x724F, 0x7BC7, 0x7DE8, 0x8FBA, 0x8FD4, 0x904D, 0x725C, 
  0x725E, 0x7260, 0x7263, 0x97AD, 0x726B, 0x8217, 0x92EA, 0x7271, 
  0x7277, 0x7278, 0x752B, 0x88DC, 0x8F14, 0x7A42, 0x7289, 0x728D, 
  0x728E, 0x7293, 0x729B, 0x72A8, 0x7C3F, 0x83E9, 0x72B1, 0x72B4, 
  0x72BE, 0x72C1, 0x72C7, 0x72C9, 0x72CC, 0x72D5, 0x72D6, 0x72D8, 
  0x72DF, 0x72E5, 0x72F3, 0x72F4, 0x72FA, 0x72FB
};
static const unicode_char jis2uni_tbl_4b[] = {
  0x72FE, 0x7302, 0x7304, 0x7832, 0x7E2B, 0x80DE, 0x82B3, 0x840C, 
  0x84EC, 0x8702, 0x8912, 0x8A2A, 0x8C4A, 0x90A6, 0x92D2, 0x98FD, 
  0x9CF3, 0x9D6C, 0x7332, 0x7335, 0x733A, 0x733B, 0x733D, 0x7343, 
  0x734D, 0x7350, 0x7352, 0x7356, 0x7358, 0x735D, 0x735E, 0x735F, 
  0x7360, 0x7D21, 0x80AA, 0x81A8, 0x8B00, 0x8C8C, 0x8CBF, 0x927E, 
  0x9632, 0x7377, 0x982C, 0x737C, 0x7380, 0x7381, 0x7383, 0x7385, 
  0x7386, 0x738E, 0x7766, 0x7A46, 0x91E6, 0x7397, 0x7398, 0x739C, 
  0x739E, 0x739F, 0x73A0, 0x73A2, 0x7FFB, 0x73A6, 0x76C6, 0x73AB, 
  0x78E8, 0x9B54, 0x9EBB, 0x73B9, 0x73BC, 0x73BD, 0x73BF, 0x73C5, 
  0x73C6, 0x73C9, 0x73CB, 0x819C, 0x73CF, 0x9BAA, 0x73D3, 0x9C52, 
  0x73D9, 0x73DD, 0x73E1, 0x73E3, 0x73E6, 0x73E7, 0x73E9, 0x8FC4, 
  0x73F5, 0x7E6D, 0x9EBF, 0x73FA, 0x73FB, 0x73FD
};
static const unicode_char jis2uni_tbl_4c[] = {
  0x73FF, 0x8513, 0x7401, 0x7404, 0x9B45, 0x740A, 0x7B95, 0x741A, 
  0x741B, 0x871C, 0x7426, 0x84D1, 0x7A14, 0x8108, 0x742B, 0x7C8D, 
  0x742D, 0x7720, 0x742F, 0x7430, 0x7431, 0x7439, 0x77DB, 0x9727, 
  0x9D61, 0x7446, 0x7447, 0x744B, 0x744D, 0x7451, 0x7452, 0x7457, 
  0x76DF, 0x8FF7, 0x9298, 0x9CF4, 0x7468, 0x746B, 0x746D, 0x746E, 
  0x7471, 0x7DBF, 0x7DEC, 0x9762, 0x9EBA, 0x7486, 0x7487, 0x8302, 
  0x748F, 0x7490, 0x7491, 0x7492, 0x76F2, 0x7DB2, 0x8017, 0x8499, 
  0x749F, 0x74A0, 0x9ED9, 0x76EE, 0x74A6, 0x74A8, 0x9905, 0x74AA, 
  0x74AB, 0x7C7E, 0x8CB0, 0x74B1, 0x74B2, 0x7D0B, 0x9580, 0x74BB, 
  0x74BF, 0x74C8, 0x74C9, 0x74CC, 0x8036, 0x91CE, 0x74D8, 0x77E2, 
  0x74DB, 0x74DE, 0x7D04, 0x85AC, 0x8A33, 0x8E8D, 0x9756, 0x74EF, 
  0x85AE, 0x9453, 0x74FB, 0x74FC, 0x74FF, 0x7652
};
static const unicode_char jis2uni_tbl_4d[] = {
  0x8AED, 0x8F38, 0x7517, 0x7520, 0x7521, 0x7524, 0x7527, 0x7529, 
  0x752A, 0x752F, 0x7536, 0x7539, 0x753D, 0x753E, 0x753F, 0x7540, 
  0x7543, 0x7547, 0x7548, 0x7950, 0x88D5, 0x8A98, 0x904A, 0x9091, 
  0x90F5, 0x96C4, 0x878D, 0x7571, 0x7579, 0x757A, 0x757B, 0x8A89, 
  0x8F3F, 0x9810, 0x7581, 0x7585, 0x7590, 0x7592, 0x7593, 0x7595, 
  0x7599, 0x759C, 0x75A2, 0x75A4, 0x75B4, 0x75BA, 0x75BF, 0x75C0, 
  0x75C1, 0x7AAF, 0x7F8A, 0x8000, 0x8449, 0x84C9, 0x8981, 0x8B21, 
  0x8E0A, 0x9065, 0x967D, 0x990A, 0x75E7, 0x75EC, 0x75EE, 0x75EF, 
  0x75F1, 0x7FCC, 0x7FFC, 0x7602, 0x7F85, 0x87BA, 0x88F8, 0x7608, 
  0x83B1, 0x983C, 0x96F7, 0x7612, 0x7D61, 0x843D, 0x916A, 0x7619, 
  0x761B, 0x761C, 0x761D, 0x761E, 0x85CD, 0x862D, 0x89A7, 0x7629, 
  0x762D, 0x7632, 0x7633, 0x7635, 0x7638, 0x7639
};
static const unicode_char jis2uni_tbl_4e[] = {
  0x763A, 0x88CF, 0x88E1, 0x91CC, 0x96E2, 0x9678, 0x7644, 0x7645, 
  0x7ACB, 0x844E, 0x7655, 0x7659, 0x765F, 0x7664, 0x7665, 0x766D, 
  0x766E, 0x786B, 0x7C92, 0x9686, 0x7ADC, 0x9F8D, 0x768C, 0x768D, 
  0x7695, 0x865C, 0x769C, 0x769D, 0x769F, 0x76A0, 0x76A2, 0x76A3, 
  0x76A4, 0x76A5, 0x76A6, 0x76A7, 0x76A8, 0x77AD, 0x7A1C, 0x7CE7, 
  0x826F, 0x8AD2, 0x907C, 0x91CF, 0x9675, 0x9818, 0x76D4, 0x7DD1, 
  0x76E0, 0x76E6, 0x76E8, 0x76EC, 0x76F0, 0x76F1, 0x81E8, 0x8F2A, 
  0x96A3, 0x9C57, 0x9E9F, 0x770A, 0x770E, 0x7712, 0x7D2F, 0x985E, 
  0x7717, 0x7719, 0x771A, 0x771C, 0x7722, 0x7728, 0x772D, 0x772E, 
  0x793C, 0x82D3, 0x9234, 0x96B7, 0x96F6, 0x970A, 0x9E97, 0x9F62, 
  0x7745, 0x7746, 0x774A, 0x774D, 0x774E, 0x88C2, 0x7752, 0x7756, 
  0x7757, 0x775C, 0x775E, 0x7C3E, 0x7DF4, 0x806F
};
static const unicode_char jis2uni_tbl_4f[] = {
  0x84EE, 0x9023, 0x932C, 0x776C, 0x9B6F, 0x7772, 0x7773, 0x8CC2, 
  0x8DEF, 0x9732, 0x7780, 0x7784, 0x778C, 0x778D, 0x7794, 0x7795, 
  0x7796, 0x779A, 0x779F, 0x77A2, 0x77A7, 0x7BED, 0x8001, 0x807E, 
  0x874B, 0x90CE, 0x77BE, 0x9E93, 0x7984, 0x808B, 0x9332, 0x8AD6, 
  0x77D9, 0x77DE, 0x8A71, 0x77E0, 0x8CC4, 0x8107, 0x77EA, 0x77EC, 
  0x9DF2, 0x77F1, 0x77F4, 0x9C10, 0x8A6B, 0x85C1, 0x8568, 0x7809, 
  0x780D, 0x7897, 0x8155, 0x781D, 0x7821, 0x7822, 0x7823, 0x782D, 
  0x782E, 0x7830, 0x7835, 0x7837, 0x7843, 0x7844, 0x7847, 0x7848, 
  0x784C, 0x784E, 0x7852, 0x785C, 0x785E, 0x7860, 0x7861, 0x7863, 
  0x7864, 0x7868, 0x786A, 0x786E, 0x787A, 0x787E, 0x788A, 0x788F, 
  0x7894, 0x7898, 0x78A1, 0x789D, 0x789E, 0x789F, 0x78A4, 0x78A8, 
  0x78AC, 0x78AD, 0x78B0, 0x78B1, 0x78B2, 0x78B3
};
static const unicode_char jis2uni_tbl_50[] = {
  0x78BB, 0x78BD, 0x78BF, 0x78C7, 0x78C8, 0x78C9, 0x78CC, 0x78CE, 
  0x78D2, 0x78D3, 0x78D5, 0x78D6, 0x78E4, 0x8C6B, 0x78DF, 0x8212, 
  0x78E1, 0x78E6, 0x78EA, 0x78F2, 0x78F3, 0x7900, 0x78F6, 0x78F7, 
  0x78FA, 0x78FB, 0x78FF, 0x7906, 0x790C, 0x7910, 0x791A, 0x791C, 
  0x791E, 0x791F, 0x7920, 0x7925, 0x7927, 0x7929, 0x792D, 0x7931, 
  0x7934, 0x7935, 0x793B, 0x793D, 0x793F, 0x7944, 0x7945, 0x7946, 
  0x794A, 0x794B, 0x794F, 0x7951, 0x7954, 0x7958, 0x795B, 0x795C, 
  0x7967, 0x7969, 0x796B, 0x7972, 0x7979, 0x797B, 0x797C, 0x797E, 
  0x798B, 0x798C, 0x7991, 0x7993, 0x7994, 0x7995, 0x7996, 0x7998, 
  0x799B, 0x799C, 0x79A1, 0x79A8, 0x79A9, 0x79AB, 0x79AF, 0x79B1, 
  0x79B4, 0x79B8, 0x79BB, 0x79C2, 0x79C4, 0x79C7, 0x79C8, 0x79CA, 
  0x79CF, 0x79D4, 0x79D6, 0x79DA, 0x79DD, 0x79DE
};
static const unicode_char jis2uni_tbl_51[] = {
  0x79E0, 0x79E2, 0x79E5, 0x79EA, 0x79EB, 0x79ED, 0x79F1, 0x79F8, 
  0x79FC, 0x7A02, 0x7A03, 0x7A07, 0x7A09, 0x7A0A, 0x7A0C, 0x7A11, 
  0x7A15, 0x7A1B, 0x7A1E, 0x7A21, 0x7A27, 0x7A2B, 0x7A2D, 0x7A2F, 
  0x7A30, 0x7A34, 0x7A35, 0x7A38, 0x7A39, 0x7A3A, 0x7AF8, 0x7A45, 
  0x7A47, 0x7A48, 0x7A4C, 0x7A55, 0x7A56, 0x7A59, 0x7A5C, 0x7A5D, 
  0x7A5F, 0x7A60, 0x7A65, 0x7A67, 0x7A6A, 0x7A6D, 0x7A75, 0x7A78, 
  0x7A7E, 0x7A80, 0x7A82, 0x7A85, 0x7A86, 0x7A8A, 0x7A8B, 0x7A90, 
  0x7A91, 0x7A94, 0x7A9E, 0x7AA0, 0x8655, 0x7AAC, 0x7AB3, 0x7AB5, 
  0x7AB9, 0x7ABB, 0x7ABC, 0x7AC6, 0x7AC9, 0x7ACC, 0x7ACE, 0x7AD1, 
  0x7ADB, 0x7AE8, 0x7AE9, 0x7AEB, 0x7AEC, 0x7AF1, 0x7AF4, 0x7AFB, 
  0x7AFD, 0x7AFE, 0x7B07, 0x7B14, 0x7B1F, 0x7B23, 0x7B27, 0x7B29, 
  0x7B2A, 0x7B2B, 0x7B2D, 0x7B2E, 0x7B2F, 0x8FA8
};
static const unicode_char jis2uni_tbl_52[] = {
  0x8FA7, 0x7B34, 0x7B3D, 0x7B3F, 0x7B40, 0x7B41, 0x7B47, 0x7B4E, 
  0x7B55, 0x7B60, 0x7B64, 0x98ED, 0x7B69, 0x7B6A, 0x7B6D, 0x7B6F, 
  0x7B72, 0x7B73, 0x7B77, 0x7B84, 0x7B89, 0x7B8E, 0x7B90, 0x7B91, 
  0x7B96, 0x7B9B, 0x7B9E, 0x7BA0, 0x7BA5, 0x7BAC, 0x7BAF, 0x7BB0, 
  0x7BB2, 0x7BB5, 0x7BB6, 0x7BBA, 0x7BBB, 0x7BBC, 0x7BBD, 0x7BC2, 
  0x7BC5, 0x7BC8, 0x7BCA, 0x7BD4, 0x7BD6, 0x7BD7, 0x7BD9, 0x7BDA, 
  0x7BDB, 0x7BE8, 0x7BEA, 0x7BF2, 0x7C12, 0x96D9, 0x7BF8, 0x7BF9, 
  0x7BFA, 0x7BFC, 0x7BFE, 0x7C01, 0x7C02, 0x7C03, 0x7C04, 0x7C06, 
  0x7C09, 0x7C0B, 0x7C0C, 0x7C0E, 0x7C0F, 0x7C19, 0x7C1B, 0x7C20, 
  0x7C25, 0x7C26, 0x7C28, 0x7C2C, 0x7C31, 0x7C33, 0x7C34, 0x7C36, 
  0x7C39, 0x7C3A, 0x7C46, 0x7C4A, 0x7C55, 0x7C51, 0x7C52, 0x7C53, 
  0x7C59, 0x7C5A, 0x7C5B, 0x7C5C, 0x7C5D, 0x7C5E
};
static const unicode_char jis2uni_tbl_53[] = {
  0x7C61, 0x7C63, 0x7C67, 0x7C69, 0x7C6D, 0x7C6E, 0x7C70, 0x7C72, 
  0x7C79, 0x7C7C, 0x7C7D, 0x7C86, 0x7C87, 0x7C8F, 0x7C94, 0x7C9E, 
  0x7CA0, 0x7CA6, 0x7CB0, 0x7CB6, 0x7CB7, 0x7CBA, 0x7CBB, 0x7CBC, 
  0x7CBF, 0x7CC4, 0x7CC7, 0x7CC8, 0x7CC9, 0x7CCD, 0x7CCF, 0x7CD3, 
  0x7CD4, 0x7CD5, 0x7CD7, 0x7CD9, 0x7CDA, 0x7CDD, 0x7CE6, 0x7CE9, 
  0x7CEB, 0x7CF5, 0x7D03, 0x7D07, 0x7D08, 0x7D09, 0x7D0F, 0x7D11, 
  0x7D12, 0x7D13, 0x7D16, 0x7D1D, 0x7D1E, 0x7D23, 0x7D26, 0x7D2A, 
  0x7D2D, 0x7D31, 0x7D3C, 0x7D3D, 0x7D3E, 0x7D40, 0x7D41, 0x7D47, 
  0x7D48, 0x7D4D, 0x7D51, 0x7D53, 0x7D57, 0x7D59, 0x7D5A, 0x7D5C, 
  0x7D5D, 0x7D65, 0x7D67, 0x7D6A, 0x7D70, 0x7D78, 0x7D7A, 0x7D7B, 
  0x7D7F, 0x7D81, 0x7D82, 0x7D83, 0x7D85, 0x7D86, 0x7D88, 0x7D8B, 
  0x7D8C, 0x7D8D, 0x7D91, 0x7D96, 0x7D97, 0x7D9D
};
static const unicode_char jis2uni_tbl_54[] = {
  0x7D9E, 0x7DA6, 0x7DA7, 0x7DAA, 0x7DB3, 0x7DB6, 0x7DB7, 0x7DB9, 
  0x7DC2, 0x7DC3, 0x7DC4, 0x7DC5, 0x7DC6, 0x7DCC, 0x7DCD, 0x7DCE, 
  0x7DD7, 0x7DD9, 0x7E00, 0x7DE2, 0x7DE5, 0x7DE6, 0x7DEA, 0x7DEB, 
  0x7DED, 0x7DF1, 0x7DF5, 0x7DF6, 0x7DF9, 0x7DFA, 0x7E08, 0x7E10, 
  0x7E11, 0x7E15, 0x7E17, 0x7E1C, 0x7E1D, 0x7E20, 0x7E27, 0x7E28, 
  0x7E2C, 0x7E2D, 0x7E2F, 0x7E33, 0x7E36, 0x7E3F, 0x7E44, 0x7E45, 
  0x7E47, 0x7E4E, 0x7E50, 0x7E52, 0x7E58, 0x7E5F, 0x7E61, 0x7E62, 
  0x7E65, 0x7E6B, 0x7E6E, 0x7E6F, 0x7E73, 0x7E78, 0x7E7E, 0x7E81, 
  0x7E86, 0x7E87, 0x7E8A, 0x7E8D, 0x7E91, 0x7E95, 0x7E98, 0x7E9A, 
  0x7E9D, 0x7E9E, 0x7F3C, 0x7F3B, 0x7F3D, 0x7F3E, 0x7F3F, 0x7F43, 
  0x7F44, 0x7F47, 0x7F4F, 0x7F52, 0x7F53, 0x7F5B, 0x7F5C, 0x7F5D, 
  0x7F61, 0x7F63, 0x7F64, 0x7F65, 0x7F66, 0x7F6D
};
static const unicode_char jis2uni_tbl_55[] = {
  0x7F71, 0x7F7D, 0x7F7E, 0x7F7F, 0x7F80, 0x7F8B, 0x7F8D, 0x7F8F, 
  0x7F90, 0x7F91, 0x7F96, 0x7F97, 0x7F9C, 0x7FA1, 0x7FA2, 0x7FA6, 
  0x7FAA, 0x7FAD, 0x7FB4, 0x7FBC, 0x7FBF, 0x7FC0, 0x7FC3, 0x7FC8, 
  0x7FCE, 0x7FCF, 0x7FDB, 0x7FDF, 0x7FE3, 0x7FE5, 0x7FE8, 0x7FEC, 
  0x7FEE, 0x7FEF, 0x7FF2, 0x7FFA, 0x7FFD, 0x7FFE, 0x7FFF, 0x8007, 
  0x8008, 0x800A, 0x800D, 0x800E, 0x800F, 0x8011, 0x8013, 0x8014, 
  0x8016, 0x801D, 0x801E, 0x801F, 0x8020, 0x8024, 0x8026, 0x802C, 
  0x802E, 0x8030, 0x8034, 0x8035, 0x8037, 0x8039, 0x803A, 0x803C, 
  0x803E, 0x8040, 0x8044, 0x8060, 0x8064, 0x8066, 0x806D, 0x8071, 
  0x8075, 0x8081, 0x8088, 0x808E, 0x809C, 0x809E, 0x80A6, 0x80A7, 
  0x80AB, 0x80B8, 0x80B9, 0x80C8, 0x80CD, 0x80CF, 0x80D2, 0x80D4, 
  0x80D5, 0x80D7, 0x80D8, 0x80E0, 0x80ED, 0x80EE
};
static const unicode_char jis2uni_tbl_56[] = {
  0x80F0, 0x80F2, 0x80F3, 0x80F6, 0x80F9, 0x80FA, 0x80FE, 0x8103, 
  0x810B, 0x8116, 0x8117, 0x8118, 0x811C, 0x811E, 0x8120, 0x8124, 
  0x8127, 0x812C, 0x8130, 0x8135, 0x813A, 0x813C, 0x8145, 0x8147, 
  0x814A, 0x814C, 0x8152, 0x8157, 0x8160, 0x8161, 0x8167, 0x8168, 
  0x8169, 0x816D, 0x816F, 0x8177, 0x8181, 0x8190, 0x8184, 0x8185, 
  0x8186, 0x818B, 0x818E, 0x8196, 0x8198, 0x819B, 0x819E, 0x81A2, 
  0x81AE, 0x81B2, 0x81B4, 0x81BB, 0x81CB, 0x81C3, 0x81C5, 0x81CA, 
  0x81CE, 0x81CF, 0x81D5, 0x81D7, 0x81DB, 0x81DD, 0x81DE, 0x81E1, 
  0x81E4, 0x81EB, 0x81EC, 0x81F0, 0x81F1, 0x81F2, 0x81F5, 0x81F6, 
  0x81F8, 0x81F9, 0x81FD, 0x81FF, 0x8200, 0x8203, 0x820F, 0x8213, 
  0x8214, 0x8219, 0x821A, 0x821D, 0x8221, 0x8222, 0x9EBC, 0x8232, 
  0x8234, 0x823A, 0x8243, 0x8244, 0x8245, 0x8246
};
static const unicode_char jis2uni_tbl_57[] = {
  0x824B, 0x824E, 0x824F, 0x8251, 0x8256, 0x825C, 0x8260, 0x8263, 
  0x8267, 0x826D, 0x8274, 0x827B, 0x827D, 0x827F, 0x8280, 0x8281, 
  0x8283, 0x8284, 0x8287, 0x8289, 0x828A, 0x828E, 0x8291, 0x8294, 
  0x8296, 0x8298, 0x829A, 0x829B, 0x82A0, 0x82A1, 0x82A3, 0x82A4, 
  0x82A7, 0x82A8, 0x82A9, 0x82AA, 0x82AE, 0x82B0, 0x82B2, 0x82B4, 
  0x82B7, 0x82BA, 0x82BC, 0x82BE, 0x82BF, 0x82C6, 0x82D0, 0x82D5, 
  0x82DA, 0x82E0, 0x82E2, 0x82E4, 0x82E8, 0x82EA, 0x82ED, 0x82EF, 
  0x82F6, 0x82F7, 0x82FD, 0x82FE, 0x8300, 0x8301, 0x8307, 0x8308, 
  0x830A, 0x830B, 0x8354, 0x831B, 0x831D, 0x831E, 0x831F, 0x8321, 
  0x8322, 0x832C, 0x832D, 0x832E, 0x8330, 0x8333, 0x8337, 0x833A, 
  0x833C, 0x833D, 0x8342, 0x8343, 0x8344, 0x8347, 0x834D, 0x834E, 
  0x8351, 0x8355, 0x8356, 0x8357, 0x8370, 0x8378
};
static const unicode_char jis2uni_tbl_58[] = {
  0x837D, 0x837F, 0x8380, 0x8382, 0x8384, 0x8386, 0x838D, 0x8392, 
  0x8394, 0x8395, 0x8398, 0x8399, 0x839B, 0x839C, 0x839D, 0x83A6, 
  0x83A7, 0x83A9, 0x83AC, 0x83BE, 0x83BF, 0x83C0, 0x83C7, 0x83C9, 
  0x83CF, 0x83D0, 0x83D1, 0x83D4, 0x83DD, 0x8353, 0x83E8, 0x83EA, 
  0x83F6, 0x83F8, 0x83F9, 0x83FC, 0x8401, 0x8406, 0x840A, 0x840F, 
  0x8411, 0x8415, 0x8419, 0x83AD, 0x842F, 0x8439, 0x8445, 0x8447, 
  0x8448, 0x844A, 0x844D, 0x844F, 0x8451, 0x8452, 0x8456, 0x8458, 
  0x8459, 0x845A, 0x845C, 0x8460, 0x8464, 0x8465, 0x8467, 0x846A, 
  0x8470, 0x8473, 0x8474, 0x8476, 0x8478, 0x847C, 0x847D, 0x8481, 
  0x8485, 0x8492, 0x8493, 0x8495, 0x849E, 0x84A6, 0x84A8, 0x84A9, 
  0x84AA, 0x84AF, 0x84B1, 0x84B4, 0x84BA, 0x84BD, 0x84BE, 0x84C0, 
  0x84C2, 0x84C7, 0x84C8, 0x84CC, 0x84CF, 0x84D3
};
static const unicode_char jis2uni_tbl_59[] = {
  0x84DC, 0x84E7, 0x84EA, 0x84EF, 0x84F0, 0x84F1, 0x84F2, 0x84F7, 
  0x8532, 0x84FA, 0x84FB, 0x84FD, 0x8502, 0x8503, 0x8507, 0x850C, 
  0x850E, 0x8510, 0x851C, 0x851E, 0x8522, 0x8523, 0x8524, 0x8525, 
  0x8527, 0x852A, 0x852B, 0x852F, 0x8533, 0x8534, 0x8536, 0x853F, 
  0x8546, 0x854F, 0x8550, 0x8551, 0x8552, 0x8553, 0x8556, 0x8559, 
  0x855C, 0x855D, 0x855E, 0x855F, 0x8560, 0x8561, 0x8562, 0x8564, 
  0x856B, 0x856F, 0x8579, 0x857A, 0x857B, 0x857D, 0x857F, 0x8581, 
  0x8585, 0x8586, 0x8589, 0x858B, 0x858C, 0x858F, 0x8593, 0x8598, 
  0x859D, 0x859F, 0x85A0, 0x85A2, 0x85A5, 0x85A7, 0x85B4, 0x85B6, 
  0x85B7, 0x85B8, 0x85BC, 0x85BD, 0x85BE, 0x85BF, 0x85C2, 0x85C7, 
  0x85CA, 0x85CB, 0x85CE, 0x85AD, 0x85D8, 0x85DA, 0x85DF, 0x85E0, 
  0x85E6, 0x85E8, 0x85ED, 0x85F3, 0x85F6, 0x85FC
};
static const unicode_char jis2uni_tbl_5a[] = {
  0x85FF, 0x8600, 0x8604, 0x8605, 0x860D, 0x860E, 0x8610, 0x8611, 
  0x8612, 0x8618, 0x8619, 0x861B, 0x861E, 0x8621, 0x8627, 0x8629, 
  0x8636, 0x8638, 0x863A, 0x863C, 0x863D, 0x8640, 0x8642, 0x8646, 
  0x8652, 0x8653, 0x8656, 0x8657, 0x8658, 0x8659, 0x865D, 0x8660, 
  0x8661, 0x8662, 0x8663, 0x8664, 0x8669, 0x866C, 0x866F, 0x8675, 
  0x8676, 0x8677, 0x867A, 0x868D, 0x8691, 0x8B8A, 0x8698, 0x869A, 
  0x869C, 0x86A1, 0x86A6, 0x86A7, 0x86A8, 0x86AD, 0x86B1, 0x86B3, 
  0x86B4, 0x86B5, 0x86B7, 0x86B8, 0x86B9, 0x86BF, 0x86C0, 0x86C1, 
  0x86C3, 0x86C5, 0x86D1, 0x86D2, 0x86D5, 0x86D7, 0x86DA, 0x86DC, 
  0x86E0, 0x86E3, 0x86E5, 0x86E7, 0x8688, 0x86FA, 0x86FC, 0x86FD, 
  0x8704, 0x8705, 0x8707, 0x870B, 0x870E, 0x870F, 0x8710, 0x8713, 
  0x8714, 0x8719, 0x871E, 0x871F, 0x8721, 0x8723
};
static const unicode_char jis2uni_tbl_5b[] = {
  0x8728, 0x872E, 0x872F, 0x8731, 0x8732, 0x8739, 0x873A, 0x873C, 
  0x873D, 0x873E, 0x8740, 0x8743, 0x8745, 0x874D, 0x8758, 0x875D, 
  0x9738, 0x8764, 0x8765, 0x876F, 0x8771, 0x8772, 0x877B, 0x8783, 
  0x8784, 0x8785, 0x8786, 0x8787, 0x8788, 0x8789, 0x878B, 0x878C, 
  0x8790, 0x8793, 0x8795, 0x8797, 0x8798, 0x8799, 0x879E, 0x87A0, 
  0x87A3, 0x87A7, 0x87AC, 0x87AD, 0x87AE, 0x87B1, 0x87B5, 0x87BE, 
  0x87BF, 0x87C1, 0x87C8, 0x87C9, 0x87CA, 0x87CE, 0x87D5, 0x87D6, 
  0x87D9, 0x87DA, 0x87DC, 0x87DF, 0x87E2, 0x87E3, 0x87E4, 0x87EA, 
  0x87EB, 0x87ED, 0x87F1, 0x87F3, 0x87F8, 0x87FA, 0x87FF, 0x8801, 
  0x8803, 0x8806, 0x8809, 0x880A, 0x880B, 0x8810, 0x8819, 0x8812, 
  0x8813, 0x8814, 0x8818, 0x881A, 0x881B, 0x881C, 0x881E, 0x881F, 
  0x8828, 0x882D, 0x882E, 0x8830, 0x8832, 0x8835
};
static const unicode_char jis2uni_tbl_5c[] = {
  0x883A, 0x883C, 0x8841, 0x8843, 0x8845, 0x8848, 0x8849, 0x884A, 
  0x884B, 0x884E, 0x8851, 0x8855, 0x8856, 0x8858, 0x885A, 0x885C, 
  0x885F, 0x8860, 0x8864, 0x8869, 0x8871, 0x8879, 0x887B, 0x8880, 
  0x8898, 0x889A, 0x889B, 0x889C, 0x889F, 0x88A0, 0x88A8, 0x88AA, 
  0x88BA, 0x88BD, 0x88BE, 0x88C0, 0x88CA, 0x88CB, 0x88CC, 0x88CD, 
  0x88CE, 0x88D1, 0x88D2, 0x88D3, 0x88DB, 0x88DE, 0x88E7, 0x88EF, 
  0x88F0, 0x88F1, 0x88F5, 0x88F7, 0x8901, 0x8906, 0x890D, 0x890E, 
  0x890F, 0x8915, 0x8916, 0x8918, 0x8919, 0x891A, 0x891C, 0x8920, 
  0x8926, 0x8927, 0x8928, 0x8930, 0x8931, 0x8932, 0x8935, 0x8939, 
  0x893A, 0x893E, 0x8940, 0x8942, 0x8945, 0x8946, 0x8949, 0x894F, 
  0x8952, 0x8957, 0x895A, 0x895B, 0x895C, 0x8961, 0x8962, 0x8963, 
  0x896B, 0x896E, 0x8970, 0x8973, 0x8975, 0x897A
};
static const unicode_char jis2uni_tbl_5d[] = {
  0x897B, 0x897C, 0x897D, 0x8989, 0x898D, 0x8990, 0x8994, 0x8995, 
  0x899B, 0x899C, 0x899F, 0x89A0, 0x89A5, 0x89B0, 0x89B4, 0x89B5, 
  0x89B6, 0x89B7, 0x89BC, 0x89D4, 0x9B31, 0x89D6, 0x89D7, 0x89D8, 
  0x89E5, 0x89E9, 0x98EE, 0x89ED, 0x89F1, 0x89F3, 0x89F6, 0x89F9, 
  0x89FD, 0x89FF, 0x8A04, 0x8A05, 0x8A07, 0x8A0F, 0x8A11, 0x8A12, 
  0x8A14, 0x8A15, 0x8A1E, 0x8A20, 0x8A22, 0x8A24, 0x8A26, 0x8A2B, 
  0x8A2C, 0x8A2F, 0x8A35, 0x8A37, 0x8A3D, 0x8A3E, 0x8A40, 0x8A43, 
  0x8A45, 0x8A47, 0x8A49, 0x8A4D, 0x8A4E, 0x8A53, 0x8A56, 0x9EBE, 
  0x8A58, 0x8A5C, 0x8A5D, 0x8A61, 0x8A65, 0x8A67, 0x8A75, 0x8A76, 
  0x8A77, 0x8A79, 0x8A7A, 0x8A7B, 0x8A7E, 0x8A7F, 0x8A80, 0x8A83, 
  0x8A86, 0x8A8B, 0x8A8F, 0x8A90, 0x8A92, 0x8A96, 0x8A97, 0x8A99, 
  0x8A9F, 0x8AA7, 0x8AA9, 0x8AAE, 0x8AAF, 0x8AB3
};
static const unicode_char jis2uni_tbl_5e[] = {
  0x8AB6, 0x8AB7, 0x8ABB, 0x8ABE, 0x8AC3, 0x8AC6, 0x8AC8, 0x8AC9, 
  0x8ACA, 0x8AD1, 0x8AD3, 0x8AD4, 0x8AD5, 0x8AD7, 0x8ADD, 0x8ADF, 
  0x8AEC, 0x8AF0, 0x8AF4, 0x8AF5, 0x8AF6, 0x8AFC, 0x8AFF, 0x8B05, 
  0x8B06, 0x8B0B, 0x8B11, 0x8B1C, 0x8B1E, 0x8B1F, 0x8B0A, 0x8B2D, 
  0x8B30, 0x8B37, 0x8B3C, 0x8B42, 0x8B43, 0x8B44, 0x8B45, 0x8B46, 
  0x8B48, 0x8B52, 0x8B53, 0x8B54, 0x8B59, 0x8B4D, 0x8B5E, 0x8B63, 
  0x8B6D, 0x8B76, 0x8B78, 0x8B79, 0x8B7C, 0x8B7E, 0x8B81, 0x8B84, 
  0x8B85, 0x8B8B, 0x8B8D, 0x8B8F, 0x8B94, 0x8B95, 0x8B9C, 0x8B9E, 
  0x8B9F, 0x8C38, 0x8C39, 0x8C3D, 0x8C3E, 0x8C45, 0x8C47, 0x8C49, 
  0x8C4B, 0x8C4F, 0x8C51, 0x8C53, 0x8C54, 0x8C57, 0x8C58, 0x8C5B, 
  0x8C5D, 0x8C59, 0x8C63, 0x8C64, 0x8C66, 0x8C68, 0x8C69, 0x8C6D, 
  0x8C73, 0x8C75, 0x8C76, 0x8C7B, 0x8C7E, 0x8C86
};
static const unicode_char jis2uni_tbl_5f[] = {
  0x8C87, 0x8C8B, 0x8C90, 0x8C92, 0x8C93, 0x8C99, 0x8C9B, 0x8C9C, 
  0x8CA4, 0x8CB9, 0x8CBA, 0x8CC5, 0x8CC6, 0x8CC9, 0x8CCB, 0x8CCF, 
  0x8CD6, 0x8CD5, 0x8CD9, 0x8CDD, 0x8CE1, 0x8CE8, 0x8CEC, 0x8CEF, 
  0x8CF0, 0x8CF2, 0x8CF5, 0x8CF7, 0x8CF8, 0x8CFE, 0x8CFF, 0x8D01, 
  0x8D03, 0x8D09, 0x8D12, 0x8D17, 0x8D1B, 0x8D65, 0x8D69, 0x8D6C, 
  0x8D6E, 0x8D7F, 0x8D82, 0x8D84, 0x8D88, 0x8D8D, 0x8D90, 0x8D91, 
  0x8D95, 0x8D9E, 0x8D9F, 0x8DA0, 0x8DA6, 0x8DAB, 0x8DAC, 0x8DAF, 
  0x8DB2, 0x8DB5, 0x8DB7, 0x8DB9, 0x8DBB, 0x8DC0, 0x8DC5, 0x8DC6, 
  0x8DC7, 0x8DC8, 0x8DCA, 0x8DCE, 0x8DD1, 0x8DD4, 0x8DD5, 0x8DD7, 
  0x8DD9, 0x8DE4, 0x8DE5, 0x8DE7, 0x8DEC, 0x8DF0, 0x8DBC, 0x8DF1, 
  0x8DF2, 0x8DF4, 0x8DFD, 0x8E01, 0x8E04, 0x8E05, 0x8E06, 0x8E0B, 
  0x8E11, 0x8E14, 0x8E16, 0x8E20, 0x8E21, 0x8E22
};
static const unicode_char jis2uni_tbl_60[] = {
  0x8E23, 0x8E26, 0x8E27, 0x8E31, 0x8E33, 0x8E36, 0x8E37, 0x8E38, 
  0x8E39, 0x8E3D, 0x8E40, 0x8E41, 0x8E4B, 0x8E4D, 0x8E4E, 0x8E4F, 
  0x8E54, 0x8E5B, 0x8E5C, 0x8E5D, 0x8E5E, 0x8E61, 0x8E62, 0x8E69, 
  0x8E6C, 0x8E6D, 0x8E6F, 0x8E70, 0x8E71, 0x8E79, 0x8E7A, 0x8E7B, 
  0x8E82, 0x8E83, 0x8E89, 0x8E90, 0x8E92, 0x8E95, 0x8E9A, 0x8E9B, 
  0x8E9D, 0x8E9E, 0x8EA2, 0x8EA7, 0x8EA9, 0x8EAD, 0x8EAE, 0x8EB3, 
  0x8EB5, 0x8EBA, 0x8EBB, 0x9ED8, 0x8EC1, 0x8EC3, 0x8EC4, 0x8EC7, 
  0x8ECF, 0x8ED1, 0x8ED4, 0x8EDC, 0x8EE8, 0x8EEE, 0x8EF0, 0x8EF1, 
  0x8EF7, 0x8EF9, 0x8EFA, 0x8EED, 0x8F00, 0x8F02, 0x8F07, 0x8F08, 
  0x8F0F, 0x8F10, 0x8F16, 0x8F17, 0x8F18, 0x8F1E, 0x8F20, 0x8F21, 
  0x8F23, 0x8F25, 0x8F27, 0x8F28, 0x8F2C, 0x8F2D, 0x8F2E, 0x8F34, 
  0x8F35, 0x8F36, 0x8F37, 0x8F3A, 0x8F40, 0x8F41
};
static const unicode_char jis2uni_tbl_61[] = {
  0x8F43, 0x8F47, 0x8F4F, 0x8F51, 0x8F52, 0x8F53, 0x8F54, 0x8F55, 
  0x8F58, 0x8F5D, 0x8F5E, 0x8F65, 0x8F9D, 0x8FA0, 0x8FA1, 0x8FA4, 
  0x8FA5, 0x8FA6, 0x8FB5, 0x8FB6, 0x8FB8, 0x8FBE, 0x8FC0, 0x8FC1, 
  0x8FC6, 0x8FCA, 0x8FCB, 0x8FCD, 0x8FD0, 0x8FD2, 0x8FD3, 0x8FD5, 
  0x8FE0, 0x8FE3, 0x8FE4, 0x8FE8, 0x8FEE, 0x8FF1, 0x8FF5, 0x8FF6, 
  0x8FFB, 0x8FFE, 0x9002, 0x9004, 0x9008, 0x900C, 0x9018, 0x901B, 
  0x9028, 0x9029, 0x902F, 0x902A, 0x902C, 0x902D, 0x9033, 0x9034, 
  0x9037, 0x903F, 0x9043, 0x9044, 0x904C, 0x905B, 0x905D, 0x9062, 
  0x9066, 0x9067, 0x906C, 0x9070, 0x9074, 0x9079, 0x9085, 0x9088, 
  0x908B, 0x908C, 0x908E, 0x9090, 0x9095, 0x9097, 0x9098, 0x9099, 
  0x909B, 0x90A0, 0x90A1, 0x90A2, 0x90A5, 0x90B0, 0x90B2, 0x90B3, 
  0x90B4, 0x90B6, 0x90BD, 0x90CC, 0x90BE, 0x90C3
};
static const unicode_char jis2uni_tbl_62[] = {
  0x90C4, 0x90C5, 0x90C7, 0x90C8, 0x90D5, 0x90D7, 0x90D8, 0x90D9, 
  0x90DC, 0x90DD, 0x90DF, 0x90E5, 0x90D2, 0x90F6, 0x90EB, 0x90EF, 
  0x90F0, 0x90F4, 0x90FE, 0x90FF, 0x9100, 0x9104, 0x9105, 0x9106, 
  0x9108, 0x910D, 0x9110, 0x9114, 0x9116, 0x9117, 0x9118, 0x911A, 
  0x911C, 0x911E, 0x9120, 0x9125, 0x9122, 0x9123, 0x9127, 0x9129, 
  0x912E, 0x912F, 0x9131, 0x9134, 0x9136, 0x9137, 0x9139, 0x913A, 
  0x913C, 0x913D, 0x9143, 0x9147, 0x9148, 0x914F, 0x9153, 0x9157, 
  0x9159, 0x915A, 0x915B, 0x9161, 0x9164, 0x9167, 0x916D, 0x9174, 
  0x9179, 0x917A, 0x917B, 0x9181, 0x9183, 0x9185, 0x9186, 0x918A, 
  0x918E, 0x9191, 0x9193, 0x9194, 0x9195, 0x9198, 0x919E, 0x91A1, 
  0x91A6, 0x91A8, 0x91AC, 0x91AD, 0x91AE, 0x91B0, 0x91B1, 0x91B2, 
  0x91B3, 0x91B6, 0x91BB, 0x91BC, 0x91BD, 0x91BF
};
static const unicode_char jis2uni_tbl_63[] = {
  0x91C2, 0x91C3, 0x91C5, 0x91D3, 0x91D4, 0x91D7, 0x91D9, 0x91DA, 
  0x91DE, 0x91E4, 0x91E5, 0x91E9, 0x91EA, 0x91EC, 0x91ED, 0x91EE, 
  0x91EF, 0x91F0, 0x91F1, 0x91F7, 0x91F9, 0x91FB, 0x9F4B, 0x9200, 
  0x9201, 0x9204, 0x9205, 0x9206, 0x9207, 0x9209, 0x920A, 0x920C, 
  0x9210, 0x9212, 0x9213, 0x9216, 0x9218, 0x921C, 0x921D, 0x9223, 
  0x9224, 0x9225, 0x9226, 0x9228, 0x922E, 0x922F, 0x9230, 0x9233, 
  0x9235, 0x9236, 0x9238, 0x9F9D, 0x923A, 0x923C, 0x923E, 0x9240, 
  0x9242, 0x9243, 0x9246, 0x9247, 0x924A, 0x924D, 0x924E, 0x924F, 
  0x9251, 0x9258, 0x9259, 0x925C, 0x925D, 0x9260, 0x9261, 0x9265, 
  0x9267, 0x9268, 0x9269, 0x926E, 0x926F, 0x9270, 0x9275, 0x9276, 
  0x9277, 0x9278, 0x9279, 0x927B, 0x927C, 0x927D, 0x927F, 0x9288, 
  0x9289, 0x928A, 0x928D, 0x928E, 0x9292, 0x9297
};
static const unicode_char jis2uni_tbl_64[] = {
  0x9299, 0x929F, 0x92A0, 0x92A4, 0x92A5, 0x92A7, 0x92A8, 0x92AB, 
  0x92AF, 0x92B2, 0x92B6, 0x92B8, 0x92BA, 0x92BB, 0x92BC, 0x92BD, 
  0x92BF, 0x92C0, 0x92C1, 0x92C2, 0x92C3, 0x92C5, 0x92C6, 0x92C7, 
  0x92C8, 0x92CB, 0x92CC, 0x92CD, 0x92CE, 0x92D0, 0x92D3, 0x92D5, 
  0x92D7, 0x92D8, 0x92D9, 0x92DC, 0x92DD, 0x92DF, 0x92E0, 0x92E1, 
  0x92E3, 0x92E5, 0x92E7, 0x92E8, 0x92EC, 0x92EE, 0x92F0, 0x92F9, 
  0x92FB, 0x92FF, 0x9300, 0x9302, 0x9308, 0x930D, 0x9311, 0x9314, 
  0x9315, 0x931C, 0x931D, 0x931E, 0x931F, 0x9321, 0x9324, 0x9325, 
  0x9327, 0x9329, 0x932A, 0x9333, 0x9334, 0x9336, 0x9337, 0x9347, 
  0x9348, 0x9349, 0x9350, 0x9351, 0x9352, 0x9355, 0x9357, 0x9358, 
  0x935A, 0x935E, 0x9364, 0x9365, 0x9367, 0x9369, 0x936A, 0x9B3B, 
  0x936F, 0x9370, 0x9371, 0x9373, 0x9374, 0x7D06
};
static const unicode_char jis2uni_tbl_65[] = {
  0x937A, 0x937D, 0x937F, 0x9380, 0x9381, 0x9382, 0x9388, 0x938A, 
  0x938B, 0x938D, 0x938F, 0x9392, 0x9395, 0x9398, 0x939B, 0x939E, 
  0x93A1, 0x93A3, 0x93A4, 0x93A6, 0x93A8, 0x93AB, 0x93B4, 0x93B5, 
  0x93B6, 0x93BA, 0x93A9, 0x93C1, 0x93C4, 0x93C5, 0x93C6, 0x93C7, 
  0x93C9, 0x93CA, 0x93CB, 0x93CC, 0x93CD, 0x93D3, 0x93D9, 0x93DC, 
  0x93DE, 0x93DF, 0x93E2, 0x93E6, 0x93E7, 0x93F9, 0x93F7, 0x93F8, 
  0x93FA, 0x93FB, 0x93FD, 0x9401, 0x9402, 0x9404, 0x9408, 0x9409, 
  0x940D, 0x940E, 0x940F, 0x9415, 0x9416, 0x9417, 0x941F, 0x942E, 
  0x942F, 0x9431, 0x9432, 0x9433, 0x9434, 0x943B, 0x943F, 0x943D, 
  0x9443, 0x9445, 0x9448, 0x944A, 0x944C, 0x9455, 0x9459, 0x945C, 
  0x945F, 0x9461, 0x9463, 0x9468, 0x946B, 0x946D, 0x946E, 0x946F, 
  0x9471, 0x9472, 0x9484, 0x9483, 0x9578, 0x9579
};
static const unicode_char jis2uni_tbl_66[] = {
  0x957E, 0x9584, 0x9588, 0x958C, 0x958D, 0x958E, 0x959D, 0x959E, 
  0x959F, 0x95A1, 0x95A6, 0x95A9, 0x95AB, 0x95AC, 0x95B4, 0x95B6, 
  0x95BA, 0x95BD, 0x95BF, 0x95C6, 0x95C8, 0x95C9, 0x95CB, 0x95D0, 
  0x95D1, 0x95D2, 0x95D3, 0x95D9, 0x95DA, 0x95DD, 0x95DE, 0x95DF, 
  0x95E0, 0x95E4, 0x95E6, 0x961D, 0x961E, 0x9622, 0x9624, 0x9625, 
  0x9626, 0x962C, 0x9631, 0x98DC, 0x9637, 0x9638, 0x9639, 0x963A, 
  0x963C, 0x963D, 0x9641, 0x9652, 0x9654, 0x9656, 0x9657, 0x9658, 
  0x9661, 0x966E, 0x9674, 0x967B, 0x967C, 0x967E, 0x967F, 0x9681, 
  0x9682, 0x9683, 0x9684, 0x9689, 0x9691, 0x9696, 0x969A, 0x969D, 
  0x969F, 0x96A4, 0x96A5, 0x96A6, 0x96A9, 0x96AE, 0x96AF, 0x96B3, 
  0x96BA, 0x96CA, 0x96D2, 0x80C4, 0x96D8, 0x96DA, 0x96DD, 0x96DE, 
  0x96DF, 0x96E9, 0x96EF, 0x96F1, 0x96FA, 0x9702
};
static const unicode_char jis2uni_tbl_67[] = {
  0x9703, 0x9705, 0x9709, 0x971A, 0x971B, 0x971D, 0x9721, 0x9722, 
  0x9723, 0x9728, 0x9731, 0x9733, 0x9741, 0x9743, 0x974A, 0x974E, 
  0x974F, 0x9755, 0x9757, 0x9758, 0x975A, 0x975B, 0x9763, 0x9767, 
  0x976A, 0x976E, 0x9773, 0x9776, 0x9777, 0x9778, 0x977B, 0x977D, 
  0x977F, 0x9780, 0x9789, 0x9795, 0x9796, 0x9797, 0x9799, 0x979A, 
  0x979E, 0x979F, 0x97A2, 0x97AC, 0x97AE, 0x97B1, 0x97B2, 0x97B5, 
  0x97B6, 0x97B8, 0x97B9, 0x97BA, 0x97BC, 0x97BE, 0x97BF, 0x97C1, 
  0x97C4, 0x97C5, 0x97C7, 0x97C9, 0x97CA, 0x97CC, 0x97CD, 0x97CE, 
  0x97D0, 0x97D1, 0x97D4, 0x97D7, 0x97D8, 0x97D9, 0x97DD, 0x97DE, 
  0x97E0, 0x97DB, 0x97E1, 0x97E4, 0x97EF, 0x97F1, 0x97F4, 0x97F7, 
  0x97F8, 0x97FA, 0x9807, 0x980A, 0x9819, 0x980D, 0x980E, 0x9814, 
  0x9816, 0x981C, 0x981E, 0x9820, 0x9823, 0x9826
};
static const unicode_char jis2uni_tbl_68[] = {
  0x982B, 0x982E, 0x982F, 0x9830, 0x9832, 0x9833, 0x9835, 0x9825, 
  0x983E, 0x9844, 0x9847, 0x984A, 0x9851, 0x9852, 0x9853, 0x9856, 
  0x9857, 0x9859, 0x985A, 0x9862, 0x9863, 0x9865, 0x9866, 0x986A, 
  0x986C, 0x98AB, 0x98AD, 0x98AE, 0x98B0, 0x98B4, 0x98B7, 0x98B8, 
  0x98BA, 0x98BB, 0x98BF, 0x98C2, 0x98C5, 0x98C8, 0x98CC, 0x98E1, 
  0x98E3, 0x98E5, 0x98E6, 0x98E7, 0x98EA, 0x98F3, 0x98F6, 0x9902, 
  0x9907, 0x9908, 0x9911, 0x9915, 0x9916, 0x9917, 0x991A, 0x991B, 
  0x991C, 0x991F, 0x9922, 0x9926, 0x9927, 0x992B, 0x9931, 0x9932, 
  0x9933, 0x9934, 0x9935, 0x9939, 0x993A, 0x993B, 0x993C, 0x9940, 
  0x9941, 0x9946, 0x9947, 0x9948, 0x994D, 0x994E, 0x9954, 0x9958, 
  0x9959, 0x995B, 0x995C, 0x995E, 0x995F, 0x9960, 0x999B, 0x999D, 
  0x999F, 0x99A6, 0x99B0, 0x99B1, 0x99B2, 0x99B5
};
static const unicode_char jis2uni_tbl_69[] = {
  0x99B9, 0x99BA, 0x99BD, 0x99BF, 0x99C3, 0x99C9, 0x99D3, 0x99D4, 
  0x99D9, 0x99DA, 0x99DC, 0x99DE, 0x99E7, 0x99EA, 0x99EB, 0x99EC, 
  0x99F0, 0x99F4, 0x99F5, 0x99F9, 0x99FD, 0x99FE, 0x9A02, 0x9A03, 
  0x9A04, 0x9A0B, 0x9A0C, 0x9A10, 0x9A11, 0x9A16, 0x9A1E, 0x9A20, 
  0x9A22, 0x9A23, 0x9A24, 0x9A27, 0x9A2D, 0x9A2E, 0x9A33, 0x9A35, 
  0x9A36, 0x9A38, 0x9A47, 0x9A41, 0x9A44, 0x9A4A, 0x9A4B, 0x9A4C, 
  0x9A4E, 0x9A51, 0x9A54, 0x9A56, 0x9A5D, 0x9AAA, 0x9AAC, 0x9AAE, 
  0x9AAF, 0x9AB2, 0x9AB4, 0x9AB5, 0x9AB6, 0x9AB9, 0x9ABB, 0x9ABE, 
  0x9ABF, 0x9AC1, 0x9AC3, 0x9AC6, 0x9AC8, 0x9ACE, 0x9AD0, 0x9AD2, 
  0x9AD5, 0x9AD6, 0x9AD7, 0x9ADB, 0x9ADC, 0x9AE0, 0x9AE4, 0x9AE5, 
  0x9AE7, 0x9AE9, 0x9AEC, 0x9AF2, 0x9AF3, 0x9AF5, 0x9AF9, 0x9AFA, 
  0x9AFD, 0x9AFF, 0x9B00, 0x9B01, 0x9B02, 0x9B03
};
static const unicode_char jis2uni_tbl_6a[] = {
  0x9B04, 0x9B05, 0x9B08, 0x9B09, 0x9B0B, 0x9B0C, 0x9B0D, 0x9B0E, 
  0x9B10, 0x9B12, 0x9B16, 0x9B19, 0x9B1B, 0x9B1C, 0x9B20, 0x9B26, 
  0x9B2B, 0x9B2D, 0x9B33, 0x9B34, 0x9B35, 0x9B37, 0x9B39, 0x9B3A, 
  0x9B3D, 0x9B48, 0x9B4B, 0x9B4C, 0x9B55, 0x9B56, 0x9B57, 0x9B5B, 
  0x9B5E, 0x9B61, 0x9B63, 0x9B65, 0x9B66, 0x9B68, 0x9B6A, 0x9B6B, 
  0x9B6C, 0x9B6D, 0x9B6E, 0x9B73, 0x9B75, 0x9B77, 0x9B78, 0x9B79, 
  0x9B7F, 0x9B80, 0x9B84, 0x9B85, 0x9B86, 0x9B87, 0x9B89, 0x9B8A, 
  0x9B8B, 0x9B8D, 0x9B8F, 0x9B90, 0x9B94, 0x9B9A, 0x9B9D, 0x9B9E, 
  0x9BA6, 0x9BA7, 0x9BA9, 0x9BAC, 0x9BB0, 0x9BB1, 0x9BB2, 0x9BB7, 
  0x9BB8, 0x9BBB, 0x9BBC, 0x9BBE, 0x9BBF, 0x9BC1, 0x9BC7, 0x9BC8, 
  0x9BCE, 0x9BD0, 0x9BD7, 0x9BD8, 0x9BDD, 0x9BDF, 0x9BE5, 0x9BE7, 
  0x9BEA, 0x9BEB, 0x9BEF, 0x9BF3, 0x9BF7, 0x9BF8
};
static const unicode_char jis2uni_tbl_6b[] = {
  0x9BF9, 0x9BFA, 0x9BFD, 0x9BFF, 0x9C00, 0x9C02, 0x9C0B, 0x9C0F, 
  0x9C11, 0x9C16, 0x9C18, 0x9C19, 0x9C1A, 0x9C1C, 0x9C1E, 0x9C22, 
  0x9C23, 0x9C26, 0x9C27, 0x9C28, 0x9C29, 0x9C2A, 0x9C31, 0x9C35, 
  0x9C36, 0x9C37, 0x9C3D, 0x9C41, 0x9C43, 0x9C44, 0x9C45, 0x9C49, 
  0x9C4A, 0x9C4E, 0x9C4F, 0x9C50, 0x9C53, 0x9C54, 0x9C56, 0x9C58, 
  0x9C5B, 0x9C5D, 0x9C5E, 0x9C5F, 0x9C63, 0x9C69, 0x9C6A, 0x9C5C, 
  0x9C6B, 0x9C68, 0x9C6E, 0x9C70, 0x9C72, 0x9C75, 0x9C77, 0x9C7B, 
  0x9CE6, 0x9CF2, 0x9CF7, 0x9CF9, 0x9D0B, 0x9D02, 0x9D11, 0x9D17, 
  0x9D18, 0x9D1C, 0x9D1D, 0x9D1E, 0x9D2F, 0x9D30, 0x9D32, 0x9D33, 
  0x9D34, 0x9D3A, 0x9D3C, 0x9D45, 0x9D3D, 0x9D42, 0x9D43, 0x9D47, 
  0x9D4A, 0x9D53, 0x9D54, 0x9D5F, 0x9D63, 0x9D62, 0x9D65, 0x9D69, 
  0x9D6A, 0x9D6B, 0x9D70, 0x9D76, 0x9D77, 0x9D7B
};
static const unicode_char jis2uni_tbl_6c[] = {
  0x9D7C, 0x9D7E, 0x9D83, 0x9D84, 0x9D86, 0x9D8A, 0x9D8D, 0x9D8E, 
  0x9D92, 0x9D93, 0x9D95, 0x9D96, 0x9D97, 0x9D98, 0x9DA1, 0x9DAA, 
  0x9DAC, 0x9DAE, 0x9DB1, 0x9DB5, 0x9DB9, 0x9DBC, 0x9DBF, 0x9DC3, 
  0x9DC7, 0x9DC9, 0x9DCA, 0x9DD4, 0x9DD5, 0x9DD6, 0x9DD7, 0x9DDA, 
  0x9DDE, 0x9DDF, 0x9DE0, 0x9DE5, 0x9DE7, 0x9DE9, 0x9DEB, 0x9DEE, 
  0x9DF0, 0x9DF3, 0x9DF4, 0x9DFE, 0x9E0A, 0x9E02, 0x9E07, 0x9E0E, 
  0x9E10, 0x9E11, 0x9E12, 0x9E15, 0x9E16, 0x9E19, 0x9E1C, 0x9E1D, 
  0x9E7A, 0x9F4E, 0x9E7C, 0x9E80, 0x9E82, 0x9E83, 0x9E84, 0x9E85, 
  0x9E87, 0x9E8E, 0x9E8F, 0x9E96, 0x9E98, 0x9E9B, 0x9E9E, 0x9EA4, 
  0x9EA8, 0x9EAC, 0x9EAE, 0x9EAF, 0x9EB0, 0x9EB3, 0x9EB4, 0x9EB5, 
  0x9EC6, 0x9EC8, 0x9ECB, 0x9ED5, 0x9EDF, 0x9EE4, 0x9EE7, 0x9EEC, 
  0x9EED, 0x9EEE, 0x9EF0, 0x9EF1, 0x9EF2, 0x9EF5
};
static const unicode_char jis2uni_tbl_6d[] = {
  0x9EF8, 0x9EFF, 0x9F02, 0x9F03, 0x9F09, 0x9F0F, 0x9F10, 0x9F11, 
  0x9F12, 0x9F14, 0x9F16, 0x9F17, 0x9F19, 0x9F1A, 0x9F1B, 0x9F1F, 
  0x9F22, 0x9F26, 0x9F2A, 0x9F2B, 0x9F2F, 0x9F31, 0x9F32, 0x9F34, 
  0x9F37, 0x9F39, 0x9F3A, 0x9F3C, 0x9F3D, 0x9F3F, 0x9F41, 0x9F43, 
  0x9F44, 0x9F45, 0x9F46, 0x9F47, 0x9F53, 0x9F55, 0x9F56, 0x9F57, 
  0x9F58, 0x9F5A, 0x9F5D, 0x9F5E, 0x9F68, 0x9F69, 0x9F6D, 0x9F6E, 
  0x9F6F, 0x9F70, 0x9F71, 0x9F73, 0x9F75, 0x9F7A, 0x9F7D, 0x9F8F, 
  0x9F90, 0x9F91, 0x9F92, 0x9F94, 0x9F96, 0x9F97, 0x9F9E, 0x9FA1, 
  0x9FA2, 0x9FA3, 0x9FA5, 0x8F9F, 0x8FA3, 0x8FAD, 0x8FAF, 0x8FB7, 
  0x8FDA, 0x8FE5, 0x8FE2, 0x8FEA, 0x8FEF, 0x9087, 0x8FF4, 0x9005, 
  0x8FF9, 0x8FFA, 0x9011, 0x9015, 0x9021, 0x900D, 0x901E, 0x9016, 
  0x900B, 0x9027, 0x9036, 0x9035, 0x9039, 0x8FF8
};
static const unicode_char jis2uni_tbl_6e[] = {
  0x904F, 0x9050, 0x9051, 0x9052, 0x900E, 0x9049, 0x903E, 0x9056, 
  0x9058, 0x905E, 0x9068, 0x906F, 0x9076, 0x96A8, 0x9072, 0x9082, 
  0x907D, 0x9081, 0x9080, 0x908A, 0x9089, 0x908F, 0x90A8, 0x90AF, 
  0x90B1, 0x90B5, 0x90E2, 0x90E4, 0x6248, 0x90DB, 0x9102, 0x9112, 
  0x9119, 0x9132, 0x9130, 0x914A, 0x9156, 0x9158, 0x9163, 0x9165, 
  0x9169, 0x9173, 0x9172, 0x918B, 0x9189, 0x9182, 0x91A2, 0x91AB, 
  0x91AF, 0x91AA, 0x91B5, 0x91B4, 0x91BA, 0x91C0, 0x91C1, 0x91C9, 
  0x91CB, 0x91D0, 0x91D6, 0x91DF, 0x91E1, 0x91DB, 0x91FC, 0x91F5, 
  0x91F6, 0x921E, 0x91FF, 0x9214, 0x922C, 0x9215, 0x9211, 0x925E, 
  0x9257, 0x9245, 0x9249, 0x9264, 0x9248, 0x9295, 0x923F, 0x924B, 
  0x9250, 0x929C, 0x9296, 0x9293, 0x929B, 0x925A, 0x92CF, 0x92B9, 
  0x92B7, 0x92E9, 0x930F, 0x92FA, 0x9344, 0x932E
};
static const unicode_char jis2uni_tbl_6f[] = {
  0x9319, 0x9322, 0x931A, 0x9323, 0x933A, 0x9335, 0x933B, 0x935C, 
  0x9360, 0x937C, 0x936E, 0x9356, 0x93B0, 0x93AC, 0x93AD, 0x9394, 
  0x93B9, 0x93D6, 0x93D7, 0x93E8, 0x93E5, 0x93D8, 0x93C3, 0x93DD, 
  0x93D0, 0x93C8, 0x93E4, 0x941A, 0x9414, 0x9413, 0x9403, 0x9407, 
  0x9410, 0x9436, 0x942B, 0x9435, 0x9421, 0x943A, 0x9441, 0x9452, 
  0x9444, 0x945B, 0x9460, 0x9462, 0x945E, 0x946A, 0x9229, 0x9470, 
  0x9475, 0x9477, 0x947D, 0x945A, 0x947C, 0x947E, 0x9481, 0x947F, 
  0x9582, 0x9587, 0x958A, 0x9594, 0x9596, 0x9598, 0x9599, 0x95A0, 
  0x95A8, 0x95A7, 0x95AD, 0x95BC, 0x95BB, 0x95B9, 0x95BE, 0x95CA, 
  0x6FF6, 0x95C3, 0x95CD, 0x95CC, 0x95D5, 0x95D4, 0x95D6, 0x95DC, 
  0x95E1, 0x95E5, 0x95E2, 0x9621, 0x9628, 0x962E, 0x962F, 0x9642, 
  0x964C, 0x964F, 0x964B, 0x9677, 0x965C, 0x965E
};
static const unicode_char jis2uni_tbl_70[] = {
  0x965D, 0x965F, 0x9666, 0x9672, 0x966C, 0x968D, 0x9698, 0x9695, 
  0x9697, 0x96AA, 0x96A7, 0x96B1, 0x96B2, 0x96B0, 0x96B4, 0x96B6, 
  0x96B8, 0x96B9, 0x96CE, 0x96CB, 0x96C9, 0x96CD, 0x894D, 0x96DC, 
  0x970D, 0x96D5, 0x96F9, 0x9704, 0x9706, 0x9708, 0x9713, 0x970E, 
  0x9711, 0x970F, 0x9716, 0x9719, 0x9724, 0x972A, 0x9730, 0x9739, 
  0x973D, 0x973E, 0x9744, 0x9746, 0x9748, 0x9742, 0x9749, 0x975C, 
  0x9760, 0x9764, 0x9766, 0x9768, 0x52D2, 0x976B, 0x9771, 0x9779, 
  0x9785, 0x977C, 0x9781, 0x977A, 0x9786, 0x978B, 0x978F, 0x9790, 
  0x979C, 0x97A8, 0x97A6, 0x97A3, 0x97B3, 0x97B4, 0x97C3, 0x97C6, 
  0x97C8, 0x97CB, 0x97DC, 0x97ED, 0x9F4F, 0x97F2, 0x7ADF, 0x97F6, 
  0x97F5, 0x980F, 0x980C, 0x9838, 0x9824, 0x9821, 0x9837, 0x983D, 
  0x9846, 0x984F, 0x984B, 0x986B, 0x986F, 0x9870
};
static const unicode_char jis2uni_tbl_71[] = {
  0x9871, 0x9874, 0x9873, 0x98AA, 0x98AF, 0x98B1, 0x98B6, 0x98C4, 
  0x98C3, 0x98C6, 0x98E9, 0x98EB, 0x9903, 0x9909, 0x9912, 0x9914, 
  0x9918, 0x9921, 0x991D, 0x991E, 0x9924, 0x9920, 0x992C, 0x992E, 
  0x993D, 0x993E, 0x9942, 0x9949, 0x9945, 0x9950, 0x994B, 0x9951, 
  0x9952, 0x994C, 0x9955, 0x9997, 0x9998, 0x99A5, 0x99AD, 0x99AE, 
  0x99BC, 0x99DF, 0x99DB, 0x99DD, 0x99D8, 0x99D1, 0x99ED, 0x99EE, 
  0x99F1, 0x99F2, 0x99FB, 0x99F8, 0x9A01, 0x9A0F, 0x9A05, 0x99E2, 
  0x9A19, 0x9A2B, 0x9A37, 0x9A45, 0x9A42, 0x9A40, 0x9A43, 0x9A3E, 
  0x9A55, 0x9A4D, 0x9A5B, 0x9A57, 0x9A5F, 0x9A62, 0x9A65, 0x9A64, 
  0x9A69, 0x9A6B, 0x9A6A, 0x9AAD, 0x9AB0, 0x9ABC, 0x9AC0, 0x9ACF, 
  0x9AD1, 0x9AD3, 0x9AD4, 0x9ADE, 0x9ADF, 0x9AE2, 0x9AE3, 0x9AE6, 
  0x9AEF, 0x9AEB, 0x9AEE, 0x9AF4, 0x9AF1, 0x9AF7
};
static const unicode_char jis2uni_tbl_72[] = {
  0x9AFB, 0x9B06, 0x9B18, 0x9B1A, 0x9B1F, 0x9B22, 0x9B23, 0x9B25, 
  0x9B27, 0x9B28, 0x9B29, 0x9B2A, 0x9B2E, 0x9B2F, 0x9B32, 0x9B44, 
  0x9B43, 0x9B4F, 0x9B4D, 0x9B4E, 0x9B51, 0x9B58, 0x9B74, 0x9B93, 
  0x9B83, 0x9B91, 0x9B96, 0x9B97, 0x9B9F, 0x9BA0, 0x9BA8, 0x9BB4, 
  0x9BC0, 0x9BCA, 0x9BB9, 0x9BC6, 0x9BCF, 0x9BD1, 0x9BD2, 0x9BE3, 
  0x9BE2, 0x9BE4, 0x9BD4, 0x9BE1, 0x9C3A, 0x9BF2, 0x9BF1, 0x9BF0, 
  0x9C15, 0x9C14, 0x9C09, 0x9C13, 0x9C0C, 0x9C06, 0x9C08, 0x9C12, 
  0x9C0A, 0x9C04, 0x9C2E, 0x9C1B, 0x9C25, 0x9C24, 0x9C21, 0x9C30, 
  0x9C47, 0x9C32, 0x9C46, 0x9C3E, 0x9C5A, 0x9C60, 0x9C67, 0x9C76, 
  0x9C78, 0x9CE7, 0x9CEC, 0x9CF0, 0x9D09, 0x9D08, 0x9CEB, 0x9D03, 
  0x9D06, 0x9D2A, 0x9D26, 0x9DAF, 0x9D23, 0x9D1F, 0x9D44, 0x9D15, 
  0x9D12, 0x9D41, 0x9D3F, 0x9D3E, 0x9D46, 0x9D48
};
static const unicode_char jis2uni_tbl_73[] = {
  0x9D5D, 0x9D5E, 0x9D64, 0x9D51, 0x9D50, 0x9D59, 0x9D72, 0x9D89, 
  0x9D87, 0x9DAB, 0x9D6F, 0x9D7A, 0x9D9A, 0x9DA4, 0x9DA9, 0x9DB2, 
  0x9DC4, 0x9DC1, 0x9DBB, 0x9DB8, 0x9DBA, 0x9DC6, 0x9DCF, 0x9DC2, 
  0x9DD9, 0x9DD3, 0x9DF8, 0x9DE6, 0x9DED, 0x9DEF, 0x9DFD, 0x9E1A, 
  0x9E1B, 0x9E1E, 0x9E75, 0x9E79, 0x9E7D, 0x9E81, 0x9E88, 0x9E8B, 
  0x9E8C, 0x9E92, 0x9E95, 0x9E91, 0x9E9D, 0x9EA5, 0x9EA9, 0x9EB8, 
  0x9EAA, 0x9EAD, 0x9761, 0x9ECC, 0x9ECE, 0x9ECF, 0x9ED0, 0x9ED4, 
  0x9EDC, 0x9EDE, 0x9EDD, 0x9EE0, 0x9EE5, 0x9EE8, 0x9EEF, 0x9EF4, 
  0x9EF6, 0x9EF7, 0x9EF9, 0x9EFB, 0x9EFC, 0x9EFD, 0x9F07, 0x9F08, 
  0x76B7, 0x9F15, 0x9F21, 0x9F2C, 0x9F3E, 0x9F4A, 0x9F52, 0x9F54, 
  0x9F63, 0x9F5F, 0x9F60, 0x9F61, 0x9F66, 0x9F67, 0x9F6C, 0x9F6A, 
  0x9F77, 0x9F72, 0x9F76, 0x9F95, 0x9F9C, 0x9FA0
};
static const unicode_char jis2uni_tbl_74[] = {
  0x582F, 0x69C7, 0x9059, 0x7464, 0x51DC, 0x7199, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
const unicode_char * jis2uni_tbls[] = {
  jis2uni_tbl_21,
  jis2uni_tbl_22,
  jis2uni_tbl_23,
  jis2uni_tbl_24,
  jis2uni_tbl_25,
  jis2uni_tbl_26,
  jis2uni_tbl_27,
  jis2uni_tbl_28,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  jis2uni_tbl_30,
  jis2uni_tbl_31,
  jis2uni_tbl_32,
  jis2uni_tbl_33,
  jis2uni_tbl_34,
  jis2uni_tbl_35,
  jis2uni_tbl_36,
  jis2uni_tbl_37,
  jis2uni_tbl_38,
  jis2uni_tbl_39,
  jis2uni_tbl_3a,
  jis2uni_tbl_3b,
  jis2uni_tbl_3c,
  jis2uni_tbl_3d,
  jis2uni_tbl_3e,
  jis2uni_tbl_3f,
  jis2uni_tbl_40,
  jis2uni_tbl_41,
  jis2uni_tbl_42,
  jis2uni_tbl_43,
  jis2uni_tbl_44,
  jis2uni_tbl_45,
  jis2uni_tbl_46,
  jis2uni_tbl_47,
  jis2uni_tbl_48,
  jis2uni_tbl_49,
  jis2uni_tbl_4a,
  jis2uni_tbl_4b,
  jis2uni_tbl_4c,
  jis2uni_tbl_4d,
  jis2uni_tbl_4e,
  jis2uni_tbl_4f,
  jis2uni_tbl_50,
  jis2uni_tbl_51,
  jis2uni_tbl_52,
  jis2uni_tbl_53,
  jis2uni_tbl_54,
  jis2uni_tbl_55,
  jis2uni_tbl_56,
  jis2uni_tbl_57,
  jis2uni_tbl_58,
  jis2uni_tbl_59,
  jis2uni_tbl_5a,
  jis2uni_tbl_5b,
  jis2uni_tbl_5c,
  jis2uni_tbl_5d,
  jis2uni_tbl_5e,
  jis2uni_tbl_5f,
  jis2uni_tbl_60,
  jis2uni_tbl_61,
  jis2uni_tbl_62,
  jis2uni_tbl_63,
  jis2uni_tbl_64,
  jis2uni_tbl_65,
  jis2uni_tbl_66,
  jis2uni_tbl_67,
  jis2uni_tbl_68,
  jis2uni_tbl_69,
  jis2uni_tbl_6a,
  jis2uni_tbl_6b,
  jis2uni_tbl_6c,
  jis2uni_tbl_6d,
  jis2uni_tbl_6e,
  jis2uni_tbl_6f,
  jis2uni_tbl_70,
  jis2uni_tbl_71,
  jis2uni_tbl_72,
  jis2uni_tbl_73,
  jis2uni_tbl_74,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL
};


/* map : Unicode to iso-2022-jp */
static const unsigned uni2jis_tbl_00[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x2140, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x2171, 0x2172, 0x003F, 0x003F, 0x003F, 0x2178, 
  0x212F, 0x003F, 0x003F, 0x003F, 0x224C, 0x003F, 0x003F, 0x003F, 
  0x216B, 0x215E, 0x003F, 0x003F, 0x212D, 0x003F, 0x2279, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x215F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x2160, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_03[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x2621, 0x2622, 0x2623, 0x2624, 0x2625, 0x2626, 0x2627, 
  0x2628, 0x2629, 0x262A, 0x262B, 0x262C, 0x262D, 0x262E, 0x262F, 
  0x2630, 0x2631, 0x003F, 0x2632, 0x2633, 0x2634, 0x2635, 0x2636, 
  0x2637, 0x2638, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x2641, 0x2642, 0x2643, 0x2644, 0x2645, 0x2646, 0x2647, 
  0x2648, 0x2649, 0x264A, 0x264B, 0x264C, 0x264D, 0x264E, 0x264F, 
  0x2650, 0x2651, 0x003F, 0x2652, 0x2653, 0x2654, 0x2655, 0x2656, 
  0x2657, 0x2658, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_04[] = {
  0x003F, 0x2727, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x2721, 0x2722, 0x2723, 0x2724, 0x2725, 0x2726, 0x2728, 0x2729, 
  0x272A, 0x272B, 0x272C, 0x272D, 0x272E, 0x272F, 0x2730, 0x2731, 
  0x2732, 0x2733, 0x2734, 0x2735, 0x2736, 0x2737, 0x2738, 0x2739, 
  0x273A, 0x273B, 0x273C, 0x273D, 0x273E, 0x273F, 0x2740, 0x2741, 
  0x2751, 0x2752, 0x2753, 0x2754, 0x2755, 0x2756, 0x2758, 0x2759, 
  0x275A, 0x275B, 0x275C, 0x275D, 0x275E, 0x275F, 0x2760, 0x2761, 
  0x2762, 0x2763, 0x2764, 0x2765, 0x2766, 0x2767, 0x2768, 0x2769, 
  0x276A, 0x276B, 0x276C, 0x276D, 0x276E, 0x276F, 0x2770, 0x2771, 
  0x003F, 0x2757, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_20[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x213E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x2142, 0x003F, 
  0x2146, 0x2147, 0x003F, 0x003F, 0x2148, 0x2149, 0x003F, 0x003F, 
  0x2277, 0x2278, 0x003F, 0x003F, 0x003F, 0x2145, 0x2144, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x2273, 0x003F, 0x216C, 0x216D, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x2228, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_21[] = {
  0x003F, 0x003F, 0x003F, 0x216E, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x2272, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x222B, 0x222C, 0x222A, 0x222D, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x224D, 0x003F, 0x224E, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_22[] = {
  0x224F, 0x003F, 0x225F, 0x2250, 0x003F, 0x003F, 0x003F, 0x2260, 
  0x223A, 0x003F, 0x003F, 0x223B, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x215D, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x2265, 0x003F, 0x003F, 0x2267, 0x2167, 0x003F, 
  0x225C, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x224A, 
  0x224B, 0x2241, 0x2240, 0x2269, 0x226A, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x2168, 0x2268, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x2266, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x2262, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x2162, 0x2261, 0x003F, 0x003F, 0x003F, 0x003F, 0x2165, 0x2166, 
  0x003F, 0x003F, 0x2263, 0x2264, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x223E, 0x223F, 0x003F, 0x003F, 0x223C, 0x223D, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x225D, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_23[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x225E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_25[] = {
  0x2821, 0x282C, 0x2822, 0x282D, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x2823, 0x003F, 0x003F, 0x282E, 
  0x2824, 0x003F, 0x003F, 0x282F, 0x2826, 0x003F, 0x003F, 0x2831, 
  0x2825, 0x003F, 0x003F, 0x2830, 0x2827, 0x283C, 0x003F, 0x003F, 
  0x2837, 0x003F, 0x003F, 0x2832, 0x2829, 0x283E, 0x003F, 0x003F, 
  0x2839, 0x003F, 0x003F, 0x2834, 0x2828, 0x003F, 0x003F, 0x2838, 
  0x283D, 0x003F, 0x003F, 0x2833, 0x282A, 0x003F, 0x003F, 0x283A, 
  0x283F, 0x003F, 0x003F, 0x2835, 0x282B, 0x003F, 0x003F, 0x283B, 
  0x003F, 0x003F, 0x2840, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x2836, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x2223, 0x2222, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x2225, 0x2224, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x2227, 0x2226, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x2221, 0x217E, 
  0x003F, 0x003F, 0x003F, 0x217B, 0x003F, 0x003F, 0x217D, 0x217C, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x227E, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_26[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x217A, 0x2179, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x216A, 0x003F, 0x2169, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x2276, 0x003F, 0x003F, 0x2275, 0x003F, 0x2274, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_30[] = {
  0x2121, 0x2122, 0x2123, 0x2137, 0x003F, 0x2139, 0x213A, 0x213B, 
  0x2152, 0x2153, 0x2154, 0x2155, 0x2156, 0x2157, 0x2158, 0x2159, 
  0x215A, 0x215B, 0x2229, 0x222E, 0x214C, 0x214D, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x2141, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x2421, 0x2422, 0x2423, 0x2424, 0x2425, 0x2426, 0x2427, 
  0x2428, 0x2429, 0x242A, 0x242B, 0x242C, 0x242D, 0x242E, 0x242F, 
  0x2430, 0x2431, 0x2432, 0x2433, 0x2434, 0x2435, 0x2436, 0x2437, 
  0x2438, 0x2439, 0x243A, 0x243B, 0x243C, 0x243D, 0x243E, 0x243F, 
  0x2440, 0x2441, 0x2442, 0x2443, 0x2444, 0x2445, 0x2446, 0x2447, 
  0x2448, 0x2449, 0x244A, 0x244B, 0x244C, 0x244D, 0x244E, 0x244F, 
  0x2450, 0x2451, 0x2452, 0x2453, 0x2454, 0x2455, 0x2456, 0x2457, 
  0x2458, 0x2459, 0x245A, 0x245B, 0x245C, 0x245D, 0x245E, 0x245F, 
  0x2460, 0x2461, 0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 0x2467, 
  0x2468, 0x2469, 0x246A, 0x246B, 0x246C, 0x246D, 0x246E, 0x246F, 
  0x2470, 0x2471, 0x2472, 0x2473, 0x2474, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x212B, 0x212C, 0x2135, 0x2136, 0x003F, 
  0x003F, 0x2521, 0x2522, 0x2523, 0x2524, 0x2525, 0x2526, 0x2527, 
  0x2528, 0x2529, 0x252A, 0x252B, 0x252C, 0x252D, 0x252E, 0x252F, 
  0x2530, 0x2531, 0x2532, 0x2533, 0x2534, 0x2535, 0x2536, 0x2537, 
  0x2538, 0x2539, 0x253A, 0x253B, 0x253C, 0x253D, 0x253E, 0x253F, 
  0x2540, 0x2541, 0x2542, 0x2543, 0x2544, 0x2545, 0x2546, 0x2547, 
  0x2548, 0x2549, 0x254A, 0x254B, 0x254C, 0x254D, 0x254E, 0x254F, 
  0x2550, 0x2551, 0x2552, 0x2553, 0x2554, 0x2555, 0x2556, 0x2557, 
  0x2558, 0x2559, 0x255A, 0x255B, 0x255C, 0x255D, 0x255E, 0x255F, 
  0x2560, 0x2561, 0x2562, 0x2563, 0x2564, 0x2565, 0x2566, 0x2567, 
  0x2568, 0x2569, 0x256A, 0x256B, 0x256C, 0x256D, 0x256E, 0x256F, 
  0x2570, 0x2571, 0x2572, 0x2573, 0x2574, 0x2575, 0x2576, 0x2577, 
  0x003F, 0x003F, 0x003F, 0x2126, 0x213C, 0x2133, 0x2134, 0x003F
};
static const unsigned uni2jis_tbl_4e[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3021, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x2138, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x304A, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_4f[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x304B, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3066, 0x003F, 0x3067, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x304C, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x306C, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x304D, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x312F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x313E, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_50[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x304E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3235, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3236, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x323C, 0x003F, 0x003F, 0x323E, 
  0x003F, 0x003F, 0x323F, 0x003F, 0x3240, 0x003F, 0x3241, 0x003F, 
  0x3242, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_51[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x322F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3264, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3074, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3270, 0x3271, 0x003F, 0x315F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x7425, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x332E, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x317A, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_52[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3344, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3243, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3364, 0x332F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x7055, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x336E, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3375, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_53[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3422, 0x003F, 0x003F, 0x003F, 0x003F, 0x323D, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3425, 0x3426, 0x003F, 0x3427, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3429, 0x003F, 0x342A, 
  0x342B, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3065, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x312C, 
  0x3075, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3237, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3139, 0x003F, 0x003F, 0x003F, 0x315E, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x345D, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3143, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3244, 
  0x003F, 0x003F, 0x003F, 0x3126, 0x003F, 0x003F, 0x3370, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_54[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x3346, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3125, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x345E, 0x003F, 0x003F, 0x003F, 0x346B, 
  0x003F, 0x346C, 0x003F, 0x003F, 0x346D, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3331, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3535, 0x3536, 0x3537, 0x003F, 0x3076, 0x003F, 0x003F, 
  0x3025, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3077, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_55[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x3134, 0x003F, 0x003F, 0x003F, 
  0x3548, 0x3549, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3022, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3551, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3556, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3557, 
  0x003F, 0x3558, 0x3559, 0x003F, 0x003F, 0x355A, 0x003F, 0x003F, 
  0x355B, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x356E, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x342D, 0x003F, 0x346E, 0x3365, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x354A, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3144, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x357C, 0x003F, 
  0x003F, 0x357D, 0x357E, 0x3621, 0x003F, 0x003F, 0x003F, 0x3622, 
  0x3623, 0x003F, 0x003F, 0x3624, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3626, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3627, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3628, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3629
};
static const unsigned uni2jis_tbl_56[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x362A, 0x003F, 0x003F, 
  0x362B, 0x3245, 0x362C, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3133, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x325E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x313D, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3644, 0x003F, 0x3645, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x337A, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x346F, 0x003F, 0x003F, 0x003F, 0x003F, 0x364F, 0x003F, 0x3650, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3345, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3663, 0x003F, 0x3665, 0x003F, 0x003F, 
  0x003F, 0x3666, 0x003F, 0x3667, 0x003F, 0x003F, 0x003F, 0x3668, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3671, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3674, 0x3273, 0x003F, 
  0x3078, 0x3676, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x367A, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x304F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_57[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3160, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x372E, 0x372F, 0x003F, 0x003F, 0x003F, 0x3035, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3735, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3738, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3739, 0x373A, 0x373B, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x373C, 0x373D, 0x3651, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x373F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3760, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3340, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3766, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3068, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x376F, 0x3770, 
  0x003F, 0x3771, 0x003F, 0x003F, 0x003F, 0x3772, 0x003F, 0x003F, 
  0x3773, 0x003F, 0x003F, 0x003F, 0x003F, 0x3774, 0x3775, 0x003F, 
  0x3776, 0x003F, 0x3470, 0x003F, 0x003F, 0x3777, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_58[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3778, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x342E, 0x003F, 0x003F, 0x003F, 0x003F, 0x7421, 
  0x3161, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3274, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3835, 0x003F, 0x003F, 0x3836, 
  0x3837, 0x3176, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x362D, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3843, 
  0x3844, 0x003F, 0x003F, 0x003F, 0x3845, 0x003F, 0x3846, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3847, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3275, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x306D, 0x003F, 0x385E, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_59[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x385F, 0x3860, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3861, 0x3862, 0x003F, 0x003F, 0x3246, 
  0x003F, 0x003F, 0x3863, 0x003F, 0x003F, 0x003F, 0x3330, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x317B, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3870, 0x3050, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3872, 0x3162, 0x003F, 0x3873, 0x3471, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3740, 0x3874, 0x3875, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3876, 0x003F, 0x3877, 0x003F, 0x3878, 0x3879, 0x387A, 
  0x003F, 0x387B, 0x003F, 0x387C, 0x003F, 0x317C, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x387D, 0x003F, 0x387E, 0x003F, 0x3921, 
  0x003F, 0x003F, 0x3922, 0x003F, 0x003F, 0x3923, 0x3924, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3925, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3538, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3039, 0x3848, 0x003F, 0x003F, 0x3051, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3138, 0x342F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3028, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3079, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_5a[] = {
  0x003F, 0x3052, 0x003F, 0x3023, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3864, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3964, 0x003F, 0x3965, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3966, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3967, 
  0x003F, 0x003F, 0x3968, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x396E, 0x003F, 
  0x003F, 0x396F, 0x003F, 0x003F, 0x3970, 0x003F, 0x3971, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3247, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3A23, 0x003F, 0x003F, 0x003F, 0x3779, 0x003F, 0x003F, 0x3A24, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3A25, 0x003F, 0x3A26, 0x003F, 0x003F, 0x003F, 
  0x3A27, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_5b[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3472, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3A33, 0x003F, 0x3A34, 0x003F, 0x3A35, 0x003F, 0x003F, 
  0x003F, 0x3A36, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3145, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3926, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3927, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3528, 0x3849, 0x003F, 0x3358, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3A41, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3A44, 0x3A45, 0x3A46, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3A48, 0x003F, 0x3A49, 0x3127, 
  0x003F, 0x3042, 0x3A4A, 0x003F, 0x3430, 0x003F, 0x003F, 0x3928, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3431, 0x003F, 0x003F, 0x3038, 0x3539, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3552, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x355C, 0x003F, 
  0x3A4B, 0x003F, 0x003F, 0x3332, 0x3163, 0x003F, 0x3248, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3473, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3A5E, 
  0x003F, 0x003F, 0x3428, 0x3677, 0x003F, 0x003F, 0x3A5F, 0x003F, 
  0x003F, 0x003F, 0x3A63, 0x3432, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3A64, 0x3249, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3A66, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_5c[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3053, 0x003F, 0x003F, 0x3A69, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3A6B, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3A6E, 0x003F, 
  0x003F, 0x3A6F, 0x003F, 0x3A70, 0x003F, 0x3646, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3649, 0x003F, 0x003F, 0x003F, 0x003F, 0x356F, 0x003F, 0x003F, 
  0x367E, 0x003F, 0x003F, 0x3230, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x367D, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3A7C, 
  0x3A7D, 0x3A7E, 0x003F, 0x003F, 0x003F, 0x3B21, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3474, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3B30, 0x322C, 0x3B31, 0x3B32, 0x003F, 0x003F, 0x3B33, 0x003F, 
  0x003F, 0x3464, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3359, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x345F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x362E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3265, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_5d[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3A6A, 0x003F, 
  0x003F, 0x003F, 0x3B45, 0x003F, 0x003F, 0x003F, 0x3333, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3B47, 0x3B48, 0x003F, 0x3B49, 0x3B4A, 
  0x003F, 0x003F, 0x003F, 0x3B46, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3B4B, 0x003F, 0x003F, 0x3B4C, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3B4D, 0x003F, 0x003F, 0x003F, 0x3B4E, 0x003F, 0x3B4F, 
  0x003F, 0x003F, 0x3B50, 0x3B51, 0x003F, 0x003F, 0x3B52, 0x003F, 
  0x3B53, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3B5A, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3A37, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3B76, 0x003F, 0x003F, 0x003F, 0x3B77, 
  0x003F, 0x003F, 0x003F, 0x3B78, 0x3460, 0x003F, 0x3B7A, 0x003F, 
  0x3B79, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3B7B, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3929, 0x3A38, 0x392A, 
  0x3570, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3A39, 0x003F, 
  0x003F, 0x384A, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x392B, 
  0x003F, 0x003F, 0x003F, 0x342C, 0x003F, 0x003F, 0x3652, 0x003F
};
static const unsigned uni2jis_tbl_5e[] = {
  0x003F, 0x003F, 0x3B54, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3475, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3B55, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3522, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3C35, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3C37, 0x003F, 0x003F, 0x3C38, 0x3C39, 0x003F, 0x3C3A, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3C3B, 0x003F, 0x3C3C, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3433, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x392C, 0x3434, 0x003F, 0x3838, 0x003F, 0x003F, 0x3476, 0x003F, 
  0x3C42, 0x003F, 0x003F, 0x392D, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x392E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3C45, 0x003F, 0x003F, 0x003F, 0x003F, 0x3A42, 
  0x3C48, 0x003F, 0x003F, 0x384B, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3C4C, 0x003F, 0x3043, 0x003F, 0x392F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3C4D, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3347, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3C5A, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3C5B, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3164, 0x003F, 
  0x003F, 0x003F, 0x377A, 0x3276, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_5f[] = {
  0x003F, 0x003F, 0x3C5C, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3C30, 
  0x003F, 0x003F, 0x003F, 0x355D, 0x003F, 0x307A, 0x003F, 0x003F, 
  0x3930, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3C64, 0x003F, 0x003F, 0x3C67, 0x003F, 0x3839, 0x384C, 
  0x3C68, 0x003F, 0x003F, 0x3C69, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3C65, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x362F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3C74, 0x003F, 0x3C75, 
  0x003F, 0x003F, 0x3630, 0x003F, 0x003F, 0x3C76, 0x003F, 0x003F, 
  0x3C77, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3741, 0x3C7C, 0x3C7D, 0x003F, 0x003F, 0x3C7E, 
  0x003F, 0x3A4C, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3D21, 
  0x003F, 0x3146, 0x3D22, 0x003F, 0x3D23, 0x3D24, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x317D, 0x003F, 0x003F, 0x003F, 0x3742, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3865, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x352B, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3D3A, 0x3D3B, 0x003F, 0x3D3C, 0x3477, 0x003F, 0x003F, 0x003F, 
  0x3D3D, 0x3D3E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3B56, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x317E, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3D47, 0x3277, 0x3D48, 0x3D49, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3D4E, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3D50, 0x397A, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_60[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3D53, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3D54, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3B57, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3D5A, 0x355E, 0x003F, 0x003F, 
  0x3165, 0x003F, 0x3278, 0x003F, 0x003F, 0x3D5B, 0x003F, 0x3631, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3632, 0x003F, 0x3931, 0x003F, 0x3D64, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3D68, 0x327A, 0x003F, 0x003F, 0x003F, 0x003F, 0x3D69, 
  0x3A28, 0x3238, 0x003F, 0x003F, 0x003F, 0x3633, 0x003F, 0x003F, 
  0x3366, 0x003F, 0x003F, 0x003F, 0x003F, 0x3743, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3D6E, 0x003F, 
  0x003F, 0x3C3D, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3279, 0x003F, 0x003F, 0x003F, 
  0x3D75, 0x003F, 0x003F, 0x003F, 0x003F, 0x3D76, 0x3D77, 0x3867, 
  0x003F, 0x003F, 0x3D78, 0x3435, 0x3D79, 0x3D7A, 0x3159, 0x003F, 
  0x003F, 0x003F, 0x302D, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3D7D, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3D7E, 
  0x003F, 0x003F, 0x003F, 0x3E21, 0x003F, 0x003F, 0x3E22, 0x003F, 
  0x003F, 0x003F, 0x3E23, 0x003F, 0x3E24, 0x003F, 0x003F, 0x003F, 
  0x3E25, 0x3E26, 0x3E27, 0x3E28, 0x003F, 0x003F, 0x3E29, 0x3E2A, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3E2B, 0x3E2C, 0x003F, 0x003F, 
  0x003F, 0x3E2D, 0x397B, 0x3E2E, 0x003F, 0x3E2F, 0x3E30, 0x3054, 
  0x003F, 0x003F, 0x3E31, 0x003F, 0x003F, 0x3E32, 0x003F, 0x003F, 
  0x3B34, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3E33, 0x003F, 0x003F, 0x3E34, 0x003F, 0x003F, 
  0x003F, 0x3C66, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_61[] = {
  0x003F, 0x3D25, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3055, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3672, 0x3026, 0x003F, 0x003F, 0x003F, 0x3436, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3B7C, 0x003F, 0x003F, 0x003F, 0x3932, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3437, 0x003F, 0x003F, 0x003F, 0x3745, 
  0x3334, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3056, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3744, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3E65, 0x3E66, 0x003F, 0x3E67, 
  0x3E68, 0x003F, 0x003F, 0x003F, 0x003F, 0x3E69, 0x003F, 0x003F, 
  0x3E6A, 0x3746, 0x3E6B, 0x003F, 0x003F, 0x3E6C, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x377B, 0x003F, 0x003F, 0x003F, 0x3231, 0x003F, 
  0x3E6D, 0x3E6E, 0x003F, 0x003F, 0x3E6F, 0x003F, 0x3438, 0x003F, 
  0x3E70, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3A29, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x327B, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3E7C, 
  0x003F, 0x3E7D, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x377C, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_62[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3D3F, 0x003F, 
  0x003F, 0x3266, 0x327C, 0x003F, 0x003F, 0x003F, 0x303F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3761, 
  0x003F, 0x003F, 0x3F2C, 0x3F2D, 0x003F, 0x003F, 0x003F, 0x3F2E, 
  0x003F, 0x3F2F, 0x003F, 0x3F30, 0x003F, 0x003F, 0x003F, 0x353A, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x384D, 0x3F31, 0x003F, 0x003F, 0x003F, 0x3F32, 0x003F, 0x003F, 
  0x3D6A, 0x003F, 0x3F33, 0x3F34, 0x3F35, 0x003F, 0x003F, 0x003F, 
  0x6E3D, 0x003F, 0x003F, 0x3C6A, 0x003F, 0x3A4D, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3037, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3E35, 
  0x353B, 0x003F, 0x003F, 0x003F, 0x3E36, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3933, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3F4D, 
  0x003F, 0x003F, 0x3F4E, 0x003F, 0x3221, 0x003F, 0x3F4F, 0x3F50, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3F51, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3F52, 0x003F, 
  0x327D, 0x003F, 0x3571, 0x003F, 0x003F, 0x003F, 0x3F54, 0x003F, 
  0x3934, 0x003F, 0x003F, 0x3E37, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3572, 0x3348, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3367, 0x3F21, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x377D, 0x003F, 0x003F, 0x3B22, 0x3969, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3D26, 0x003F
};
static const unsigned uni2jis_tbl_63[] = {
  0x003F, 0x3B7D, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3B58, 
  0x003F, 0x3044, 0x003F, 0x3F5E, 0x003F, 0x3F5F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3F61, 0x003F, 0x003F, 0x3F62, 0x003F, 
  0x3F63, 0x3573, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3634, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3027, 0x003F, 0x003F, 0x3A43, 0x003F, 0x003F, 0x003F, 0x3F36, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3B2B, 0x003F, 0x3F72, 0x003F, 
  0x003F, 0x003F, 0x3F73, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3C4E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3F78, 0x003F, 
  0x003F, 0x003F, 0x377E, 0x003F, 0x003F, 0x003F, 0x003F, 0x3E39, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4023, 0x003F, 0x4024, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3C78, 0x003F, 0x4028, 0x003F, 0x3E38, 0x003F, 0x003F, 0x003F, 
  0x4029, 0x003F, 0x003F, 0x003F, 0x402A, 0x402B, 0x003F, 0x003F, 
  0x3721, 0x402C, 0x402D, 0x335D, 0x003F, 0x003F, 0x402E, 0x003F, 
  0x003F, 0x3A4E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3935, 
  0x3F64, 0x3166, 0x003F, 0x003F, 0x3545, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3747, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x403C, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3439, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x302E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3478, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3167, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_64[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x404A, 0x003F, 0x404B, 0x003F, 0x003F, 0x003F, 
  0x404C, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3748, 0x003F, 0x003F, 0x003F, 0x3A71, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x405A, 
  0x003F, 0x405B, 0x405C, 0x405D, 0x405E, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4067, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4068, 0x4069, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4022, 0x406A, 0x003F, 0x406B, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3762, 0x003F, 0x406C, 0x003F, 0x406D, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x406E, 
  0x406F, 0x4070, 0x3B35, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3B23, 0x003F, 
  0x4071, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3349, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3B24, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x353C, 0x003F, 0x003F, 0x003F, 
  0x4130, 0x003F, 0x003F, 0x003F, 0x003F, 0x4131, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3E71, 0x4134
};
static const unsigned uni2jis_tbl_65[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4139, 0x003F, 0x003F, 0x003F, 0x003F, 0x413A, 
  0x003F, 0x003F, 0x003F, 0x413B, 0x413C, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3B59, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x327E, 0x003F, 0x3936, 0x003F, 0x003F, 0x003F, 0x402F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x384E, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x355F, 0x414E, 0x003F, 0x414F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3635, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4150, 
  0x4151, 0x003F, 0x343A, 0x3B36, 0x003F, 0x003F, 0x003F, 0x4152, 
  0x003F, 0x003F, 0x003F, 0x4153, 0x3749, 0x003F, 0x003F, 0x003F, 
  0x3F74, 0x003F, 0x003F, 0x003F, 0x4030, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4154, 0x003F, 0x003F, 0x4155, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4157, 0x003F, 0x003F, 
  0x003F, 0x4046, 0x4158, 0x003F, 0x003F, 0x003F, 0x3A58, 0x003F, 
  0x003F, 0x003F, 0x4159, 0x003F, 0x003F, 0x415A, 0x003F, 0x003F, 
  0x415B, 0x003F, 0x003F, 0x003F, 0x3C50, 0x415C, 0x003F, 0x003F, 
  0x415D, 0x3036, 0x003F, 0x415E, 0x3654, 0x404D, 0x415F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3B42, 0x003F, 0x4160, 0x3B5B, 
  0x3F37, 0x003F, 0x003F, 0x003F, 0x4163, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3177, 0x3B5C, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x407B, 0x003F, 0x003F, 0x4168, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x347A, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x347B, 0x003F, 0x003F, 0x003F, 0x003F, 0x356C, 
  0x3B5D, 0x4161, 0x003F, 0x003F, 0x3D5C, 0x3030, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3222, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_66[] = {
  0x003F, 0x003F, 0x3937, 0x003F, 0x003F, 0x003F, 0x3A2B, 0x3E3A, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3E3B, 0x003F, 0x003F, 0x3A2A, 
  0x003F, 0x003F, 0x003F, 0x3057, 0x404E, 0x417C, 0x417D, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x417E, 0x003F, 0x4031, 
  0x3147, 0x003F, 0x003F, 0x003F, 0x4225, 0x3D55, 0x4226, 0x003F, 
  0x3A72, 0x4227, 0x4228, 0x4229, 0x422A, 0x3E3C, 0x003F, 0x4027, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4230, 
  0x003F, 0x422F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3B7E, 0x3938, 0x003F, 0x4232, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4234, 0x3F38, 0x003F, 0x003F, 0x4237, 0x003F, 
  0x003F, 0x4236, 0x3B2F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4238, 
  0x4239, 0x423A, 0x003F, 0x423B, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x423E, 0x003F, 0x003F, 0x003F, 0x003F, 0x3322, 0x003F, 
  0x003F, 0x003F, 0x4240, 0x003F, 0x003F, 0x003F, 0x003F, 0x374A, 
  0x003F, 0x003F, 0x003F, 0x4244, 0x4032, 0x4245, 0x3E3D, 0x4247, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4243, 0x4246, 
  0x003F, 0x3647, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x324B, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x424E, 0x424F, 0x003F, 0x003F, 
  0x4250, 0x3D6B, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3045, 
  0x003F, 0x4252, 0x4253, 0x4254, 0x4255, 0x003F, 0x003F, 0x4256, 
  0x4257, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3B43, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4265, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4266, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3D6C, 0x003F, 0x4267, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x364A, 0x3148, 0x3939, 0x003F, 0x003F, 0x003F, 
  0x3D71, 0x4162, 0x003F, 0x423F, 0x003F, 0x413E, 0x413D, 0x4258
};
static const unsigned uni2jis_tbl_67[] = {
  0x3A47, 0x003F, 0x003F, 0x003F, 0x003F, 0x426E, 0x003F, 0x426F, 
  0x376E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4270, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4271, 0x3A73, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x4272, 0x003F, 0x003F, 0x4273, 0x003F, 0x003F, 0x347C, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3B25, 0x003F, 0x003F, 
  0x003F, 0x3C6B, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3479, 0x003F, 0x003F, 0x3560, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3F79, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3049, 
  0x3A60, 0x423C, 0x003F, 0x3C5D, 0x427C, 0x003F, 0x3E73, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x427E, 0x003F, 0x422B, 
  0x003F, 0x3E72, 0x003F, 0x003F, 0x003F, 0x003F, 0x4321, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4322, 0x393A, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x354F, 0x4325, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3E3E, 0x003F, 
  0x003F, 0x4327, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x404F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4330, 0x324C, 0x3B5E, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3F75, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x384F, 
  0x4331, 0x4332, 0x4333, 0x003F, 0x003F, 0x4334, 0x324D, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4335, 0x4336, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x4248, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x343B, 0x003F, 0x4077, 0x3D40, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4344, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4345, 0x003F, 0x4346, 0x003F, 0x3C46, 0x3A74, 0x4347, 0x4348, 
  0x003F, 0x003F, 0x003F, 0x3A3A, 0x003F, 0x003F, 0x003F, 0x3341
};
static const unsigned uni2jis_tbl_68[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x3149, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4072, 0x003F, 0x003F, 0x4034, 0x372A, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x434D, 
  0x003F, 0x393B, 0x337C, 0x003F, 0x003F, 0x003F, 0x003F, 0x434F, 
  0x003F, 0x003F, 0x3374, 0x003F, 0x4350, 0x4351, 0x003F, 0x4352, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4073, 0x003F, 0x003F, 0x003F, 
  0x334B, 0x3A2C, 0x003F, 0x003F, 0x334A, 0x3A4F, 0x003F, 0x003F, 
  0x003F, 0x3765, 0x374B, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3046, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x364D, 0x372C, 0x003F, 0x343C, 0x354B, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3A79, 0x003F, 0x003F, 0x3B37, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x4364, 0x003F, 0x003F, 0x003F, 0x4366, 0x3233, 0x003F, 
  0x003F, 0x4367, 0x4368, 0x4369, 0x436A, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x436B, 0x003F, 0x436C, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3034, 0x003F, 0x003F, 0x003F, 0x393C, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3E3F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3868, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3323, 0x3A2D, 0x003F, 0x003F, 0x003F, 0x003F, 0x3361, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x437A, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x347E, 0x437B, 0x003F, 0x003F, 
  0x437C, 0x003F, 0x003F, 0x347D, 0x437D, 0x003F, 0x003F, 0x437E, 
  0x4421, 0x4422, 0x003F, 0x4423, 0x003F, 0x003F, 0x4424, 0x003F, 
  0x003F, 0x4425, 0x432A, 0x003F, 0x4426, 0x4427, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4428, 0x003F, 0x003F, 
  0x4429, 0x003F, 0x442A, 0x442B, 0x003F, 0x003F, 0x3F39, 0x003F, 
  0x003F, 0x003F, 0x4033, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x343D, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_69[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3058, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3F22, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x443C, 
  0x003F, 0x3F7A, 0x003F, 0x3371, 0x3821, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x443D, 0x003F, 0x003F, 0x003F, 0x443F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x424A, 0x003F, 0x4446, 
  0x003F, 0x003F, 0x413F, 0x4447, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x444D, 0x003F, 0x003F, 0x444E, 0x3648, 0x003F, 0x3D5D, 
  0x444F, 0x003F, 0x4451, 0x003F, 0x003F, 0x364B, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4453, 0x003F, 0x335A, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3335, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3A67, 0x003F, 0x003F, 0x003F, 0x315D, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4458, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3F3A, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x445A, 0x003F, 0x003F, 0x003F, 0x445B, 0x445C, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x445F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4462, 0x003F, 0x4463, 0x003F, 0x4464, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4465, 0x003F, 0x7422, 
  0x4466, 0x003F, 0x003F, 0x393D, 0x4448, 0x4164, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4468, 0x4469, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x446A, 0x003F, 0x003F, 0x446B, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x446C, 0x446D, 
  0x003F, 0x446E, 0x003F, 0x446F, 0x003F, 0x4470, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4450, 0x003F, 0x4165, 0x4471, 0x003F
};
static const unsigned uni2jis_tbl_6a[] = {
  0x4472, 0x4473, 0x003F, 0x4474, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4374, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3E40, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3822, 0x3223, 0x335F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3E41, 0x003F, 0x003F, 
  0x003F, 0x3C79, 0x3372, 0x003F, 0x003F, 0x432E, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4526, 0x4527, 0x003F, 
  0x003F, 0x4528, 0x003F, 0x3636, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x452F, 0x003F, 
  0x354C, 0x003F, 0x003F, 0x4530, 0x003F, 0x003F, 0x003F, 0x3521, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4531, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4535, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4536, 0x3360, 
  0x4349, 0x4537, 0x003F, 0x4538, 0x003F, 0x003F, 0x4539, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3869, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4541, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x4546, 0x003F, 0x003F, 0x4547, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4548, 0x4549, 0x454A, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x454B, 0x003F, 
  0x454D, 0x454C, 0x003F, 0x003F, 0x454E, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x367B, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4558, 0x4559, 0x455A, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x455B, 0x455C, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_6b[] = {
  0x003F, 0x003F, 0x455D, 0x455E, 0x003F, 0x003F, 0x455F, 0x4560, 
  0x003F, 0x4561, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4562, 
  0x4563, 0x4564, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4565, 
  0x003F, 0x003F, 0x003F, 0x4566, 0x003F, 0x3135, 0x4567, 0x003F, 
  0x3767, 0x3C21, 0x003F, 0x3655, 0x4568, 0x003F, 0x003F, 0x3224, 
  0x4569, 0x003F, 0x003F, 0x456A, 0x456B, 0x003F, 0x003F, 0x456C, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x456D, 0x456E, 0x003F, 
  0x003F, 0x003F, 0x353D, 0x456F, 0x003F, 0x3656, 0x343E, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x324E, 0x003F, 0x4337, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x343F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4576, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3B5F, 0x4035, 0x3A21, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3B75, 
  0x003F, 0x003F, 0x003F, 0x3A50, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3B60, 0x003F, 0x457E, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3D5E, 0x3C6C, 0x3B44, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3F23, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x462F, 0x003F, 0x003F, 0x003F, 0x3225, 0x434A, 0x003F, 0x003F, 
  0x4630, 0x4631, 0x3B26, 0x334C, 0x003F, 0x4632, 0x4633, 0x4542, 
  0x003F, 0x003F, 0x003F, 0x4634, 0x4635, 0x3523, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x463D, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x463F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4640, 
  0x003F, 0x4641, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_6c[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4647, 0x003F, 0x3B61, 
  0x003F, 0x003F, 0x464A, 0x003F, 0x003F, 0x003F, 0x003F, 0x3524, 
  0x003F, 0x464B, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x464C, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x464E, 
  0x464F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4652, 0x3F65, 0x003F, 0x003F, 0x003F, 
  0x314A, 0x003F, 0x4655, 0x4656, 0x003F, 0x003F, 0x003F, 0x4657, 
  0x4475, 0x3D41, 0x3561, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4658, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3C2E, 0x003F, 0x003F, 0x003F, 0x465D, 0x003F, 0x003F, 0x3440, 
  0x003F, 0x465E, 0x3178, 0x003F, 0x4660, 0x003F, 0x003F, 0x393E, 
  0x4353, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4736, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4662, 0x003F, 0x4663, 
  0x4241, 0x003F, 0x3562, 0x003F, 0x4664, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3768, 0x4668, 0x003F, 0x3525, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x466A, 0x003F, 
  0x4440, 0x003F, 0x003F, 0x003F, 0x4659, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3723, 0x003F, 0x466E, 0x322D, 0x466F, 
  0x003F, 0x3A3B, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4672, 
  0x003F, 0x003F, 0x4274, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4673, 0x003F, 0x4674, 0x324F, 0x4675, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3C23, 0x3E42, 0x003F, 0x003F, 0x3168, 
  0x003F, 0x3637, 0x003F, 0x003F, 0x003F, 0x003F, 0x4677, 0x003F, 
  0x003F, 0x4074, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x467B, 0x467C, 0x003F, 0x467D, 0x003F, 0x467E, 0x003F, 
  0x003F, 0x003F, 0x4721, 0x003F, 0x4722, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3563, 0x003F, 0x4525, 0x003F, 0x4724, 
  0x436D, 0x4725, 0x003F, 0x4726, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4259, 0x003F, 0x003F, 0x314B, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_6d[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x472B, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x472F, 
  0x003F, 0x4730, 0x003F, 0x4731, 0x003F, 0x003F, 0x003F, 0x4076, 
  0x003F, 0x003F, 0x4732, 0x003F, 0x003F, 0x003F, 0x4636, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4445, 0x003F, 0x003F, 
  0x4735, 0x314C, 0x393F, 0x003F, 0x003F, 0x003F, 0x4737, 0x4738, 
  0x003F, 0x4739, 0x3D27, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x473A, 0x003F, 0x3368, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3E74, 0x4075, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x313A, 0x003F, 
  0x003F, 0x3940, 0x003F, 0x003F, 0x333D, 0x003F, 0x003F, 0x4743, 
  0x4744, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3324, 
  0x3F3B, 0x003F, 0x003F, 0x003F, 0x4745, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4747, 
  0x3E43, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x4748, 0x4749, 0x003F, 0x003F, 0x003F, 0x003F, 0x474C, 
  0x003F, 0x003F, 0x003F, 0x4573, 0x4642, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3336, 
  0x003F, 0x003F, 0x3155, 0x003F, 0x4750, 0x003F, 0x003F, 0x4751, 
  0x003F, 0x4752, 0x003F, 0x003F, 0x003F, 0x4753, 0x003F, 0x4754, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4755, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3D4A, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4571, 0x003F, 0x003F, 0x003F, 0x003F, 0x475C, 0x003F, 0x475D, 
  0x475E, 0x4338, 0x475F, 0x003F, 0x003F, 0x4760, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x307C, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3F3C, 0x003F, 0x3D5F, 0x4764, 0x003F, 0x003F, 0x3A2E, 
  0x003F, 0x003F, 0x003F, 0x453A, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_6e[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4036, 0x003F, 0x3369, 
  0x3A51, 0x3E44, 0x003F, 0x3D42, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x374C, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3D6D, 0x383A, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3574, 0x454F, 0x003F, 0x003F, 0x003F, 0x302F, 0x3132, 0x003F, 
  0x003F, 0x3239, 0x003F, 0x003F, 0x422C, 0x003F, 0x003F, 0x3941, 
  0x003F, 0x003F, 0x476C, 0x003F, 0x003F, 0x003F, 0x476D, 0x003F, 
  0x003F, 0x476E, 0x003F, 0x476F, 0x4770, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4771, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4778, 0x003F, 0x003F, 0x003F, 0x3850, 0x003F, 
  0x3E45, 0x003F, 0x003F, 0x4339, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4821, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4572, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3C3E, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4827, 0x003F, 0x003F, 
  0x383B, 0x003F, 0x003F, 0x4828, 0x003F, 0x003F, 0x3D60, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3942, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x306E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x482C, 0x003F, 0x003F, 
  0x003F, 0x482E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x452E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4832, 0x003F, 0x003F, 0x4834, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3C22, 0x003F, 0x4838, 0x4839, 0x003F, 
  0x003F, 0x336A, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x426C, 0x425A, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x483C, 0x483D, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4529, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x483E, 0x003F, 0x483F, 0x003F, 0x4840, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_6f[] = {
  0x003F, 0x3579, 0x003F, 0x003F, 0x4841, 0x003F, 0x3C3F, 0x003F, 
  0x4842, 0x3977, 0x4843, 0x003F, 0x4844, 0x4845, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3169, 0x4166, 0x4846, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4779, 0x003F, 0x3441, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4452, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4132, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3443, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4854, 
  0x003F, 0x4855, 0x003F, 0x003F, 0x3769, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4078, 0x485B, 0x485C, 0x3363, 
  0x003F, 0x485D, 0x485E, 0x003F, 0x3D61, 0x003F, 0x003F, 0x003F, 
  0x485F, 0x003F, 0x003F, 0x003F, 0x4860, 0x003F, 0x442C, 0x003F, 
  0x4459, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4861, 0x4862, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4863, 0x4021, 0x003F, 0x003F, 0x4864, 
  0x4865, 0x003F, 0x003F, 0x4866, 0x4867, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3442, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4875, 0x003F, 
  0x4877, 0x4543, 0x003F, 0x003F, 0x003F, 0x4878, 0x4879, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x487A, 0x003F, 0x003F, 0x003F, 
  0x3763, 0x4279, 0x003F, 0x473B, 0x003F, 0x487B, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4922, 0x003F, 
  0x396A, 0x4728, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x4924, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4275, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x6F69, 0x003F, 
  0x003F, 0x4927, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_70[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x492B, 0x492C, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4654, 0x003F, 
  0x4930, 0x003F, 0x003F, 0x4931, 0x003F, 0x003F, 0x4375, 0x426D, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4025, 0x003F, 0x003F, 0x4932, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4936, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4937, 0x4938, 0x003F, 0x003F, 0x003F, 
  0x4939, 0x493A, 0x003F, 0x003F, 0x003F, 0x003F, 0x4941, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4667, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4940, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3250, 0x003F, 0x003F, 0x003F, 0x4574, 
  0x3325, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3564, 0x003F, 0x003F, 0x003F, 0x3C5E, 0x3A52, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x494A, 0x494B, 0x003F, 
  0x003F, 0x003F, 0x3F66, 0x003F, 0x003F, 0x003F, 0x316A, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x494C, 0x494D, 0x494E, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4952, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x433A, 0x003F, 0x003F, 
  0x4954, 0x4955, 0x003F, 0x003F, 0x4956, 0x003F, 0x003F, 0x4957, 
  0x003F, 0x4540, 0x3059, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4958, 0x003F, 0x003F, 0x003F, 0x003F, 0x3128, 
  0x003F, 0x4959, 0x003F, 0x495A, 0x495B, 0x495C, 0x495D, 0x003F, 
  0x495E, 0x003F, 0x003F, 0x003F, 0x495F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4960, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4961, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_71[] = {
  0x003F, 0x003F, 0x003F, 0x4962, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x316B, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3E47, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x496E, 
  0x496F, 0x4970, 0x003F, 0x003F, 0x003F, 0x003F, 0x4133, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3E46, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4975, 
  0x003F, 0x003F, 0x4976, 0x003F, 0x003F, 0x003F, 0x4079, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x497A, 
  0x003F, 0x316C, 0x497B, 0x003F, 0x497C, 0x003F, 0x497D, 0x003F, 
  0x497E, 0x003F, 0x003F, 0x003F, 0x4761, 0x003F, 0x003F, 0x3E48, 
  0x003F, 0x4851, 0x003F, 0x003F, 0x003F, 0x003F, 0x3C51, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x407A, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4A25, 
  0x003F, 0x003F, 0x3727, 0x003F, 0x4A26, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4A27, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x7426, 0x4A28, 0x4A29, 0x003F, 0x003F, 0x003F, 0x3D4F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4A2C, 
  0x4A2D, 0x472E, 0x4A2E, 0x4A2F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4A30, 0x003F, 0x003F, 0x003F, 0x003F, 0x4A31, 
  0x4A32, 0x4A33, 0x003F, 0x4733, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4575, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x316D, 0x4A38, 0x003F, 
  0x003F, 0x003F, 0x4A3A, 0x003F, 0x4A3B, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4167, 0x3B38, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3F24, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4A3C, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4A3D, 0x003F
};
static const unsigned uni2jis_tbl_72[] = {
  0x4A3E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x477A, 0x4A3F, 
  0x4A40, 0x4A41, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4A42, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x445E, 0x4A48, 0x003F, 0x003F, 0x003F, 0x4A49, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3C5F, 0x4963, 0x003F, 
  0x003F, 0x4A4C, 0x003F, 0x003F, 0x003F, 0x4156, 0x3C24, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4A50, 0x003F, 0x003F, 
  0x4847, 0x003F, 0x003F, 0x003F, 0x4757, 0x003F, 0x4A51, 0x4A52, 
  0x003F, 0x003F, 0x442D, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3267, 0x003F, 0x356D, 0x4A58, 0x003F, 0x4A59, 0x003F, 
  0x4A5A, 0x3234, 0x003F, 0x4A5B, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x4A2A, 0x003F, 0x4A5D, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x4A60, 0x4037, 0x003F, 0x003F, 0x003F, 0x003F, 0x4A61, 
  0x4A62, 0x4643, 0x003F, 0x003F, 0x003F, 0x3823, 0x003F, 0x003F, 
  0x3A54, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x4A67, 0x003F, 0x003F, 0x003F, 0x4A68, 0x4A69, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4A6A, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4A6B, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x353E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4A6C, 0x003F, 0x003F, 0x003F, 0x3824, 0x003F, 0x003F, 0x4848, 
  0x003F, 0x4A6F, 0x003F, 0x003F, 0x4A70, 0x003F, 0x3E75, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4A71, 0x003F, 
  0x003F, 0x4A72, 0x3638, 0x003F, 0x003F, 0x003F, 0x003F, 0x4A73, 
  0x003F, 0x4A74, 0x003F, 0x003F, 0x4A75, 0x003F, 0x003F, 0x003F, 
  0x3851, 0x003F, 0x003F, 0x003F, 0x003F, 0x4A76, 0x4A77, 0x3669, 
  0x4A78, 0x4140, 0x003F, 0x397D, 0x003F, 0x003F, 0x003F, 0x4A79, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4A7A, 0x003F, 0x003F, 
  0x003F, 0x3C6D, 0x003F, 0x003F, 0x4648, 0x3639, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4A7B, 0x4A7C, 0x003F, 0x003F, 0x003F, 
  0x432C, 0x003F, 0x4A7D, 0x4A7E, 0x003F, 0x4762, 0x4B21, 0x003F
};
static const unsigned uni2jis_tbl_73[] = {
  0x003F, 0x003F, 0x4B22, 0x003F, 0x4B23, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4376, 0x472D, 0x003F, 0x003F, 0x3825, 0x003F, 
  0x003F, 0x003F, 0x4B33, 0x003F, 0x003F, 0x4B34, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4B35, 0x4B36, 0x003F, 0x4B37, 0x003F, 0x316E, 
  0x003F, 0x003F, 0x003F, 0x4B38, 0x3976, 0x3B62, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4B39, 0x003F, 0x003F, 
  0x4B3A, 0x003F, 0x4B3B, 0x003F, 0x003F, 0x003F, 0x4B3C, 0x003F, 
  0x4B3D, 0x003F, 0x003F, 0x003F, 0x003F, 0x4B3E, 0x4B3F, 0x4B40, 
  0x4B41, 0x003F, 0x003F, 0x3D43, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x334D, 0x003F, 0x003F, 0x003F, 0x003F, 0x4B4A, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4B4C, 0x003F, 0x003F, 0x003F, 
  0x4B4D, 0x4B4E, 0x003F, 0x4B4F, 0x383C, 0x4B50, 0x4B51, 0x003F, 
  0x003F, 0x364C, 0x003F, 0x3226, 0x003F, 0x003F, 0x4B52, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x366A, 0x4B56, 
  0x4B57, 0x003F, 0x003F, 0x003F, 0x4B58, 0x003F, 0x4B59, 0x4B5A, 
  0x4B5B, 0x003F, 0x4B5C, 0x003F, 0x003F, 0x003F, 0x4B5E, 0x003F, 
  0x003F, 0x3461, 0x003F, 0x4B60, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x4B64, 0x003F, 0x003F, 0x4B65, 0x4B66, 0x003F, 0x4B67, 
  0x003F, 0x003F, 0x3251, 0x003F, 0x003F, 0x4B68, 0x4B69, 0x003F, 
  0x003F, 0x4B6A, 0x3B39, 0x4B6B, 0x003F, 0x4441, 0x003F, 0x4B6D, 
  0x003F, 0x003F, 0x003F, 0x4B6F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x4B71, 0x003F, 0x003F, 0x003F, 0x4B72, 0x003F, 0x003F, 
  0x3C6E, 0x4B73, 0x003F, 0x4B74, 0x003F, 0x003F, 0x4B75, 0x4B76, 
  0x003F, 0x4B77, 0x373E, 0x003F, 0x003F, 0x4849, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4B79, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4B7C, 0x4B7D, 0x003F, 0x4B7E, 0x383D, 0x4C21
};
static const unsigned uni2jis_tbl_74[] = {
  0x003F, 0x4C23, 0x003F, 0x3565, 0x4C24, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4C26, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4C28, 0x4C29, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4276, 0x003F, 0x003F, 0x003F, 0x4C2B, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4C2F, 0x003F, 0x4C31, 0x003F, 0x4C33, 
  0x4C34, 0x4C35, 0x003F, 0x003F, 0x3657, 0x487C, 0x474A, 0x003F, 
  0x003F, 0x4C36, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4C3A, 0x4C3B, 
  0x003F, 0x003F, 0x003F, 0x4C3C, 0x003F, 0x4C3D, 0x003F, 0x003F, 
  0x003F, 0x4C3E, 0x4C3F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4C40, 
  0x003F, 0x003F, 0x386A, 0x314D, 0x003F, 0x003F, 0x3F70, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x7424, 0x003F, 0x003F, 0x003F, 
  0x4C45, 0x003F, 0x003F, 0x4C46, 0x003F, 0x4C47, 0x4C48, 0x003F, 
  0x003F, 0x4C49, 0x003F, 0x3A3C, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4C4E, 0x4C4F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4C51, 
  0x4C52, 0x4C53, 0x4C54, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4C59, 
  0x4C5A, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4C5D, 0x003F, 
  0x4C5E, 0x003F, 0x4C60, 0x4C61, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3444, 0x4C64, 0x4C65, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4C68, 0x003F, 0x3C25, 0x003F, 0x4C69, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4C6A, 0x4C6B, 0x003F, 0x003F, 0x4C6C, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4C6F, 0x003F, 0x003F, 0x4C71, 0x313B, 0x003F, 0x4C72, 0x003F, 
  0x003F, 0x003F, 0x493B, 0x003F, 0x003F, 0x003F, 0x3424, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4C78, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4953, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4C7B, 0x4C7C, 0x003F, 0x003F, 0x4C7D
};
static const unsigned uni2jis_tbl_75[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3979, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4D23, 
  0x3445, 0x003F, 0x3F53, 0x003F, 0x453C, 0x003F, 0x003F, 0x4038, 
  0x4D24, 0x4D25, 0x003F, 0x3B3A, 0x4D26, 0x3179, 0x003F, 0x4D27, 
  0x003F, 0x4D28, 0x4D29, 0x4A63, 0x003F, 0x003F, 0x003F, 0x4D2A, 
  0x4544, 0x003F, 0x3943, 0x3F3D, 0x003F, 0x003F, 0x4D2B, 0x434B, 
  0x003F, 0x4D2C, 0x442E, 0x3268, 0x003F, 0x4D2D, 0x4D2E, 0x4D2F, 
  0x4D30, 0x003F, 0x003F, 0x4D31, 0x003F, 0x003F, 0x003F, 0x4D32, 
  0x4D33, 0x003F, 0x003F, 0x003F, 0x3326, 0x003F, 0x003F, 0x305A, 
  0x003F, 0x482A, 0x003F, 0x003F, 0x484A, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x435C, 0x4026, 0x003F, 0x003F, 
  0x482B, 0x003F, 0x492D, 0x003F, 0x003F, 0x003F, 0x374D, 0x003F, 
  0x003F, 0x003F, 0x4856, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x305B, 0x4D3C, 0x003F, 0x3E76, 0x003F, 0x003F, 0x003F, 0x466D, 
  0x003F, 0x4D3D, 0x4D3E, 0x4D3F, 0x003F, 0x003F, 0x003F, 0x3526, 
  0x003F, 0x4D43, 0x003F, 0x003F, 0x003F, 0x4D44, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4925, 0x003F, 0x003F, 0x4142, 0x4141, 
  0x4D45, 0x353F, 0x4D46, 0x4D47, 0x003F, 0x4D48, 0x003F, 0x003F, 
  0x003F, 0x4D49, 0x003F, 0x003F, 0x4D4A, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4D4B, 0x003F, 0x4D4C, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3156, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4868, 0x003F, 0x4D4D, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3F3E, 0x4D4E, 0x003F, 0x003F, 0x003F, 0x3C40, 0x4D4F, 
  0x4D50, 0x4D51, 0x003F, 0x003F, 0x003F, 0x4942, 0x003F, 0x3E49, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3C26, 0x3A2F, 0x003F, 0x003F, 
  0x4577, 0x003F, 0x003F, 0x444B, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4D5D, 
  0x003F, 0x4169, 0x003F, 0x003F, 0x4D5E, 0x003F, 0x4D5F, 0x4D60, 
  0x003F, 0x4D61, 0x003F, 0x003F, 0x4354, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_76[] = {
  0x003F, 0x003F, 0x4D64, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4D68, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4D6C, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x4D70, 0x003F, 0x4D71, 0x4D72, 0x4D73, 0x4D74, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x4D78, 0x003F, 0x003F, 0x003F, 0x4D79, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4D7A, 0x4D7B, 0x003F, 0x4D7C, 0x003F, 0x003F, 
  0x4D7D, 0x4D7E, 0x4E21, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4E27, 0x4E28, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3462, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4C7E, 0x003F, 0x003F, 0x4E2B, 0x4A4A, 0x003F, 
  0x003F, 0x4E2C, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4E2D, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4E2E, 0x4E2F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4E30, 0x4E31, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x482F, 0x4550, 0x003F, 0x4772, 0x4934, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x452A, 0x003F, 0x3327, 0x3944, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4E37, 0x4E38, 0x003F, 0x003F, 
  0x3B29, 0x003F, 0x003F, 0x003F, 0x003F, 0x4E39, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4E3B, 0x4E3C, 0x003F, 0x4E3D, 
  0x4E3E, 0x003F, 0x4E3F, 0x4E40, 0x4E41, 0x4E42, 0x4E43, 0x4E44, 
  0x4E45, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4869, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x7369, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3B2E, 
  0x003F, 0x003F, 0x003F, 0x4756, 0x003F, 0x003F, 0x4B5F, 0x003F, 
  0x314E, 0x003F, 0x3157, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4E4F, 0x003F, 0x003F, 0x4570, 
  0x003F, 0x003F, 0x003F, 0x4039, 0x003F, 0x003F, 0x003F, 0x4C41, 
  0x4E51, 0x003F, 0x003F, 0x3446, 0x4857, 0x003F, 0x4E52, 0x003F, 
  0x4E53, 0x003F, 0x003F, 0x003F, 0x4E54, 0x003F, 0x4C5C, 0x003F, 
  0x4E55, 0x4E56, 0x4C55, 0x003F, 0x443E, 0x003F, 0x003F, 0x003F, 
  0x416A, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3D62, 0x003F
};
static const unsigned uni2jis_tbl_77[] = {
  0x003F, 0x3E4A, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x487D, 0x4E5C, 0x3447, 0x3829, 0x003F, 0x4E5D, 0x003F, 
  0x003F, 0x003F, 0x4E5E, 0x003F, 0x003F, 0x003F, 0x003F, 0x4E61, 
  0x003F, 0x4E62, 0x4E63, 0x003F, 0x4E64, 0x003F, 0x003F, 0x3F3F, 
  0x4C32, 0x003F, 0x4E65, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4E66, 0x003F, 0x003F, 0x003F, 0x003F, 0x4E67, 0x4E68, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x442F, 0x003F, 0x3463, 0x003F, 0x003F, 0x003F, 
  0x4365, 0x003F, 0x003F, 0x003F, 0x003F, 0x4E71, 0x4E72, 0x003F, 
  0x003F, 0x003F, 0x4E73, 0x003F, 0x003F, 0x4E74, 0x4E75, 0x003F, 
  0x003F, 0x003F, 0x4E77, 0x003F, 0x003F, 0x003F, 0x4E78, 0x4E79, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4E7A, 0x003F, 0x4E7B, 0x003F, 
  0x003F, 0x3F67, 0x003F, 0x4644, 0x003F, 0x003F, 0x4B53, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4F24, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4F26, 0x4F27, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4F2B, 0x003F, 0x003F, 0x003F, 0x4F2C, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4F2D, 0x4F2E, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4F2F, 0x4F30, 0x4F31, 0x003F, 
  0x003F, 0x003F, 0x4F32, 0x003F, 0x003F, 0x003F, 0x003F, 0x4F33, 
  0x003F, 0x003F, 0x4F34, 0x003F, 0x003F, 0x4A4D, 0x003F, 0x4F35, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3D56, 0x4E46, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4637, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4F3B, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x4F41, 0x003F, 0x4C37, 0x003F, 0x003F, 0x4F42, 0x003F, 
  0x4F44, 0x003F, 0x4C70, 0x003F, 0x003F, 0x434E, 0x003F, 0x476A, 
  0x003F, 0x366B, 0x4F47, 0x003F, 0x4F48, 0x433B, 0x003F, 0x363A, 
  0x003F, 0x4F4A, 0x003F, 0x4050, 0x4F4B, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_78[] = {
  0x003F, 0x003F, 0x3A3D, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x4F50, 0x003F, 0x003F, 0x003F, 0x4F51, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3826, 0x3A55, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4F54, 0x003F, 0x003F, 
  0x003F, 0x4F55, 0x4F56, 0x4F57, 0x003F, 0x4556, 0x3A56, 0x354E, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4F58, 0x4F59, 0x003F, 
  0x4F5A, 0x003F, 0x4B24, 0x003F, 0x474B, 0x4F5B, 0x003F, 0x4F5C, 
  0x003F, 0x003F, 0x4557, 0x003F, 0x003F, 0x003F, 0x003F, 0x395C, 
  0x003F, 0x003F, 0x003F, 0x4F5D, 0x4F5E, 0x003F, 0x003F, 0x4F5F, 
  0x4F60, 0x003F, 0x003F, 0x003F, 0x4F61, 0x003F, 0x4F62, 0x003F, 
  0x003F, 0x003F, 0x4F63, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4F64, 0x3E4B, 0x4F65, 0x003F, 
  0x4F66, 0x4F67, 0x003F, 0x4F68, 0x4F69, 0x003F, 0x003F, 0x003F, 
  0x4F6A, 0x003F, 0x4F6B, 0x4E32, 0x3945, 0x003F, 0x4F6C, 0x3827, 
  0x003F, 0x003F, 0x4823, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4F6D, 0x003F, 0x003F, 0x003F, 0x4F6E, 0x003F, 
  0x003F, 0x386B, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4476, 
  0x003F, 0x003F, 0x4F6F, 0x003F, 0x003F, 0x3337, 0x003F, 0x4F70, 
  0x003F, 0x486A, 0x003F, 0x3130, 0x4F71, 0x3A6C, 0x003F, 0x4F52, 
  0x4F72, 0x003F, 0x003F, 0x003F, 0x003F, 0x4F74, 0x4F75, 0x4F76, 
  0x003F, 0x4F73, 0x003F, 0x003F, 0x4F77, 0x003F, 0x003F, 0x4A4B, 
  0x4F78, 0x4059, 0x003F, 0x003F, 0x4F79, 0x4F7A, 0x003F, 0x003F, 
  0x4F7B, 0x4F7C, 0x4F7D, 0x4F7E, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x334E, 0x5021, 0x003F, 0x5022, 0x003F, 0x5023, 
  0x003F, 0x3C27, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5024, 
  0x5025, 0x5026, 0x003F, 0x003F, 0x5027, 0x003F, 0x5028, 0x003F, 
  0x4858, 0x003F, 0x5029, 0x502A, 0x003F, 0x502B, 0x502C, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x502F, 
  0x003F, 0x5031, 0x003F, 0x003F, 0x502D, 0x003F, 0x5032, 0x003F, 
  0x4B61, 0x003F, 0x5033, 0x003F, 0x003F, 0x003F, 0x003F, 0x306B, 
  0x003F, 0x003F, 0x5034, 0x5035, 0x003F, 0x003F, 0x5037, 0x5038, 
  0x003F, 0x003F, 0x5039, 0x503A, 0x003F, 0x003F, 0x003F, 0x503B
};
static const unsigned uni2jis_tbl_79[] = {
  0x5036, 0x3E4C, 0x003F, 0x003F, 0x003F, 0x003F, 0x503C, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x503D, 0x003F, 0x4143, 0x003F, 
  0x503E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x503F, 0x003F, 0x5040, 0x003F, 0x5041, 0x5042, 
  0x5043, 0x003F, 0x003F, 0x003F, 0x003F, 0x5044, 0x003F, 0x5045, 
  0x003F, 0x5046, 0x003F, 0x003F, 0x003F, 0x5047, 0x003F, 0x003F, 
  0x003F, 0x5048, 0x003F, 0x003F, 0x5049, 0x504A, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3C28, 0x504B, 0x4E69, 0x504C, 0x3C52, 0x504D, 
  0x003F, 0x3737, 0x003F, 0x003F, 0x504E, 0x504F, 0x5050, 0x3540, 
  0x3527, 0x3B63, 0x5051, 0x5052, 0x003F, 0x003F, 0x003F, 0x5053, 
  0x4D34, 0x5054, 0x003F, 0x003F, 0x5055, 0x003F, 0x4144, 0x003F, 
  0x5056, 0x003F, 0x003F, 0x5057, 0x5058, 0x3D4B, 0x3F40, 0x003F, 
  0x003F, 0x003F, 0x472A, 0x003F, 0x003F, 0x3E4D, 0x003F, 0x5059, 
  0x493C, 0x505A, 0x003F, 0x505B, 0x003F, 0x3A57, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x505C, 0x003F, 0x003F, 0x003F, 0x003F, 0x4578, 
  0x003F, 0x505D, 0x003F, 0x505E, 0x505F, 0x003F, 0x5060, 0x003F, 
  0x003F, 0x3658, 0x003F, 0x003F, 0x4F3D, 0x4135, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x5061, 0x5062, 0x3252, 0x4477, 0x4A21, 
  0x003F, 0x5063, 0x003F, 0x5064, 0x5065, 0x5066, 0x5067, 0x003F, 
  0x5068, 0x003F, 0x003F, 0x5069, 0x506A, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x506B, 0x003F, 0x003F, 0x003F, 0x003F, 0x357A, 0x003F, 
  0x506C, 0x506D, 0x003F, 0x506E, 0x003F, 0x003F, 0x003F, 0x506F, 
  0x4729, 0x5070, 0x003F, 0x003F, 0x5071, 0x003F, 0x003F, 0x003F, 
  0x5072, 0x003F, 0x003F, 0x5073, 0x003F, 0x3659, 0x3253, 0x4645, 
  0x3D28, 0x3B64, 0x5074, 0x003F, 0x5075, 0x003F, 0x003F, 0x5076, 
  0x5077, 0x003F, 0x5078, 0x3D29, 0x003F, 0x003F, 0x003F, 0x5079, 
  0x003F, 0x324A, 0x4943, 0x003F, 0x507A, 0x003F, 0x507B, 0x003F, 
  0x486B, 0x003F, 0x507C, 0x003F, 0x003F, 0x507D, 0x507E, 0x4145, 
  0x5121, 0x003F, 0x5122, 0x003F, 0x4769, 0x5123, 0x3F41, 0x003F, 
  0x003F, 0x4361, 0x5124, 0x5125, 0x003F, 0x5126, 0x003F, 0x003F, 
  0x3E4E, 0x5127, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5128, 0x003F, 0x003F, 0x305C, 0x5129, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_7a[] = {
  0x3529, 0x003F, 0x512A, 0x512B, 0x003F, 0x003F, 0x003F, 0x512C, 
  0x003F, 0x512D, 0x512E, 0x4478, 0x512F, 0x003F, 0x4047, 0x003F, 
  0x003F, 0x5130, 0x003F, 0x003F, 0x4C2D, 0x5131, 0x003F, 0x4923, 
  0x003F, 0x003F, 0x4355, 0x5132, 0x4E47, 0x003F, 0x5133, 0x003F, 
  0x003F, 0x5134, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5135, 
  0x003F, 0x003F, 0x003F, 0x5136, 0x003F, 0x5137, 0x3C6F, 0x5138, 
  0x5139, 0x003F, 0x3070, 0x003F, 0x513A, 0x513B, 0x003F, 0x003F, 
  0x513C, 0x513D, 0x513E, 0x003F, 0x3254, 0x374E, 0x003F, 0x3946, 
  0x3972, 0x003F, 0x4A66, 0x003F, 0x003F, 0x5140, 0x4B54, 0x5141, 
  0x5142, 0x003F, 0x003F, 0x003F, 0x5143, 0x4051, 0x314F, 0x323A, 
  0x302C, 0x003F, 0x003F, 0x003F, 0x003F, 0x5144, 0x5145, 0x003F, 
  0x003F, 0x5146, 0x003F, 0x003F, 0x5147, 0x5148, 0x003F, 0x5149, 
  0x514A, 0x003F, 0x003F, 0x3E77, 0x003F, 0x514B, 0x003F, 0x514C, 
  0x003F, 0x003F, 0x514D, 0x334F, 0x003F, 0x514E, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x376A, 0x514F, 0x3566, 0x003F, 
  0x5150, 0x003F, 0x3675, 0x003F, 0x003F, 0x003F, 0x5151, 0x407C, 
  0x5152, 0x464D, 0x5153, 0x4060, 0x3A75, 0x5154, 0x5155, 0x003F, 
  0x003F, 0x003F, 0x5156, 0x5157, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5158, 0x5159, 0x4362, 0x416B, 0x515A, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x515B, 0x3722, 
  0x515C, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3726, 0x003F, 0x515E, 0x003F, 0x3567, 0x4D52, 
  0x003F, 0x003F, 0x003F, 0x515F, 0x003F, 0x5160, 0x003F, 0x003F, 
  0x003F, 0x5161, 0x312E, 0x5162, 0x5163, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3376, 0x003F, 0x003F, 0x5164, 0x003F, 
  0x003F, 0x5165, 0x003F, 0x4E29, 0x5166, 0x003F, 0x5167, 0x003F, 
  0x003F, 0x5168, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x5169, 0x4E35, 0x003F, 0x003F, 0x706F, 
  0x3E4F, 0x003F, 0x003F, 0x3D57, 0x003F, 0x4638, 0x003F, 0x003F, 
  0x516A, 0x516B, 0x4328, 0x516C, 0x516D, 0x003F, 0x003F, 0x433C, 
  0x003F, 0x516E, 0x003F, 0x003F, 0x516F, 0x003F, 0x3625, 0x003F, 
  0x513F, 0x435D, 0x3C33, 0x5170, 0x003F, 0x5171, 0x5172, 0x3448
};
static const unsigned uni2jis_tbl_7b[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5173, 
  0x3568, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3E50, 0x003F, 0x003F, 0x5174, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x452B, 0x003F, 0x003F, 0x003F, 0x5175, 
  0x335E, 0x003F, 0x003F, 0x5176, 0x003F, 0x3F5A, 0x4964, 0x5177, 
  0x003F, 0x5178, 0x5179, 0x517A, 0x4268, 0x517B, 0x517C, 0x517D, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x5222, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3A7B, 0x003F, 0x003F, 0x003F, 0x5223, 0x003F, 0x5224, 
  0x5225, 0x5226, 0x003F, 0x003F, 0x003F, 0x003F, 0x492E, 0x5227, 
  0x4826, 0x4579, 0x003F, 0x365A, 0x003F, 0x003F, 0x5228, 0x4835, 
  0x003F, 0x435E, 0x457B, 0x003F, 0x457A, 0x5229, 0x3A76, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x522A, 0x003F, 0x003F, 0x003F, 0x522B, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x522D, 0x522E, 0x003F, 0x003F, 0x522F, 0x003F, 0x5230, 
  0x003F, 0x003F, 0x5231, 0x5232, 0x003F, 0x003F, 0x003F, 0x5233, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x5234, 0x003F, 0x4A4F, 0x3255, 
  0x003F, 0x5235, 0x003F, 0x003F, 0x003F, 0x003F, 0x5236, 0x003F, 
  0x5237, 0x5238, 0x003F, 0x003F, 0x4773, 0x4C27, 0x5239, 0x3B3B, 
  0x003F, 0x003F, 0x003F, 0x523A, 0x003F, 0x003F, 0x523B, 0x003F, 
  0x523C, 0x3449, 0x003F, 0x003F, 0x003F, 0x523D, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x433D, 0x003F, 0x523E, 0x407D, 0x003F, 0x523F, 
  0x5240, 0x4822, 0x5241, 0x003F, 0x003F, 0x5242, 0x5243, 0x003F, 
  0x4824, 0x003F, 0x5244, 0x5245, 0x5246, 0x5247, 0x003F, 0x003F, 
  0x4061, 0x003F, 0x5248, 0x003F, 0x484F, 0x5249, 0x003F, 0x4A53, 
  0x524A, 0x435B, 0x524B, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x524C, 0x003F, 0x524D, 0x524E, 
  0x003F, 0x524F, 0x5250, 0x5251, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3C44, 0x003F, 0x003F, 0x003F, 0x4646, 0x003F, 0x003F, 0x003F, 
  0x5252, 0x003F, 0x5253, 0x003F, 0x003F, 0x4F36, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x5254, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5257, 0x5258, 0x5259, 0x003F, 0x525A, 0x003F, 0x525B, 0x003F
};
static const unsigned uni2jis_tbl_7c[] = {
  0x003F, 0x525C, 0x525D, 0x525E, 0x525F, 0x003F, 0x5260, 0x003F, 
  0x003F, 0x5261, 0x003F, 0x5262, 0x5263, 0x003F, 0x5264, 0x5265, 
  0x003F, 0x003F, 0x5255, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x5266, 0x003F, 0x5267, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5268, 0x344A, 0x003F, 0x003F, 0x003F, 0x5269, 0x526A, 0x003F, 
  0x526B, 0x003F, 0x003F, 0x003F, 0x526C, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x526D, 0x003F, 0x526E, 0x526F, 0x003F, 0x5270, 0x003F, 
  0x4876, 0x5271, 0x5272, 0x003F, 0x003F, 0x003F, 0x4E7C, 0x4A6D, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5273, 0x003F, 
  0x003F, 0x003F, 0x5274, 0x003F, 0x003F, 0x4052, 0x003F, 0x003F, 
  0x003F, 0x5276, 0x5277, 0x5278, 0x003F, 0x5275, 0x003F, 0x003F, 
  0x003F, 0x5279, 0x527A, 0x527B, 0x527C, 0x527D, 0x527E, 0x003F, 
  0x003F, 0x5321, 0x003F, 0x5322, 0x003F, 0x003F, 0x003F, 0x5323, 
  0x003F, 0x5324, 0x003F, 0x003F, 0x003F, 0x5325, 0x5326, 0x003F, 
  0x5327, 0x003F, 0x5328, 0x4A46, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x5329, 0x003F, 0x003F, 0x532A, 0x532B, 0x4C62, 0x003F, 
  0x003F, 0x364E, 0x3729, 0x003F, 0x003F, 0x003F, 0x532C, 0x532D, 
  0x003F, 0x4A34, 0x003F, 0x3F68, 0x003F, 0x4C30, 0x003F, 0x532E, 
  0x003F, 0x003F, 0x4E33, 0x003F, 0x532F, 0x4774, 0x003F, 0x4146, 
  0x4734, 0x003F, 0x003F, 0x3D4D, 0x003F, 0x003F, 0x5330, 0x3040, 
  0x5331, 0x003F, 0x003F, 0x003F, 0x003F, 0x3421, 0x5332, 0x3E51, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5333, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5334, 0x5335, 
  0x003F, 0x003F, 0x5336, 0x5337, 0x5338, 0x003F, 0x403A, 0x5339, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x533A, 0x003F, 0x003F, 0x533B, 
  0x533C, 0x533D, 0x3852, 0x003F, 0x003F, 0x533E, 0x4138, 0x533F, 
  0x003F, 0x003F, 0x003F, 0x5340, 0x5341, 0x5342, 0x457C, 0x5343, 
  0x003F, 0x5344, 0x5345, 0x003F, 0x003F, 0x5346, 0x4A35, 0x416C, 
  0x3947, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5347, 0x4E48, 
  0x003F, 0x5348, 0x003F, 0x5349, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x534A, 0x003F, 0x003F, 
  0x3B65, 0x003F, 0x003F, 0x374F, 0x003F, 0x003F, 0x356A, 0x003F
};
static const unsigned uni2jis_tbl_7d[] = {
  0x352A, 0x003F, 0x003F, 0x534B, 0x4C73, 0x3948, 0x647E, 0x534C, 
  0x534D, 0x534E, 0x003F, 0x4C66, 0x003F, 0x473C, 0x003F, 0x534F, 
  0x4933, 0x5350, 0x5351, 0x5352, 0x3D63, 0x003F, 0x5353, 0x3C53, 
  0x3949, 0x3B66, 0x3569, 0x4A36, 0x003F, 0x5354, 0x5355, 0x003F, 
  0x4147, 0x4B42, 0x3A77, 0x5356, 0x003F, 0x003F, 0x5357, 0x003F, 
  0x003F, 0x003F, 0x5358, 0x3B67, 0x445D, 0x5359, 0x003F, 0x4E5F, 
  0x3A59, 0x535A, 0x003F, 0x3F42, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3E52, 0x3A30, 0x003F, 0x535B, 0x535C, 0x535D, 0x003F, 
  0x535E, 0x535F, 0x3D2A, 0x383E, 0x4148, 0x003F, 0x003F, 0x5360, 
  0x5361, 0x003F, 0x003F, 0x003F, 0x3750, 0x5362, 0x003F, 0x003F, 
  0x376B, 0x5363, 0x003F, 0x5364, 0x003F, 0x003F, 0x003F, 0x5365, 
  0x003F, 0x5366, 0x5367, 0x003F, 0x5368, 0x5369, 0x394A, 0x003F, 
  0x003F, 0x4D6D, 0x303C, 0x003F, 0x003F, 0x536A, 0x356B, 0x536B, 
  0x003F, 0x003F, 0x536C, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x536D, 0x457D, 0x003F, 0x003F, 0x003F, 0x3328, 0x4064, 0x003F, 
  0x536E, 0x3828, 0x536F, 0x5370, 0x003F, 0x003F, 0x003F, 0x5371, 
  0x003F, 0x5372, 0x5373, 0x5374, 0x003F, 0x5375, 0x5376, 0x003F, 
  0x5377, 0x003F, 0x003F, 0x5378, 0x5379, 0x537A, 0x003F, 0x003F, 
  0x003F, 0x537B, 0x003F, 0x003F, 0x003F, 0x003F, 0x537C, 0x537D, 
  0x003F, 0x3751, 0x4233, 0x003F, 0x416E, 0x537E, 0x5421, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5422, 0x5423, 
  0x003F, 0x003F, 0x5424, 0x003F, 0x3C7A, 0x305D, 0x003F, 0x003F, 
  0x003F, 0x394B, 0x4C56, 0x5425, 0x4456, 0x003F, 0x5426, 0x5427, 
  0x003F, 0x5428, 0x003F, 0x433E, 0x003F, 0x003F, 0x303D, 0x4C4A, 
  0x003F, 0x003F, 0x5429, 0x542A, 0x542B, 0x542C, 0x542D, 0x003F, 
  0x003F, 0x003F, 0x365B, 0x486C, 0x542E, 0x542F, 0x5430, 0x416D, 
  0x003F, 0x4E50, 0x3D6F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5431, 
  0x003F, 0x5432, 0x407E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4479, 0x003F, 0x5434, 0x003F, 0x003F, 0x5435, 0x5436, 0x003F, 
  0x4A54, 0x344B, 0x5437, 0x5438, 0x4C4B, 0x5439, 0x003F, 0x305E, 
  0x003F, 0x543A, 0x003F, 0x003F, 0x4E7D, 0x543B, 0x543C, 0x003F, 
  0x003F, 0x543D, 0x543E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_7e[] = {
  0x5433, 0x316F, 0x003F, 0x003F, 0x466C, 0x003F, 0x003F, 0x003F, 
  0x543F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5440, 0x5441, 0x003F, 0x003F, 0x003F, 0x5442, 0x003F, 0x5443, 
  0x003F, 0x003F, 0x003F, 0x477B, 0x5444, 0x5445, 0x3C4A, 0x003F, 
  0x5446, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3D44, 0x5447, 
  0x5448, 0x003F, 0x003F, 0x4B25, 0x5449, 0x544A, 0x3D4C, 0x544B, 
  0x003F, 0x003F, 0x003F, 0x544C, 0x003F, 0x003F, 0x544D, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4053, 0x544E, 
  0x003F, 0x484B, 0x003F, 0x003F, 0x544F, 0x5450, 0x003F, 0x5451, 
  0x003F, 0x003F, 0x4121, 0x3752, 0x003F, 0x3D2B, 0x5452, 0x003F, 
  0x5453, 0x003F, 0x5454, 0x003F, 0x3F25, 0x4136, 0x003F, 0x003F, 
  0x5455, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5456, 
  0x003F, 0x5457, 0x5458, 0x003F, 0x003F, 0x5459, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x545A, 0x003F, 0x4B7A, 0x545B, 0x545C, 
  0x372B, 0x003F, 0x003F, 0x545D, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x545E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x545F, 0x003F, 
  0x003F, 0x5460, 0x3B3C, 0x003F, 0x003F, 0x003F, 0x5461, 0x5462, 
  0x003F, 0x003F, 0x5463, 0x003F, 0x003F, 0x5464, 0x003F, 0x453B, 
  0x003F, 0x5465, 0x003F, 0x003F, 0x003F, 0x5466, 0x003F, 0x003F, 
  0x5467, 0x003F, 0x5468, 0x003F, 0x003F, 0x5469, 0x546A, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_7f[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x344C, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x546C, 0x546B, 0x546D, 0x546E, 0x546F, 
  0x003F, 0x003F, 0x003F, 0x5470, 0x5471, 0x003F, 0x003F, 0x5472, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5473, 
  0x003F, 0x003F, 0x5474, 0x5475, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x5476, 0x5477, 0x5478, 0x003F, 0x003F, 
  0x003F, 0x5479, 0x003F, 0x547A, 0x547B, 0x547C, 0x547D, 0x003F, 
  0x003F, 0x003F, 0x3A61, 0x3753, 0x003F, 0x547E, 0x4356, 0x003F, 
  0x4833, 0x5521, 0x3D70, 0x003F, 0x003F, 0x474D, 0x003F, 0x486D, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5522, 0x5523, 0x5524, 
  0x5525, 0x003F, 0x003F, 0x003F, 0x003F, 0x4D65, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4D53, 0x5526, 0x003F, 0x5527, 0x487E, 0x5528, 
  0x5529, 0x552A, 0x003F, 0x003F, 0x003F, 0x003F, 0x552B, 0x552C, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x552D, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x552E, 0x552F, 0x003F, 0x3732, 0x003F, 0x5530, 0x003F, 
  0x4122, 0x3541, 0x5531, 0x003F, 0x003F, 0x5532, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x5533, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x5534, 0x3129, 0x003F, 0x5535, 
  0x5536, 0x3227, 0x003F, 0x5537, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5538, 0x003F, 0x003F, 0x003F, 0x4D62, 0x003F, 0x5539, 0x553A, 
  0x003F, 0x003F, 0x3D2C, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x553B, 0x003F, 0x003F, 0x003F, 0x553C, 
  0x3F69, 0x003F, 0x003F, 0x553D, 0x003F, 0x553E, 0x003F, 0x003F, 
  0x553F, 0x003F, 0x003F, 0x3465, 0x5540, 0x003F, 0x5541, 0x5542, 
  0x344D, 0x003F, 0x5543, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x5544, 0x4B5D, 0x4D63, 0x5545, 0x5546, 0x5547
};
static const unsigned uni2jis_tbl_80[] = {
  0x4D54, 0x4F37, 0x003F, 0x394D, 0x003F, 0x3C54, 0x003F, 0x5548, 
  0x5549, 0x003F, 0x554A, 0x003F, 0x3C29, 0x554B, 0x554C, 0x554D, 
  0x4251, 0x554E, 0x003F, 0x554F, 0x5550, 0x394C, 0x5551, 0x4C57, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5552, 0x5553, 0x5554, 
  0x5555, 0x003F, 0x003F, 0x003F, 0x5556, 0x003F, 0x5557, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x5558, 0x003F, 0x5559, 0x003F, 
  0x555A, 0x003F, 0x003F, 0x3C2A, 0x555B, 0x555C, 0x4C6D, 0x555D, 
  0x003F, 0x555E, 0x555F, 0x003F, 0x5560, 0x433F, 0x5561, 0x003F, 
  0x5562, 0x003F, 0x003F, 0x003F, 0x5563, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x403B, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4A39, 0x003F, 
  0x5564, 0x416F, 0x003F, 0x003F, 0x5565, 0x003F, 0x5566, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5567, 0x003F, 0x4E7E, 
  0x003F, 0x5568, 0x003F, 0x003F, 0x4430, 0x5569, 0x003F, 0x3F26, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4F38, 0x003F, 
  0x003F, 0x556A, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4825, 
  0x556B, 0x4679, 0x003F, 0x4F3E, 0x4829, 0x003F, 0x556C, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3E53, 0x003F, 
  0x492A, 0x003F, 0x003F, 0x003F, 0x556D, 0x344E, 0x556E, 0x003F, 
  0x003F, 0x3854, 0x3B68, 0x003F, 0x003F, 0x486E, 0x556F, 0x5570, 
  0x003F, 0x382A, 0x4B43, 0x5571, 0x003F, 0x003F, 0x003F, 0x394E, 
  0x003F, 0x394F, 0x3069, 0x003F, 0x3A68, 0x003F, 0x003F, 0x003F, 
  0x5572, 0x5573, 0x4759, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x305F, 0x6674, 0x003F, 0x4340, 0x003F, 
  0x5574, 0x003F, 0x003F, 0x003F, 0x4758, 0x5575, 0x425B, 0x5576, 
  0x003F, 0x003F, 0x5577, 0x003F, 0x5578, 0x5579, 0x003F, 0x557A, 
  0x557B, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4B26, 0x003F, 
  0x557C, 0x3855, 0x003F, 0x003F, 0x307D, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x557D, 0x557E, 0x003F, 
  0x5621, 0x003F, 0x5622, 0x5623, 0x4639, 0x003F, 0x5624, 0x003F, 
  0x363B, 0x5625, 0x5626, 0x003F, 0x003F, 0x473D, 0x5627, 0x003F
};
static const unsigned uni2jis_tbl_81[] = {
  0x003F, 0x003F, 0x3B69, 0x5628, 0x003F, 0x363C, 0x4048, 0x4F46, 
  0x4C2E, 0x003F, 0x4054, 0x5629, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x562A, 0x562B, 
  0x562C, 0x003F, 0x3553, 0x003F, 0x562D, 0x003F, 0x562E, 0x003F, 
  0x562F, 0x003F, 0x003F, 0x003F, 0x5630, 0x003F, 0x003F, 0x5631, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x5632, 0x003F, 0x003F, 0x003F, 
  0x5633, 0x4326, 0x003F, 0x473E, 0x003F, 0x5634, 0x003F, 0x003F, 
  0x003F, 0x4431, 0x5635, 0x003F, 0x5636, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5637, 0x003F, 0x5638, 
  0x003F, 0x003F, 0x5639, 0x003F, 0x563A, 0x003F, 0x3F55, 0x003F, 
  0x4965, 0x003F, 0x563B, 0x003F, 0x3950, 0x4F53, 0x003F, 0x563C, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x563D, 0x563E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x563F, 
  0x5640, 0x5641, 0x003F, 0x3C70, 0x003F, 0x5642, 0x003F, 0x5643, 
  0x3978, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5644, 
  0x4432, 0x4A22, 0x4123, 0x003F, 0x003F, 0x003F, 0x003F, 0x425C, 
  0x003F, 0x5645, 0x003F, 0x003F, 0x5647, 0x5648, 0x5649, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x564A, 0x003F, 0x003F, 0x564B, 0x3951, 
  0x5646, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x564C, 0x003F, 
  0x564D, 0x003F, 0x4966, 0x564E, 0x4B6C, 0x4928, 0x564F, 0x003F, 
  0x003F, 0x003F, 0x5650, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4B44, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5651, 0x003F, 
  0x003F, 0x003F, 0x5652, 0x4137, 0x5653, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x5654, 0x003F, 0x003F, 0x003F, 0x473F, 
  0x003F, 0x003F, 0x003F, 0x5656, 0x003F, 0x5657, 0x3232, 0x003F, 
  0x003F, 0x003F, 0x5658, 0x5655, 0x003F, 0x003F, 0x5659, 0x565A, 
  0x003F, 0x003F, 0x003F, 0x4221, 0x003F, 0x565B, 0x003F, 0x565C, 
  0x003F, 0x003F, 0x003F, 0x565D, 0x003F, 0x565E, 0x565F, 0x003F, 
  0x003F, 0x5660, 0x003F, 0x3F43, 0x5661, 0x3269, 0x003F, 0x003F, 
  0x4E57, 0x003F, 0x3C2B, 0x5662, 0x5663, 0x3D2D, 0x003F, 0x003F, 
  0x5664, 0x5665, 0x5666, 0x3B6A, 0x4357, 0x5667, 0x5668, 0x003F, 
  0x5669, 0x566A, 0x003F, 0x003F, 0x3131, 0x566B, 0x003F, 0x566C
};
static const unsigned uni2jis_tbl_82[] = {
  0x566D, 0x003F, 0x003F, 0x566E, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x363D, 0x003F, 0x003F, 0x003F, 0x4065, 0x003F, 0x3C4B, 0x566F, 
  0x003F, 0x003F, 0x5030, 0x5670, 0x5671, 0x003F, 0x003F, 0x4A5E, 
  0x345C, 0x5672, 0x5673, 0x4124, 0x3D58, 0x5674, 0x4971, 0x3D2E, 
  0x003F, 0x5675, 0x5676, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3952, 0x003F, 0x484C, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x5678, 0x003F, 0x5679, 0x4249, 0x4775, 0x383F, 
  0x003F, 0x4125, 0x567A, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x567B, 0x567C, 0x567D, 0x567E, 0x447A, 
  0x003F, 0x003F, 0x003F, 0x5721, 0x003F, 0x003F, 0x5722, 0x5723, 
  0x003F, 0x5724, 0x003F, 0x003F, 0x003F, 0x003F, 0x5725, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x5726, 0x003F, 0x003F, 0x003F, 
  0x5727, 0x003F, 0x003F, 0x5728, 0x003F, 0x003F, 0x344F, 0x5729, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x572A, 0x3A31, 0x4E49, 
  0x003F, 0x003F, 0x3F27, 0x003F, 0x572B, 0x003F, 0x3170, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x572C, 0x003F, 0x572D, 0x003F, 0x572E, 
  0x572F, 0x5730, 0x003F, 0x5731, 0x5732, 0x003F, 0x003F, 0x5733, 
  0x003F, 0x5734, 0x5735, 0x3072, 0x003F, 0x003F, 0x5736, 0x003F, 
  0x003F, 0x5737, 0x003F, 0x003F, 0x5738, 0x003F, 0x5739, 0x003F, 
  0x573A, 0x4967, 0x573B, 0x573C, 0x003F, 0x3C47, 0x003F, 0x003F, 
  0x573D, 0x573E, 0x003F, 0x573F, 0x5740, 0x3329, 0x3032, 0x5741, 
  0x5742, 0x5743, 0x5744, 0x003F, 0x003F, 0x474E, 0x5745, 0x3F44, 
  0x5746, 0x3256, 0x5747, 0x4B27, 0x5748, 0x003F, 0x003F, 0x5749, 
  0x375D, 0x365C, 0x574A, 0x003F, 0x574B, 0x326A, 0x574C, 0x574D, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3423, 0x574E, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x574F, 0x3171, 0x003F, 0x4E6A, 0x425D, 0x5750, 0x003F, 0x4944, 
  0x003F, 0x003F, 0x5751, 0x3257, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5752, 0x003F, 0x5753, 0x003F, 0x5754, 0x3C63, 0x366C, 0x4377, 
  0x5755, 0x003F, 0x5756, 0x4651, 0x003F, 0x5757, 0x003F, 0x5758, 
  0x003F, 0x3151, 0x003F, 0x003F, 0x003F, 0x003F, 0x5759, 0x575A, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x575B, 0x575C, 0x003F
};
static const unsigned uni2jis_tbl_83[] = {
  0x575D, 0x575E, 0x4C50, 0x003F, 0x3258, 0x337D, 0x003F, 0x575F, 
  0x5760, 0x003F, 0x5761, 0x5762, 0x003F, 0x003F, 0x3754, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x5764, 0x302B, 0x5765, 0x5766, 0x5767, 
  0x003F, 0x5768, 0x5769, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3071, 0x003F, 0x003F, 0x003F, 0x576A, 0x576B, 0x576C, 0x003F, 
  0x576D, 0x003F, 0x003F, 0x576E, 0x003F, 0x003F, 0x4363, 0x576F, 
  0x427B, 0x003F, 0x5770, 0x003F, 0x5771, 0x5772, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x5773, 0x5774, 0x5775, 0x003F, 0x003F, 0x5776, 
  0x003F, 0x4170, 0x3755, 0x003F, 0x003F, 0x5777, 0x5778, 0x3141, 
  0x003F, 0x5779, 0x3953, 0x583E, 0x5763, 0x577A, 0x577B, 0x577C, 
  0x4171, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x577D, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3259, 
  0x577E, 0x003F, 0x003F, 0x322E, 0x003F, 0x5821, 0x003F, 0x5822, 
  0x5823, 0x003F, 0x5824, 0x003F, 0x5825, 0x003F, 0x5826, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5827, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x5828, 0x003F, 0x5829, 0x582A, 0x003F, 0x003F, 
  0x582B, 0x582C, 0x003F, 0x582D, 0x582E, 0x582F, 0x3450, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5830, 0x5831, 
  0x003F, 0x5832, 0x003F, 0x477C, 0x5833, 0x584C, 0x003F, 0x003F, 
  0x003F, 0x4D69, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5834, 0x5835, 
  0x5836, 0x003F, 0x003F, 0x003F, 0x003F, 0x3F7B, 0x003F, 0x5837, 
  0x003F, 0x5838, 0x3546, 0x003F, 0x365D, 0x003F, 0x003F, 0x5839, 
  0x583A, 0x583B, 0x003F, 0x325B, 0x583C, 0x003F, 0x3E54, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3A5A, 0x583D, 0x003F, 0x4551, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x583F, 0x4A6E, 0x5840, 0x003F, 0x003F, 0x003F, 0x003F, 0x325A, 
  0x3856, 0x4929, 0x003F, 0x003F, 0x003F, 0x003F, 0x5841, 0x003F, 
  0x5842, 0x5843, 0x003F, 0x003F, 0x5844, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_84[] = {
  0x003F, 0x5845, 0x003F, 0x003F, 0x463A, 0x003F, 0x5846, 0x003F, 
  0x003F, 0x003F, 0x5847, 0x003F, 0x4B28, 0x003F, 0x3060, 0x5848, 
  0x003F, 0x5849, 0x003F, 0x003F, 0x003F, 0x584A, 0x003F, 0x003F, 
  0x003F, 0x584B, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x476B, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x584D, 
  0x003F, 0x337E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x584E, 0x003F, 0x003F, 0x003F, 0x4D6E, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x584F, 0x003F, 0x5850, 
  0x5851, 0x4D55, 0x5852, 0x003F, 0x003F, 0x5853, 0x4E2A, 0x5854, 
  0x003F, 0x5855, 0x5856, 0x003F, 0x003F, 0x003F, 0x5857, 0x4378, 
  0x5858, 0x5859, 0x585A, 0x336B, 0x585B, 0x003F, 0x003F, 0x003F, 
  0x585C, 0x4972, 0x003F, 0x4621, 0x585D, 0x585E, 0x3031, 0x585F, 
  0x003F, 0x003F, 0x5860, 0x003F, 0x4172, 0x003F, 0x003F, 0x003F, 
  0x5861, 0x472C, 0x003F, 0x5862, 0x5863, 0x302A, 0x5864, 0x003F, 
  0x5865, 0x003F, 0x4978, 0x003F, 0x5866, 0x5867, 0x003F, 0x003F, 
  0x003F, 0x5868, 0x003F, 0x003F, 0x003F, 0x5869, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3E55, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3D2F, 0x003F, 0x586A, 0x586B, 0x3C2C, 0x586C, 0x003F, 0x003F, 
  0x003F, 0x4C58, 0x003F, 0x003F, 0x4947, 0x003F, 0x586D, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x586E, 0x003F, 
  0x586F, 0x5870, 0x5871, 0x003F, 0x003F, 0x003F, 0x003F, 0x5872, 
  0x003F, 0x5873, 0x3377, 0x003F, 0x5874, 0x003F, 0x003F, 0x003F, 
  0x3E78, 0x003F, 0x5875, 0x003F, 0x4173, 0x5876, 0x5877, 0x003F, 
  0x5878, 0x003F, 0x5879, 0x003F, 0x435F, 0x003F, 0x003F, 0x587A, 
  0x587B, 0x4D56, 0x003F, 0x3338, 0x587C, 0x003F, 0x003F, 0x587D, 
  0x003F, 0x4C2C, 0x003F, 0x587E, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x5921, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5922, 
  0x003F, 0x003F, 0x5923, 0x003F, 0x4B29, 0x003F, 0x4F21, 0x5924, 
  0x5925, 0x5926, 0x5927, 0x003F, 0x003F, 0x003F, 0x003F, 0x5928, 
  0x003F, 0x003F, 0x592A, 0x592B, 0x003F, 0x592C, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_85[] = {
  0x3C43, 0x003F, 0x592D, 0x592E, 0x003F, 0x003F, 0x003F, 0x592F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x5930, 0x003F, 0x5931, 0x003F, 
  0x5932, 0x4A4E, 0x003F, 0x4C22, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3136, 0x003F, 0x5933, 0x003F, 0x5934, 0x003F, 
  0x003F, 0x003F, 0x5935, 0x5936, 0x5937, 0x5938, 0x4455, 0x5939, 
  0x003F, 0x003F, 0x593A, 0x593B, 0x003F, 0x307E, 0x003F, 0x593C, 
  0x003F, 0x003F, 0x5929, 0x593D, 0x593E, 0x4222, 0x593F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4A43, 0x003F, 0x5940, 
  0x003F, 0x003F, 0x003F, 0x4859, 0x003F, 0x003F, 0x5941, 0x003F, 
  0x003F, 0x3E56, 0x3C49, 0x003F, 0x003F, 0x003F, 0x363E, 0x5942, 
  0x5943, 0x5944, 0x5945, 0x5946, 0x003F, 0x003F, 0x5947, 0x4979, 
  0x003F, 0x5948, 0x003F, 0x003F, 0x5949, 0x594A, 0x594B, 0x594C, 
  0x594D, 0x594E, 0x594F, 0x003F, 0x5950, 0x003F, 0x003F, 0x003F, 
  0x4F4F, 0x4622, 0x4973, 0x5951, 0x003F, 0x003F, 0x003F, 0x5952, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x5953, 0x5954, 0x5955, 0x003F, 0x5956, 0x003F, 0x5957, 
  0x003F, 0x5958, 0x003F, 0x003F, 0x4776, 0x5959, 0x595A, 0x003F, 
  0x003F, 0x595B, 0x003F, 0x595C, 0x595D, 0x003F, 0x003F, 0x595E, 
  0x003F, 0x003F, 0x003F, 0x595F, 0x003F, 0x003F, 0x003F, 0x3172, 
  0x5960, 0x4665, 0x003F, 0x003F, 0x003F, 0x5961, 0x003F, 0x5962, 
  0x5963, 0x003F, 0x5964, 0x003F, 0x003F, 0x5965, 0x4126, 0x5966, 
  0x003F, 0x3B27, 0x3F45, 0x3730, 0x4C74, 0x5974, 0x4C79, 0x3D72, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x5967, 0x003F, 0x5968, 0x5969, 
  0x596A, 0x003F, 0x003F, 0x003F, 0x596B, 0x596C, 0x596D, 0x596E, 
  0x003F, 0x4F4E, 0x596F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5970, 
  0x003F, 0x003F, 0x5971, 0x5972, 0x003F, 0x4D75, 0x5973, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5975, 0x003F, 0x5976, 0x003F, 0x003F, 0x003F, 0x003F, 0x5977, 
  0x5978, 0x003F, 0x003F, 0x003F, 0x4623, 0x003F, 0x5979, 0x003F, 
  0x597A, 0x484D, 0x003F, 0x003F, 0x003F, 0x597B, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x597C, 0x003F, 0x003F, 0x597D, 0x3D73, 
  0x003F, 0x003F, 0x003F, 0x4174, 0x597E, 0x003F, 0x003F, 0x5A21
};
static const unsigned uni2jis_tbl_86[] = {
  0x5A22, 0x003F, 0x003F, 0x003F, 0x5A23, 0x5A24, 0x003F, 0x4149, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5A25, 0x5A26, 0x003F, 
  0x5A27, 0x5A28, 0x5A29, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5A2A, 0x5A2B, 0x003F, 0x5A2C, 0x003F, 0x003F, 0x5A2D, 0x003F, 
  0x003F, 0x5A2E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5A2F, 
  0x003F, 0x5A30, 0x003F, 0x003F, 0x003F, 0x4D76, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5A31, 0x003F, 
  0x5A32, 0x003F, 0x5A33, 0x003F, 0x5A34, 0x5A35, 0x003F, 0x003F, 
  0x5A36, 0x3866, 0x5A37, 0x003F, 0x003F, 0x003F, 0x5A38, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3857, 0x003F, 
  0x3554, 0x003F, 0x5A39, 0x5A3A, 0x003F, 0x515D, 0x5A3B, 0x5A3C, 
  0x5A3D, 0x5A3E, 0x3575, 0x003F, 0x4E3A, 0x5A3F, 0x3673, 0x003F, 
  0x5A40, 0x5A41, 0x5A42, 0x5A43, 0x5A44, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x5A45, 0x003F, 0x436E, 0x5A46, 0x003F, 0x003F, 0x5A47, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5A48, 0x5A49, 0x5A4A, 
  0x003F, 0x467A, 0x5A4B, 0x303A, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5A6D, 0x003F, 0x3263, 0x003F, 0x003F, 0x5A4C, 0x003F, 0x003F, 
  0x003F, 0x5A4D, 0x003F, 0x003F, 0x003F, 0x3B3D, 0x003F, 0x003F, 
  0x5A4F, 0x003F, 0x5A50, 0x003F, 0x5A51, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x5A52, 0x003F, 0x003F, 0x4742, 0x003F, 0x5A53, 0x5A54, 
  0x5A55, 0x003F, 0x003F, 0x003F, 0x003F, 0x5A56, 0x003F, 0x003F, 
  0x003F, 0x5A57, 0x003F, 0x5A58, 0x5A59, 0x5A5A, 0x003F, 0x5A5B, 
  0x5A5C, 0x5A5D, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5A5E, 
  0x5A5F, 0x5A60, 0x003F, 0x5A61, 0x003F, 0x5A62, 0x003F, 0x3C58, 
  0x003F, 0x003F, 0x003F, 0x4341, 0x003F, 0x3756, 0x3342, 0x003F, 
  0x003F, 0x5A63, 0x5A64, 0x003F, 0x003F, 0x5A65, 0x003F, 0x5A66, 
  0x003F, 0x333F, 0x5A67, 0x003F, 0x5A68, 0x003F, 0x003F, 0x003F, 
  0x5A69, 0x003F, 0x003F, 0x5A6A, 0x483A, 0x5A6B, 0x003F, 0x5A6C, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4948, 0x485A, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x427D, 0x003F, 0x5A6E, 0x003F, 0x5A6F, 0x5A70, 0x326B, 0x003F
};
static const unsigned uni2jis_tbl_87[] = {
  0x003F, 0x003F, 0x4B2A, 0x003F, 0x5A71, 0x5A72, 0x003F, 0x5A73, 
  0x003F, 0x003F, 0x003F, 0x5A74, 0x003F, 0x003F, 0x5A75, 0x5A76, 
  0x5A77, 0x003F, 0x003F, 0x5A78, 0x5A79, 0x003F, 0x003F, 0x003F, 
  0x4358, 0x5A7A, 0x003F, 0x003F, 0x4C2A, 0x003F, 0x5A7B, 0x5A7C, 
  0x003F, 0x5A7D, 0x003F, 0x5A7E, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5B21, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5B22, 0x5B23, 
  0x003F, 0x5B24, 0x5B25, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x5B26, 0x5B27, 0x003F, 0x5B28, 0x5B29, 0x5B2A, 0x003F, 
  0x5B2B, 0x003F, 0x003F, 0x5B2C, 0x003F, 0x5B2D, 0x003F, 0x003F, 
  0x003F, 0x4066, 0x003F, 0x4F39, 0x003F, 0x5B2E, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3F2A, 0x003F, 0x003F, 
  0x5B2F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5B30, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x5B32, 0x5B33, 0x325C, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5B34, 
  0x003F, 0x5B35, 0x5B36, 0x003F, 0x003F, 0x003F, 0x4433, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x5B37, 0x003F, 0x003F, 0x003F, 0x4768, 
  0x003F, 0x003F, 0x003F, 0x5B38, 0x5B39, 0x5B3A, 0x5B3B, 0x5B3C, 
  0x5B3D, 0x5B3E, 0x003F, 0x5B3F, 0x5B40, 0x4D3B, 0x003F, 0x003F, 
  0x5B41, 0x003F, 0x003F, 0x5B42, 0x003F, 0x5B43, 0x003F, 0x5B44, 
  0x5B45, 0x5B46, 0x003F, 0x003F, 0x003F, 0x003F, 0x5B47, 0x003F, 
  0x5B48, 0x003F, 0x003F, 0x5B49, 0x003F, 0x003F, 0x003F, 0x5B4A, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x5B4B, 0x5B4C, 0x5B4D, 0x003F, 
  0x003F, 0x5B4E, 0x003F, 0x003F, 0x003F, 0x5B4F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x4D66, 0x003F, 0x003F, 0x003F, 0x5B50, 0x5B51, 
  0x003F, 0x5B52, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5B53, 0x5B54, 0x5B55, 0x003F, 0x003F, 0x003F, 0x5B56, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5B57, 0x5B58, 0x003F, 
  0x003F, 0x5B59, 0x5B5A, 0x003F, 0x5B5B, 0x003F, 0x003F, 0x5B5C, 
  0x003F, 0x003F, 0x5B5D, 0x5B5E, 0x5B5F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x5B60, 0x5B61, 0x003F, 0x5B62, 0x003F, 0x003F, 
  0x003F, 0x5B63, 0x003F, 0x5B64, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5B65, 0x332A, 0x5B66, 0x3542, 0x003F, 0x003F, 0x003F, 0x5B67
};
static const unsigned uni2jis_tbl_88[] = {
  0x003F, 0x5B68, 0x003F, 0x5B69, 0x003F, 0x003F, 0x5B6A, 0x003F, 
  0x003F, 0x5B6B, 0x5B6C, 0x5B6D, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5B6E, 0x003F, 0x5B70, 0x5B71, 0x5B72, 0x003F, 0x003F, 0x003F, 
  0x5B73, 0x5B6F, 0x5B74, 0x5B75, 0x5B76, 0x003F, 0x5B77, 0x5B78, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5B79, 0x003F, 0x003F, 0x003F, 0x003F, 0x5B7A, 0x5B7B, 0x003F, 
  0x5B7C, 0x003F, 0x5B7D, 0x003F, 0x003F, 0x5B7E, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x5C21, 0x003F, 0x5C22, 0x003F, 0x003F, 0x003F, 
  0x376C, 0x5C23, 0x003F, 0x5C24, 0x003F, 0x5C25, 0x3D30, 0x003F, 
  0x5C26, 0x5C27, 0x5C28, 0x5C29, 0x3954, 0x003F, 0x5C2A, 0x003F, 
  0x003F, 0x5C2B, 0x003F, 0x3D51, 0x003F, 0x5C2C, 0x5C2D, 0x3339, 
  0x5C2E, 0x003F, 0x5C2F, 0x3152, 0x5C30, 0x3E57, 0x003F, 0x5C31, 
  0x5C32, 0x3955, 0x003F, 0x3061, 0x5C33, 0x003F, 0x003F, 0x003F, 
  0x493D, 0x5C34, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3F6A, 0x5C35, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x436F, 
  0x003F, 0x5C36, 0x003F, 0x5C37, 0x003F, 0x003F, 0x003F, 0x365E, 
  0x5C38, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3736, 0x003F, 0x003F, 0x425E, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4235, 0x003F, 
  0x5C39, 0x003F, 0x5C3A, 0x5C3B, 0x5C3C, 0x003F, 0x003F, 0x5C3D, 
  0x5C3E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5C3F, 0x003F, 0x5C40, 0x486F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3853, 0x003F, 0x003F, 0x3041, 
  0x003F, 0x003F, 0x5C41, 0x003F, 0x003F, 0x5C42, 0x5C43, 0x003F, 
  0x5C44, 0x3A5B, 0x4E76, 0x003F, 0x003F, 0x4175, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x5C45, 0x5C46, 0x5C47, 0x5C48, 0x5C49, 0x4E22, 
  0x003F, 0x5C4A, 0x5C4B, 0x5C4C, 0x003F, 0x4D35, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x5C4D, 0x4A64, 0x003F, 0x5C4E, 0x3A40, 
  0x003F, 0x4E23, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5C4F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5C50, 
  0x5C51, 0x5C52, 0x003F, 0x3E58, 0x003F, 0x5C53, 0x003F, 0x5C54, 
  0x4D67, 0x003F, 0x003F, 0x003F, 0x003F, 0x403D, 0x3F7E, 0x003F
};
static const unsigned uni2jis_tbl_89[] = {
  0x003F, 0x5C55, 0x003F, 0x003F, 0x003F, 0x003F, 0x5C56, 0x4A23, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5C57, 0x5C58, 0x5C59, 
  0x336C, 0x003F, 0x4B2B, 0x003F, 0x003F, 0x5C5A, 0x5C5B, 0x003F, 
  0x5C5C, 0x5C5D, 0x5C5E, 0x003F, 0x5C5F, 0x003F, 0x003F, 0x003F, 
  0x5C60, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5C61, 0x5C62, 
  0x5C63, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5C64, 0x5C65, 0x5C66, 0x003F, 0x003F, 0x5C67, 0x003F, 0x003F, 
  0x003F, 0x5C68, 0x5C69, 0x003F, 0x003F, 0x003F, 0x5C6A, 0x003F, 
  0x5C6B, 0x003F, 0x5C6C, 0x003F, 0x003F, 0x5C6D, 0x5C6E, 0x003F, 
  0x003F, 0x5C6F, 0x003F, 0x003F, 0x003F, 0x7037, 0x003F, 0x5C70, 
  0x003F, 0x003F, 0x5C71, 0x003F, 0x003F, 0x003F, 0x3228, 0x5C72, 
  0x003F, 0x003F, 0x5C73, 0x5C74, 0x5C75, 0x003F, 0x003F, 0x365F, 
  0x003F, 0x5C76, 0x5C77, 0x5C78, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x5C79, 0x003F, 0x003F, 0x5C7A, 0x003F, 
  0x5C7B, 0x003F, 0x3D31, 0x5C7C, 0x003F, 0x5C7D, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x5C7E, 0x5D21, 0x5D22, 0x5D23, 0x003F, 0x403E, 
  0x003F, 0x4D57, 0x003F, 0x003F, 0x003F, 0x003F, 0x4A24, 0x4746, 
  0x003F, 0x5D24, 0x003F, 0x382B, 0x003F, 0x5D25, 0x003F, 0x352C, 
  0x5D26, 0x003F, 0x003F, 0x003F, 0x5D27, 0x5D28, 0x3B6B, 0x4741, 
  0x003F, 0x003F, 0x3350, 0x5D29, 0x5D2A, 0x003F, 0x003F, 0x5D2B, 
  0x5D2C, 0x003F, 0x003F, 0x003F, 0x003F, 0x5D2D, 0x003F, 0x4D77, 
  0x003F, 0x003F, 0x3F46, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5D2E, 0x003F, 0x003F, 0x3451, 0x5D2F, 0x5D30, 0x5D31, 0x5D32, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x5D33, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x3351, 0x003F, 0x5D34, 0x003F, 0x5D36, 0x5D37, 
  0x5D38, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3272, 0x003F, 0x5D39, 0x3F28, 0x003F, 
  0x003F, 0x5D3A, 0x003F, 0x003F, 0x003F, 0x5D3C, 0x003F, 0x003F, 
  0x003F, 0x5D3D, 0x003F, 0x5D3E, 0x003F, 0x003F, 0x5D3F, 0x003F, 
  0x003F, 0x5D40, 0x003F, 0x003F, 0x003F, 0x5D41, 0x003F, 0x5D42
};
static const unsigned uni2jis_tbl_8a[] = {
  0x3840, 0x003F, 0x447B, 0x003F, 0x5D43, 0x5D44, 0x003F, 0x5D45, 
  0x3757, 0x003F, 0x3F56, 0x003F, 0x003F, 0x003F, 0x4624, 0x5D46, 
  0x003F, 0x5D47, 0x5D48, 0x3731, 0x5D49, 0x5D4A, 0x003F, 0x4277, 
  0x352D, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5D4B, 0x3E59, 
  0x5D4C, 0x003F, 0x5D4D, 0x376D, 0x5D4E, 0x003F, 0x5D4F, 0x003F, 
  0x003F, 0x003F, 0x4B2C, 0x5D50, 0x5D51, 0x405F, 0x003F, 0x5D52, 
  0x003F, 0x3576, 0x003F, 0x4C75, 0x414A, 0x5D53, 0x003F, 0x5D54, 
  0x003F, 0x003F, 0x3F47, 0x4370, 0x3E5A, 0x5D55, 0x5D56, 0x003F, 
  0x5D57, 0x003F, 0x003F, 0x5D58, 0x003F, 0x5D59, 0x003F, 0x5D5A, 
  0x003F, 0x5D5B, 0x003F, 0x003F, 0x003F, 0x5D5C, 0x5D5D, 0x003F, 
  0x3A3E, 0x4242, 0x003F, 0x5D5E, 0x3E5B, 0x493E, 0x5D5F, 0x003F, 
  0x5D61, 0x003F, 0x003F, 0x003F, 0x5D62, 0x5D63, 0x3B6C, 0x003F, 
  0x3153, 0x5D64, 0x003F, 0x3758, 0x003F, 0x5D65, 0x3B6E, 0x5D66, 
  0x003F, 0x3B6D, 0x003F, 0x4F4D, 0x003F, 0x003F, 0x4127, 0x003F, 
  0x354D, 0x4F43, 0x333A, 0x3E5C, 0x003F, 0x5D67, 0x5D68, 0x5D69, 
  0x003F, 0x5D6A, 0x5D6B, 0x5D6C, 0x003F, 0x003F, 0x5D6D, 0x5D6E, 
  0x5D6F, 0x003F, 0x003F, 0x5D70, 0x003F, 0x003F, 0x5D71, 0x3858, 
  0x003F, 0x4D40, 0x003F, 0x5D72, 0x3B6F, 0x4727, 0x003F, 0x5D73, 
  0x5D74, 0x003F, 0x5D75, 0x4040, 0x003F, 0x4342, 0x5D76, 0x5D77, 
  0x4D36, 0x5D78, 0x003F, 0x003F, 0x003F, 0x003F, 0x386C, 0x5D79, 
  0x403F, 0x003F, 0x003F, 0x003F, 0x386D, 0x003F, 0x003F, 0x5D7A, 
  0x003F, 0x5D7B, 0x003F, 0x003F, 0x4062, 0x4649, 0x5D7C, 0x5D7D, 
  0x432F, 0x003F, 0x325D, 0x5D7E, 0x003F, 0x003F, 0x5E21, 0x5E22, 
  0x003F, 0x4870, 0x003F, 0x5E23, 0x3543, 0x003F, 0x5E24, 0x4434, 
  0x003F, 0x003F, 0x003F, 0x5E25, 0x003F, 0x003F, 0x5E26, 0x434C, 
  0x5E27, 0x5E28, 0x5E29, 0x4041, 0x3452, 0x003F, 0x003F, 0x3F5B, 
  0x003F, 0x5E2A, 0x4E4A, 0x5E2B, 0x5E2C, 0x5E2D, 0x4F40, 0x5E2E, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4435, 0x5E2F, 0x003F, 0x5E30, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x447C, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x5E31, 0x4D21, 0x3B70, 0x003F, 
  0x5E32, 0x003F, 0x003F, 0x003F, 0x5E33, 0x5E34, 0x5E35, 0x003F, 
  0x3D74, 0x003F, 0x3841, 0x003F, 0x5E36, 0x003F, 0x427A, 0x5E37
};
static const unsigned uni2jis_tbl_8b[] = {
  0x4B45, 0x315A, 0x3062, 0x003F, 0x4625, 0x5E38, 0x5E39, 0x003F, 
  0x003F, 0x003F, 0x5E3F, 0x5E3A, 0x003F, 0x003F, 0x4666, 0x003F, 
  0x003F, 0x5E3B, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x382C, 0x003F, 0x3956, 0x5E3C, 0x3C55, 0x5E3D, 0x5E3E, 
  0x003F, 0x4D58, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4935, 0x5E40, 0x003F, 0x003F, 
  0x5E41, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5E42, 
  0x003F, 0x3660, 0x003F, 0x003F, 0x5E43, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x5E44, 0x5E45, 0x5E46, 0x5E47, 0x5E48, 0x003F, 
  0x5E49, 0x003F, 0x003F, 0x003F, 0x003F, 0x5E4E, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x5E4A, 0x5E4B, 0x5E4C, 0x003F, 0x003F, 0x003F, 
  0x3C31, 0x5E4D, 0x003F, 0x003F, 0x4968, 0x003F, 0x5E4F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x5E50, 0x003F, 0x003F, 0x3759, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5E51, 0x003F, 0x003F, 
  0x3544, 0x003F, 0x3E79, 0x003F, 0x003F, 0x003F, 0x5E52, 0x386E, 
  0x5E53, 0x5E54, 0x003F, 0x003F, 0x5E55, 0x003F, 0x5E56, 0x003F, 
  0x003F, 0x5E57, 0x003F, 0x3B3E, 0x5E58, 0x5E59, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x5A4E, 0x5E5A, 0x003F, 0x5E5B, 0x003F, 0x5E5C, 
  0x3D32, 0x003F, 0x003F, 0x003F, 0x5E5D, 0x5E5E, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x5E5F, 0x003F, 0x5E60, 0x5E61, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_8c[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x432B, 
  0x5E62, 0x5E63, 0x003F, 0x003F, 0x003F, 0x5E64, 0x5E65, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5E66, 0x4626, 0x5E67, 
  0x003F, 0x5E68, 0x4B2D, 0x5E69, 0x003F, 0x003F, 0x003F, 0x5E6A, 
  0x003F, 0x5E6B, 0x003F, 0x5E6C, 0x5E6D, 0x003F, 0x003F, 0x5E6E, 
  0x5E6F, 0x5E72, 0x465A, 0x5E70, 0x003F, 0x5E71, 0x003F, 0x003F, 
  0x003F, 0x3E5D, 0x003F, 0x5E73, 0x5E74, 0x003F, 0x5E75, 0x003F, 
  0x5E76, 0x5E77, 0x396B, 0x502E, 0x003F, 0x5E78, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x5E79, 0x003F, 0x5E7A, 0x5E7B, 0x003F, 
  0x003F, 0x493F, 0x003F, 0x5E7C, 0x003F, 0x003F, 0x5E7D, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5E7E, 0x5F21, 
  0x003F, 0x003F, 0x003F, 0x5F22, 0x4B46, 0x003F, 0x003F, 0x003F, 
  0x5F23, 0x003F, 0x5F24, 0x5F25, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x5F26, 0x003F, 0x5F27, 0x5F28, 0x332D, 0x4467, 0x003F, 
  0x4969, 0x3A62, 0x3957, 0x003F, 0x5F29, 0x003F, 0x003F, 0x494F, 
  0x325F, 0x484E, 0x003F, 0x3453, 0x4055, 0x003F, 0x003F, 0x4379, 
  0x4C63, 0x003F, 0x003F, 0x003F, 0x352E, 0x003F, 0x003F, 0x4763, 
  0x425F, 0x5F2A, 0x5F2B, 0x4871, 0x453D, 0x003F, 0x003F, 0x4B47, 
  0x326C, 0x003F, 0x4F28, 0x4442, 0x4F45, 0x5F2C, 0x5F2D, 0x3B71, 
  0x003F, 0x5F2E, 0x4231, 0x5F2F, 0x003F, 0x003F, 0x4128, 0x5F30, 
  0x003F, 0x4678, 0x003F, 0x4950, 0x003F, 0x5F32, 0x5F31, 0x003F, 
  0x003F, 0x5F33, 0x003F, 0x3B3F, 0x3B72, 0x5F34, 0x3E5E, 0x003F, 
  0x4765, 0x5F35, 0x382D, 0x003F, 0x003F, 0x003F, 0x496A, 0x003F, 
  0x5F36, 0x003F, 0x3C41, 0x003F, 0x5F37, 0x4552, 0x003F, 0x5F38, 
  0x5F39, 0x003F, 0x5F3A, 0x003F, 0x003F, 0x5F3B, 0x003F, 0x5F3C, 
  0x5F3D, 0x003F, 0x003F, 0x003F, 0x3958, 0x003F, 0x5F3E, 0x5F3F
};
static const unsigned uni2jis_tbl_8d[] = {
  0x003F, 0x5F40, 0x003F, 0x5F41, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4223, 0x5F42, 0x003F, 0x3466, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x5F43, 0x003F, 0x003F, 0x003F, 0x003F, 0x5F44, 
  0x003F, 0x003F, 0x003F, 0x5F45, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x4056, 0x5F46, 0x3C4F, 0x003F, 
  0x003F, 0x5F47, 0x003F, 0x3352, 0x5F48, 0x003F, 0x5F49, 0x003F, 
  0x4176, 0x003F, 0x003F, 0x003F, 0x496B, 0x003F, 0x003F, 0x352F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5F4A, 
  0x003F, 0x003F, 0x5F4B, 0x003F, 0x5F4C, 0x4436, 0x003F, 0x003F, 
  0x5F4D, 0x003F, 0x315B, 0x003F, 0x003F, 0x5F4E, 0x003F, 0x003F, 
  0x5F4F, 0x5F50, 0x003F, 0x003F, 0x003F, 0x5F51, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5F52, 0x5F53, 
  0x5F54, 0x003F, 0x003F, 0x3C71, 0x003F, 0x003F, 0x5F55, 0x003F, 
  0x3F76, 0x003F, 0x003F, 0x5F56, 0x5F57, 0x003F, 0x003F, 0x5F58, 
  0x003F, 0x003F, 0x5F59, 0x422D, 0x003F, 0x5F5A, 0x003F, 0x5F5B, 
  0x003F, 0x5F5C, 0x003F, 0x5F5D, 0x5F6F, 0x003F, 0x003F, 0x003F, 
  0x5F5E, 0x003F, 0x003F, 0x003F, 0x003F, 0x5F5F, 0x5F60, 0x5F61, 
  0x5F62, 0x003F, 0x5F63, 0x003F, 0x003F, 0x003F, 0x5F64, 0x003F, 
  0x003F, 0x5F65, 0x003F, 0x003F, 0x5F66, 0x5F67, 0x003F, 0x5F68, 
  0x003F, 0x5F69, 0x003F, 0x003F, 0x003F, 0x3577, 0x003F, 0x003F, 
  0x003F, 0x4057, 0x003F, 0x003F, 0x5F6A, 0x5F6B, 0x003F, 0x5F6C, 
  0x3859, 0x003F, 0x003F, 0x003F, 0x5F6D, 0x003F, 0x003F, 0x4F29, 
  0x5F6E, 0x5F70, 0x5F71, 0x4437, 0x5F72, 0x4129, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x5F73, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_8e[] = {
  0x003F, 0x5F74, 0x003F, 0x003F, 0x5F75, 0x5F76, 0x5F77, 0x003F, 
  0x003F, 0x003F, 0x4D59, 0x5F78, 0x003F, 0x003F, 0x003F, 0x4627, 
  0x003F, 0x5F79, 0x003F, 0x003F, 0x5F7A, 0x003F, 0x5F7B, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5F7C, 0x5F7D, 0x5F7E, 0x6021, 0x003F, 0x003F, 0x6022, 0x6023, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x6024, 0x003F, 0x6025, 0x003F, 0x003F, 0x6026, 0x6027, 
  0x6028, 0x6029, 0x003F, 0x003F, 0x003F, 0x602A, 0x003F, 0x003F, 
  0x602B, 0x602C, 0x003F, 0x003F, 0x447D, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x602D, 0x003F, 0x602E, 0x602F, 0x6030, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x6031, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x6032, 0x6033, 0x6034, 0x6035, 0x4058, 
  0x003F, 0x6036, 0x6037, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x6038, 0x003F, 0x003F, 0x6039, 0x603A, 0x003F, 0x603B, 
  0x603C, 0x603D, 0x003F, 0x003F, 0x3D33, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x603E, 0x603F, 0x6040, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x6041, 0x6042, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x6043, 0x003F, 0x003F, 0x003F, 0x4C76, 0x003F, 0x003F, 
  0x6044, 0x003F, 0x6045, 0x003F, 0x003F, 0x6046, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x6047, 0x6048, 0x003F, 0x6049, 0x604A, 0x003F, 
  0x003F, 0x003F, 0x604B, 0x003F, 0x003F, 0x003F, 0x003F, 0x604C, 
  0x003F, 0x604D, 0x003F, 0x3F48, 0x003F, 0x604E, 0x604F, 0x366D, 
  0x003F, 0x003F, 0x003F, 0x6050, 0x003F, 0x6051, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x6052, 0x6053, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x6055, 0x003F, 0x6056, 0x6057, 0x003F, 0x003F, 0x6058, 
  0x003F, 0x003F, 0x3C56, 0x003F, 0x3530, 0x3733, 0x003F, 0x6059, 
  0x003F, 0x605A, 0x382E, 0x003F, 0x605B, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x605C, 0x003F, 0x003F, 0x4670, 
  0x003F, 0x003F, 0x453E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x605D, 0x003F, 0x003F, 0x003F, 0x003F, 0x6064, 0x605E, 0x003F, 
  0x605F, 0x6060, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x6061, 
  0x3C34, 0x6062, 0x6063, 0x003F, 0x003F, 0x375A, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_8f[] = {
  0x6065, 0x003F, 0x6066, 0x3353, 0x003F, 0x003F, 0x003F, 0x6067, 
  0x6068, 0x3A5C, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x6069, 
  0x606A, 0x003F, 0x003F, 0x003F, 0x4A65, 0x003F, 0x606B, 0x606C, 
  0x606D, 0x003F, 0x003F, 0x003F, 0x003F, 0x3531, 0x606E, 0x003F, 
  0x606F, 0x6070, 0x003F, 0x6071, 0x003F, 0x6072, 0x003F, 0x6073, 
  0x6074, 0x475A, 0x4E58, 0x003F, 0x6075, 0x6076, 0x6077, 0x3D34, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x6078, 0x6079, 0x607A, 0x607B, 
  0x4D22, 0x003F, 0x607C, 0x003F, 0x003F, 0x003F, 0x003F, 0x4D41, 
  0x607D, 0x607E, 0x003F, 0x6121, 0x336D, 0x003F, 0x003F, 0x6122, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4532, 0x003F, 0x6123, 
  0x003F, 0x6124, 0x6125, 0x6126, 0x6127, 0x6128, 0x003F, 0x003F, 
  0x6129, 0x003F, 0x003F, 0x003F, 0x003F, 0x612A, 0x612B, 0x396C, 
  0x003F, 0x3725, 0x003F, 0x003F, 0x003F, 0x612C, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x3F49, 0x003F, 0x612D, 0x3C2D, 0x6D64, 
  0x612E, 0x612F, 0x003F, 0x6D65, 0x6130, 0x6131, 0x6132, 0x5221, 
  0x517E, 0x003F, 0x003F, 0x003F, 0x003F, 0x6D66, 0x003F, 0x6D67, 
  0x4324, 0x3F2B, 0x4740, 0x003F, 0x003F, 0x6133, 0x6134, 0x6D68, 
  0x6135, 0x003F, 0x4A55, 0x4454, 0x397E, 0x003F, 0x6136, 0x4329, 
  0x6137, 0x6138, 0x312A, 0x003F, 0x4B78, 0x3F57, 0x6139, 0x003F, 
  0x003F, 0x003F, 0x613A, 0x613B, 0x003F, 0x613C, 0x375E, 0x003F, 
  0x613D, 0x3661, 0x613E, 0x613F, 0x4A56, 0x6140, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x6D69, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x6141, 0x003F, 0x6D6B, 0x6142, 0x6143, 0x6D6A, 0x3260, 0x003F, 
  0x6144, 0x4676, 0x6D6C, 0x4777, 0x003F, 0x4533, 0x6145, 0x6D6D, 
  0x3D52, 0x6146, 0x003F, 0x003F, 0x6D6F, 0x6147, 0x6148, 0x4C42, 
  0x6D7E, 0x6D71, 0x6D72, 0x6149, 0x003F, 0x4449, 0x614A, 0x003F
};
static const unsigned uni2jis_tbl_90[] = {
  0x4260, 0x4177, 0x614B, 0x4628, 0x614C, 0x6D70, 0x3555, 0x003F, 
  0x614D, 0x003F, 0x003F, 0x6D79, 0x614E, 0x6D76, 0x6E25, 0x4629, 
  0x4360, 0x6D73, 0x003F, 0x447E, 0x4553, 0x6D74, 0x6D78, 0x3F60, 
  0x614F, 0x4767, 0x444C, 0x6150, 0x003F, 0x4042, 0x6D77, 0x422E, 
  0x4224, 0x6D75, 0x3029, 0x4F22, 0x003F, 0x003F, 0x003F, 0x6D7A, 
  0x6151, 0x6152, 0x6154, 0x003F, 0x6155, 0x6156, 0x4261, 0x6153, 
  0x003F, 0x3D35, 0x3F4A, 0x6157, 0x6158, 0x6D7C, 0x6D7B, 0x6159, 
  0x306F, 0x6D7D, 0x003F, 0x003F, 0x492F, 0x003F, 0x6E27, 0x615A, 
  0x003F, 0x465B, 0x3F6B, 0x615B, 0x615C, 0x4359, 0x003F, 0x3678, 
  0x003F, 0x6E26, 0x4D37, 0x313F, 0x615D, 0x4A57, 0x3261, 0x6E21, 
  0x6E22, 0x6E23, 0x6E24, 0x463B, 0x4323, 0x3063, 0x6E28, 0x003F, 
  0x6E29, 0x7423, 0x003F, 0x615E, 0x423D, 0x615F, 0x6E2A, 0x003F, 
  0x3173, 0x414C, 0x6160, 0x382F, 0x003F, 0x4D5A, 0x6161, 0x6162, 
  0x6E2B, 0x452C, 0x003F, 0x003F, 0x6163, 0x4178, 0x3C57, 0x6E2C, 
  0x6164, 0x003F, 0x6E2F, 0x003F, 0x6165, 0x3D65, 0x6E2D, 0x412B, 
  0x412A, 0x6166, 0x3064, 0x003F, 0x4E4B, 0x6E31, 0x003F, 0x4872, 
  0x6E33, 0x6E32, 0x6E30, 0x003F, 0x3454, 0x6167, 0x003F, 0x6D6E, 
  0x6168, 0x6E35, 0x6E34, 0x6169, 0x616A, 0x003F, 0x616B, 0x6E36, 
  0x616C, 0x4D38, 0x003F, 0x003F, 0x003F, 0x616D, 0x003F, 0x616E, 
  0x616F, 0x6170, 0x003F, 0x6171, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x6172, 0x6173, 0x6174, 0x4661, 0x003F, 0x6175, 0x4B2E, 0x003F, 
  0x6E37, 0x003F, 0x3C59, 0x003F, 0x003F, 0x003F, 0x003F, 0x6E38, 
  0x6176, 0x6E39, 0x6177, 0x6178, 0x6179, 0x6E3A, 0x617A, 0x003F, 
  0x4521, 0x003F, 0x003F, 0x003F, 0x003F, 0x617B, 0x617D, 0x003F, 
  0x003F, 0x306A, 0x003F, 0x617E, 0x6221, 0x6222, 0x003F, 0x6223, 
  0x6224, 0x003F, 0x3959, 0x003F, 0x617C, 0x003F, 0x4F3A, 0x003F, 
  0x003F, 0x003F, 0x622D, 0x003F, 0x003F, 0x6225, 0x003F, 0x6226, 
  0x6227, 0x6228, 0x003F, 0x6E3E, 0x6229, 0x622A, 0x003F, 0x622B, 
  0x003F, 0x3734, 0x6E3B, 0x003F, 0x6E3C, 0x622C, 0x003F, 0x003F, 
  0x4974, 0x003F, 0x003F, 0x622F, 0x003F, 0x3354, 0x003F, 0x6230, 
  0x6231, 0x003F, 0x003F, 0x003F, 0x6232, 0x4D39, 0x622E, 0x363F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4554, 0x6233, 0x6234
};
static const unsigned uni2jis_tbl_91[] = {
  0x6235, 0x003F, 0x6E3F, 0x003F, 0x6236, 0x6237, 0x6238, 0x003F, 
  0x6239, 0x003F, 0x003F, 0x003F, 0x003F, 0x623A, 0x003F, 0x003F, 
  0x623B, 0x003F, 0x6E40, 0x003F, 0x623C, 0x003F, 0x623D, 0x623E, 
  0x623F, 0x6E41, 0x6240, 0x003F, 0x6241, 0x003F, 0x6242, 0x003F, 
  0x6243, 0x003F, 0x6245, 0x6246, 0x003F, 0x6244, 0x003F, 0x6247, 
  0x003F, 0x6248, 0x003F, 0x003F, 0x003F, 0x4522, 0x6249, 0x624A, 
  0x6E43, 0x624B, 0x6E42, 0x003F, 0x624C, 0x003F, 0x624D, 0x624E, 
  0x003F, 0x624F, 0x6250, 0x003F, 0x6251, 0x6252, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x6253, 0x003F, 0x003F, 0x003F, 0x6254, 
  0x6255, 0x4653, 0x6E44, 0x3D36, 0x3C60, 0x475B, 0x4371, 0x6256, 
  0x003F, 0x003F, 0x3C72, 0x6257, 0x3F6C, 0x003F, 0x6E45, 0x6258, 
  0x6E46, 0x6259, 0x625A, 0x625B, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x625C, 0x3F5D, 0x6E47, 0x625D, 0x6E48, 0x003F, 0x625E, 
  0x003F, 0x6E49, 0x4D6F, 0x003F, 0x3D37, 0x625F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x6E4B, 0x6E4A, 0x6260, 0x395A, 0x003F, 0x3973, 
  0x3B40, 0x6261, 0x6262, 0x6263, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x6264, 0x6E4E, 0x6265, 0x003F, 0x6266, 0x6267, 0x3D66, 
  0x003F, 0x6E4D, 0x6268, 0x6E4C, 0x003F, 0x4269, 0x6269, 0x003F, 
  0x386F, 0x626A, 0x4043, 0x626B, 0x626C, 0x626D, 0x003F, 0x4830, 
  0x626E, 0x003F, 0x003F, 0x003F, 0x3D39, 0x003F, 0x626F, 0x003F, 
  0x003F, 0x6270, 0x6E4F, 0x003F, 0x3E5F, 0x003F, 0x6271, 0x003F, 
  0x6272, 0x003F, 0x6E52, 0x6E50, 0x6273, 0x6274, 0x6275, 0x6E51, 
  0x6276, 0x6277, 0x6278, 0x6279, 0x6E54, 0x6E53, 0x627A, 0x003F, 
  0x3E7A, 0x003F, 0x6E55, 0x627B, 0x627C, 0x627D, 0x003F, 0x627E, 
  0x6E56, 0x6E57, 0x6321, 0x6322, 0x003F, 0x6323, 0x4850, 0x3A53, 
  0x3C61, 0x6E58, 0x003F, 0x6E59, 0x4E24, 0x3D45, 0x4C6E, 0x4E4C, 
  0x6E5A, 0x3662, 0x003F, 0x6324, 0x6325, 0x003F, 0x6E5B, 0x6326, 
  0x4523, 0x6327, 0x6328, 0x6E5E, 0x3378, 0x3F4B, 0x6329, 0x6E5C, 
  0x003F, 0x6E5D, 0x003F, 0x4460, 0x632A, 0x632B, 0x4B55, 0x367C, 
  0x003F, 0x632C, 0x632D, 0x003F, 0x632E, 0x632F, 0x6330, 0x6331, 
  0x6332, 0x6333, 0x003F, 0x003F, 0x003F, 0x6E60, 0x6E61, 0x6334, 
  0x003F, 0x6335, 0x003F, 0x6336, 0x6E5F, 0x003F, 0x003F, 0x6E63
};
static const unsigned uni2jis_tbl_92[] = {
  0x6338, 0x6339, 0x003F, 0x003F, 0x633A, 0x633B, 0x633C, 0x633D, 
  0x003F, 0x633E, 0x633F, 0x003F, 0x6340, 0x465F, 0x3343, 0x003F, 
  0x6341, 0x6E67, 0x6342, 0x6343, 0x6E64, 0x6E66, 0x6344, 0x003F, 
  0x6345, 0x003F, 0x003F, 0x003F, 0x6346, 0x6347, 0x6E62, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x6348, 0x6349, 0x634A, 0x634B, 0x003F, 
  0x634C, 0x6F4F, 0x003F, 0x003F, 0x6E65, 0x003F, 0x634D, 0x634E, 
  0x634F, 0x003F, 0x003F, 0x6350, 0x4E6B, 0x6351, 0x6352, 0x385A, 
  0x6353, 0x003F, 0x6355, 0x003F, 0x6356, 0x003F, 0x6357, 0x6E6F, 
  0x6358, 0x003F, 0x6359, 0x635A, 0x4534, 0x6E6A, 0x635B, 0x635C, 
  0x6E6D, 0x6E6B, 0x635D, 0x6E70, 0x003F, 0x635E, 0x635F, 0x6360, 
  0x6E71, 0x6361, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x6E69, 
  0x6362, 0x6363, 0x6E76, 0x3174, 0x6364, 0x6365, 0x6E68, 0x003F, 
  0x6366, 0x6367, 0x482D, 0x003F, 0x6E6C, 0x6368, 0x3E60, 0x6369, 
  0x636A, 0x636B, 0x003F, 0x003F, 0x003F, 0x003F, 0x636C, 0x636D, 
  0x636E, 0x395B, 0x003F, 0x003F, 0x003F, 0x636F, 0x6370, 0x6371, 
  0x6372, 0x6373, 0x003F, 0x6374, 0x6375, 0x6376, 0x4B48, 0x6377, 
  0x3664, 0x003F, 0x003F, 0x3D46, 0x003F, 0x463C, 0x003F, 0x003F, 
  0x6378, 0x6379, 0x637A, 0x003F, 0x003F, 0x637B, 0x637C, 0x003F, 
  0x003F, 0x412D, 0x637D, 0x6E74, 0x003F, 0x6E6E, 0x6E73, 0x637E, 
  0x4C43, 0x6421, 0x4438, 0x6E75, 0x6E72, 0x003F, 0x003F, 0x6422, 
  0x6423, 0x003F, 0x003F, 0x003F, 0x6424, 0x6425, 0x003F, 0x6426, 
  0x6427, 0x003F, 0x003F, 0x6428, 0x003F, 0x412C, 0x003F, 0x6429, 
  0x003F, 0x003F, 0x642A, 0x003F, 0x003F, 0x003F, 0x642B, 0x6E79, 
  0x642C, 0x6E78, 0x642D, 0x642E, 0x642F, 0x6430, 0x003F, 0x6431, 
  0x6432, 0x6433, 0x6434, 0x6435, 0x003F, 0x6436, 0x6437, 0x6438, 
  0x6439, 0x003F, 0x003F, 0x643A, 0x643B, 0x643C, 0x643D, 0x6E77, 
  0x643E, 0x003F, 0x4B2F, 0x643F, 0x003F, 0x6440, 0x003F, 0x6441, 
  0x6442, 0x6443, 0x003F, 0x003F, 0x6444, 0x6445, 0x003F, 0x6446, 
  0x6447, 0x6448, 0x003F, 0x6449, 0x3D7B, 0x644A, 0x003F, 0x644B, 
  0x644C, 0x6E7A, 0x4A5F, 0x003F, 0x644D, 0x3154, 0x644E, 0x003F, 
  0x644F, 0x003F, 0x4946, 0x4372, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x3578, 0x6450, 0x6E7C, 0x6451, 0x395D, 0x003F, 0x003F, 0x6452
};
static const unsigned uni2jis_tbl_93[] = {
  0x6453, 0x003F, 0x6454, 0x003F, 0x003F, 0x003F, 0x3B2C, 0x003F, 
  0x6455, 0x003F, 0x003F, 0x003F, 0x003F, 0x6456, 0x003F, 0x6E7B, 
  0x3F6D, 0x6457, 0x003F, 0x003F, 0x6458, 0x6459, 0x003F, 0x003F, 
  0x3F6E, 0x6F21, 0x6F23, 0x003F, 0x645A, 0x645B, 0x645C, 0x645D, 
  0x3E7B, 0x645E, 0x6F22, 0x6F24, 0x645F, 0x6460, 0x3653, 0x6461, 
  0x4945, 0x6462, 0x6463, 0x3C62, 0x4F23, 0x003F, 0x6E7E, 0x3A78, 
  0x003F, 0x003F, 0x4F3F, 0x6464, 0x6465, 0x6F26, 0x6466, 0x6467, 
  0x003F, 0x003F, 0x6F25, 0x6F27, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x6E7D, 0x003F, 0x003F, 0x6468, 
  0x6469, 0x646A, 0x003F, 0x4669, 0x003F, 0x4555, 0x003F, 0x003F, 
  0x646B, 0x646C, 0x646D, 0x003F, 0x4457, 0x646E, 0x6F2C, 0x646F, 
  0x6470, 0x003F, 0x6471, 0x4343, 0x6F28, 0x003F, 0x6472, 0x003F, 
  0x6F29, 0x003F, 0x003F, 0x003F, 0x6473, 0x6474, 0x003F, 0x6475, 
  0x003F, 0x6476, 0x6477, 0x003F, 0x372D, 0x003F, 0x6F2B, 0x6479, 
  0x647A, 0x647B, 0x003F, 0x647C, 0x647D, 0x3830, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x6521, 0x003F, 0x6F2A, 0x6522, 0x3E61, 0x6523, 
  0x6524, 0x6525, 0x6526, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x6527, 0x003F, 0x6528, 0x6529, 0x3379, 0x652A, 0x003F, 0x652B, 
  0x003F, 0x003F, 0x652C, 0x003F, 0x6F30, 0x652D, 0x3A3F, 0x4179, 
  0x652E, 0x003F, 0x444A, 0x652F, 0x003F, 0x003F, 0x6530, 0x003F, 
  0x003F, 0x6531, 0x003F, 0x6532, 0x6533, 0x003F, 0x6534, 0x333B, 
  0x6535, 0x653B, 0x003F, 0x6536, 0x6F2E, 0x6F2F, 0x4443, 0x003F, 
  0x6F2D, 0x003F, 0x003F, 0x003F, 0x6537, 0x6538, 0x6539, 0x003F, 
  0x003F, 0x6F31, 0x653A, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x653C, 0x003F, 0x6F37, 0x653D, 0x653E, 0x653F, 0x6540, 
  0x6F3A, 0x6541, 0x6542, 0x6543, 0x6544, 0x6545, 0x003F, 0x003F, 
  0x6F39, 0x452D, 0x003F, 0x6546, 0x003F, 0x003F, 0x6F32, 0x6F33, 
  0x6F36, 0x6547, 0x003F, 0x003F, 0x6548, 0x6F38, 0x6549, 0x654A, 
  0x003F, 0x3640, 0x654B, 0x003F, 0x6F3B, 0x6F35, 0x654C, 0x654D, 
  0x6F34, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x654F, 
  0x6550, 0x654E, 0x6551, 0x6552, 0x003F, 0x6553, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_94[] = {
  0x003F, 0x6554, 0x6555, 0x6F3F, 0x6556, 0x003F, 0x003F, 0x6F40, 
  0x6557, 0x6558, 0x003F, 0x003F, 0x003F, 0x6559, 0x655A, 0x655B, 
  0x6F41, 0x003F, 0x003F, 0x6F3E, 0x6F3D, 0x655C, 0x655D, 0x655E, 
  0x3E62, 0x462A, 0x6F3C, 0x003F, 0x003F, 0x003F, 0x003F, 0x655F, 
  0x003F, 0x6F45, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x6F43, 0x003F, 0x003F, 0x6560, 0x6561, 
  0x003F, 0x6562, 0x6563, 0x6564, 0x6565, 0x6F44, 0x6F42, 0x003F, 
  0x4278, 0x003F, 0x6F46, 0x6566, 0x003F, 0x6568, 0x003F, 0x6567, 
  0x003F, 0x6F47, 0x003F, 0x6569, 0x6F49, 0x656A, 0x003F, 0x003F, 
  0x656B, 0x003F, 0x656C, 0x003F, 0x656D, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x3455, 0x6F48, 0x4C7A, 0x003F, 0x656E, 0x003F, 0x003F, 
  0x003F, 0x656F, 0x6F54, 0x6F4A, 0x6570, 0x003F, 0x6F4D, 0x6571, 
  0x6F4B, 0x6572, 0x6F4C, 0x6573, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x6574, 0x003F, 0x6F4E, 0x6575, 0x003F, 0x6576, 0x6577, 0x6578, 
  0x6F50, 0x6579, 0x657A, 0x003F, 0x003F, 0x6F51, 0x003F, 0x6F52, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x6F55, 0x6F53, 0x6F56, 0x6F58, 
  0x003F, 0x6F57, 0x003F, 0x657C, 0x657B, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_95[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4439, 
  0x657D, 0x657E, 0x003F, 0x003F, 0x003F, 0x003F, 0x6621, 0x003F, 
  0x4C67, 0x003F, 0x6F59, 0x412E, 0x6622, 0x003F, 0x003F, 0x6F5A, 
  0x6623, 0x4A44, 0x6F5B, 0x332B, 0x6624, 0x6625, 0x6626, 0x313C, 
  0x003F, 0x3457, 0x003F, 0x3456, 0x6F5C, 0x003F, 0x6F5D, 0x003F, 
  0x6F5E, 0x6F5F, 0x003F, 0x003F, 0x003F, 0x6627, 0x6628, 0x6629, 
  0x6F60, 0x662A, 0x3458, 0x3355, 0x395E, 0x4836, 0x662B, 0x6F62, 
  0x6F61, 0x662C, 0x003F, 0x662D, 0x662E, 0x6F63, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x315C, 0x003F, 0x662F, 0x003F, 0x6630, 0x003F, 
  0x003F, 0x6F66, 0x6631, 0x6F65, 0x6F64, 0x6632, 0x6F67, 0x6633, 
  0x003F, 0x003F, 0x003F, 0x6F6A, 0x003F, 0x003F, 0x6634, 0x3047, 
  0x6635, 0x6636, 0x6F68, 0x6637, 0x6F6C, 0x6F6B, 0x003F, 0x003F, 
  0x6638, 0x6639, 0x663A, 0x663B, 0x6F6E, 0x6F6D, 0x6F6F, 0x003F, 
  0x462E, 0x663C, 0x663D, 0x003F, 0x6F70, 0x663E, 0x663F, 0x6640, 
  0x6641, 0x6F71, 0x6F73, 0x003F, 0x6642, 0x6F72, 0x6643, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_96[] = {
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x496C, 0x6644, 0x6645, 0x003F, 
  0x003F, 0x6F74, 0x6646, 0x003F, 0x6647, 0x6648, 0x6649, 0x003F, 
  0x6F75, 0x003F, 0x3A65, 0x003F, 0x664A, 0x003F, 0x6F76, 0x6F77, 
  0x003F, 0x664B, 0x4B49, 0x003F, 0x003F, 0x003F, 0x003F, 0x664D, 
  0x664E, 0x664F, 0x6650, 0x414B, 0x6651, 0x6652, 0x003F, 0x3024, 
  0x424B, 0x6653, 0x6F78, 0x003F, 0x496D, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x6F7B, 0x6F79, 0x395F, 0x003F, 0x6F7A, 
  0x3842, 0x003F, 0x6654, 0x003F, 0x6655, 0x003F, 0x6656, 0x6657, 
  0x6658, 0x003F, 0x003F, 0x4A45, 0x6F7D, 0x7021, 0x6F7E, 0x7022, 
  0x003F, 0x6659, 0x3121, 0x3F58, 0x3D7C, 0x3459, 0x7023, 0x003F, 
  0x003F, 0x003F, 0x4766, 0x003F, 0x7025, 0x003F, 0x665A, 0x003F, 
  0x3122, 0x003F, 0x7024, 0x4444, 0x665B, 0x4E4D, 0x462B, 0x6F7C, 
  0x4E26, 0x003F, 0x3831, 0x665C, 0x665D, 0x4D5B, 0x665E, 0x665F, 
  0x003F, 0x6660, 0x6661, 0x6662, 0x6663, 0x3679, 0x4E34, 0x003F, 
  0x3728, 0x6664, 0x4262, 0x003F, 0x003F, 0x7026, 0x332C, 0x3F6F, 
  0x003F, 0x6665, 0x003F, 0x003F, 0x3356, 0x7028, 0x6666, 0x7029, 
  0x7027, 0x3764, 0x6667, 0x3A5D, 0x3E63, 0x6668, 0x003F, 0x6669, 
  0x3123, 0x003F, 0x003F, 0x4E59, 0x666A, 0x666B, 0x666C, 0x702B, 
  0x6E2E, 0x666D, 0x702A, 0x003F, 0x003F, 0x003F, 0x666E, 0x666F, 
  0x702E, 0x702C, 0x702D, 0x6670, 0x702F, 0x003F, 0x7030, 0x4E6C, 
  0x7031, 0x7032, 0x6671, 0x4049, 0x483B, 0x003F, 0x003F, 0x003F, 
  0x3F7D, 0x3467, 0x003F, 0x003F, 0x4D3A, 0x326D, 0x3D38, 0x385B, 
  0x003F, 0x7035, 0x6672, 0x7034, 0x3B73, 0x7036, 0x7033, 0x003F, 
  0x003F, 0x3B28, 0x6673, 0x003F, 0x003F, 0x703A, 0x003F, 0x003F, 
  0x6675, 0x5256, 0x6676, 0x3F77, 0x7038, 0x6677, 0x6678, 0x6679, 
  0x003F, 0x003F, 0x4E25, 0x4671, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x312B, 0x667A, 0x4063, 0x3C36, 0x003F, 0x003F, 0x003F, 0x667B, 
  0x4A37, 0x667C, 0x3140, 0x003F, 0x003F, 0x003F, 0x4E6D, 0x4D6B, 
  0x003F, 0x703B, 0x667D, 0x4545, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_97[] = {
  0x3C7B, 0x003F, 0x667E, 0x6721, 0x703C, 0x6722, 0x703D, 0x3F4C, 
  0x703E, 0x6723, 0x4E6E, 0x003F, 0x003F, 0x7039, 0x7040, 0x7042, 
  0x003F, 0x7041, 0x003F, 0x703F, 0x003F, 0x003F, 0x7043, 0x003F, 
  0x003F, 0x7044, 0x6724, 0x6725, 0x417A, 0x6726, 0x3262, 0x003F, 
  0x003F, 0x6727, 0x6728, 0x6729, 0x7045, 0x003F, 0x003F, 0x4C38, 
  0x672A, 0x003F, 0x7046, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x7047, 0x672B, 0x4F2A, 0x672C, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x5B31, 0x7048, 0x003F, 0x003F, 0x003F, 0x7049, 0x704A, 0x003F, 
  0x003F, 0x672D, 0x704E, 0x672E, 0x704B, 0x003F, 0x704C, 0x003F, 
  0x704D, 0x704F, 0x672F, 0x003F, 0x003F, 0x003F, 0x6730, 0x6731, 
  0x003F, 0x003F, 0x4044, 0x003F, 0x003F, 0x6732, 0x4C77, 0x6733, 
  0x6734, 0x4045, 0x6735, 0x6736, 0x7050, 0x003F, 0x4873, 0x003F, 
  0x7051, 0x7353, 0x4C4C, 0x6737, 0x7052, 0x003F, 0x7053, 0x6738, 
  0x7054, 0x3357, 0x6739, 0x7056, 0x003F, 0x3F59, 0x673A, 0x003F, 
  0x003F, 0x7057, 0x003F, 0x673B, 0x3724, 0x003F, 0x673C, 0x673D, 
  0x673E, 0x7058, 0x705C, 0x673F, 0x705A, 0x6740, 0x003F, 0x6741, 
  0x6742, 0x705B, 0x003F, 0x003F, 0x3373, 0x7059, 0x705D, 0x003F, 
  0x003F, 0x6743, 0x003F, 0x705E, 0x003F, 0x3048, 0x003F, 0x705F, 
  0x7060, 0x003F, 0x003F, 0x003F, 0x003F, 0x6744, 0x6745, 0x6746, 
  0x3E64, 0x6747, 0x6748, 0x003F, 0x7061, 0x003F, 0x6749, 0x674A, 
  0x3547, 0x003F, 0x674B, 0x7064, 0x003F, 0x003F, 0x7063, 0x003F, 
  0x7062, 0x003F, 0x003F, 0x003F, 0x674C, 0x4A5C, 0x674D, 0x003F, 
  0x003F, 0x674E, 0x674F, 0x7065, 0x7066, 0x6750, 0x6751, 0x003F, 
  0x6752, 0x6753, 0x6754, 0x003F, 0x6755, 0x003F, 0x6756, 0x6757, 
  0x003F, 0x6758, 0x003F, 0x7067, 0x6759, 0x675A, 0x7068, 0x675B, 
  0x7069, 0x675C, 0x675D, 0x706A, 0x675E, 0x675F, 0x6760, 0x003F, 
  0x6761, 0x6762, 0x003F, 0x345A, 0x6763, 0x003F, 0x003F, 0x6764, 
  0x6765, 0x6766, 0x003F, 0x676A, 0x706B, 0x6767, 0x6768, 0x003F, 
  0x6769, 0x676B, 0x003F, 0x003F, 0x676C, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x706C, 0x4723, 0x676D, 
  0x003F, 0x676E, 0x706E, 0x323B, 0x676F, 0x7071, 0x7070, 0x6770, 
  0x6771, 0x003F, 0x6772, 0x3124, 0x003F, 0x003F, 0x003F, 0x3641
};
static const unsigned uni2jis_tbl_98[] = {
  0x003F, 0x4A47, 0x443A, 0x3A22, 0x003F, 0x3960, 0x3D67, 0x6773, 
  0x3F5C, 0x003F, 0x6774, 0x003F, 0x7073, 0x6776, 0x6777, 0x7072, 
  0x4D42, 0x3468, 0x4852, 0x465C, 0x6778, 0x003F, 0x6779, 0x3F7C, 
  0x4E4E, 0x6775, 0x375B, 0x003F, 0x677A, 0x003F, 0x677B, 0x003F, 
  0x677C, 0x7076, 0x003F, 0x677D, 0x7075, 0x6828, 0x677E, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x6821, 0x4B4B, 0x462C, 0x6822, 0x6823, 
  0x6824, 0x003F, 0x6825, 0x6826, 0x3150, 0x6827, 0x003F, 0x7077, 
  0x7074, 0x003F, 0x003F, 0x4951, 0x4D6A, 0x7078, 0x6829, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x682A, 0x003F, 0x7079, 0x682B, 
  0x003F, 0x003F, 0x682C, 0x707B, 0x426A, 0x335B, 0x335C, 0x707A, 
  0x003F, 0x682D, 0x682E, 0x682F, 0x3469, 0x3832, 0x6830, 0x6831, 
  0x346A, 0x6832, 0x6833, 0x453F, 0x003F, 0x003F, 0x4E60, 0x003F, 
  0x003F, 0x003F, 0x6834, 0x6835, 0x003F, 0x6836, 0x6837, 0x385C, 
  0x003F, 0x003F, 0x6838, 0x707C, 0x6839, 0x003F, 0x003F, 0x707D, 
  0x707E, 0x7121, 0x003F, 0x7123, 0x7122, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4977, 0x003F, 0x7124, 0x683A, 0x003F, 0x683B, 0x683C, 0x7125, 
  0x683D, 0x7126, 0x003F, 0x003F, 0x683E, 0x003F, 0x7127, 0x683F, 
  0x6840, 0x003F, 0x6841, 0x6842, 0x003F, 0x003F, 0x003F, 0x6843, 
  0x003F, 0x003F, 0x6844, 0x7129, 0x7128, 0x6845, 0x712A, 0x003F, 
  0x6846, 0x003F, 0x003F, 0x003F, 0x6847, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x4874, 0x664C, 0x003F, 0x003F, 0x3F29, 
  0x003F, 0x6848, 0x3532, 0x6849, 0x003F, 0x684A, 0x684B, 0x684C, 
  0x003F, 0x712B, 0x684D, 0x712C, 0x003F, 0x522C, 0x5D3B, 0x4853, 
  0x003F, 0x003F, 0x307B, 0x684E, 0x303B, 0x003F, 0x684F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x3B74, 0x4B30, 0x3E7E, 0x003F
};
static const unsigned uni2jis_tbl_99[] = {
  0x003F, 0x003F, 0x6850, 0x712D, 0x003F, 0x4C5F, 0x003F, 0x6851, 
  0x6852, 0x712E, 0x4D5C, 0x003F, 0x3142, 0x003F, 0x003F, 0x003F, 
  0x3B41, 0x6853, 0x712F, 0x326E, 0x7130, 0x6854, 0x6855, 0x6856, 
  0x7131, 0x003F, 0x6857, 0x6858, 0x6859, 0x7133, 0x7134, 0x685A, 
  0x7136, 0x7132, 0x685B, 0x003F, 0x7135, 0x003F, 0x685C, 0x685D, 
  0x345B, 0x003F, 0x003F, 0x685E, 0x7137, 0x003F, 0x7138, 0x003F, 
  0x003F, 0x685F, 0x6860, 0x6861, 0x6862, 0x6863, 0x003F, 0x003F, 
  0x003F, 0x6864, 0x6865, 0x6866, 0x6867, 0x7139, 0x713A, 0x003F, 
  0x6868, 0x6869, 0x713B, 0x003F, 0x003F, 0x713D, 0x686A, 0x686B, 
  0x686C, 0x713C, 0x003F, 0x713F, 0x7142, 0x686D, 0x686E, 0x003F, 
  0x713E, 0x7140, 0x7141, 0x003F, 0x686F, 0x7143, 0x003F, 0x3642, 
  0x6870, 0x6871, 0x003F, 0x6872, 0x6873, 0x003F, 0x6874, 0x6875, 
  0x6876, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x3C73, 0x7144, 
  0x7145, 0x3961, 0x003F, 0x6877, 0x003F, 0x6878, 0x003F, 0x6879, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x7146, 0x687A, 0x003F, 
  0x333E, 0x003F, 0x003F, 0x003F, 0x474F, 0x7147, 0x7148, 0x003F, 
  0x687B, 0x687C, 0x687D, 0x435A, 0x466B, 0x687E, 0x003F, 0x003F, 
  0x003F, 0x6921, 0x6922, 0x003F, 0x7149, 0x6923, 0x003F, 0x6924, 
  0x003F, 0x477D, 0x003F, 0x6925, 0x424C, 0x3158, 0x366E, 0x003F, 
  0x366F, 0x6926, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x4373, 0x714E, 0x3670, 0x6927, 0x6928, 0x326F, 0x003F, 0x003F, 
  0x714D, 0x6929, 0x692A, 0x714B, 0x692B, 0x714C, 0x692C, 0x714A, 
  0x003F, 0x003F, 0x7158, 0x003F, 0x003F, 0x003F, 0x003F, 0x692D, 
  0x003F, 0x003F, 0x692E, 0x692F, 0x6930, 0x714F, 0x7150, 0x003F, 
  0x6931, 0x7151, 0x7152, 0x003F, 0x6932, 0x6933, 0x003F, 0x003F, 
  0x7154, 0x6934, 0x003F, 0x7153, 0x003F, 0x6935, 0x6936, 0x3D59
};
static const unsigned uni2jis_tbl_9a[] = {
  0x003F, 0x7155, 0x6937, 0x6938, 0x6939, 0x7157, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x693A, 0x693B, 0x003F, 0x3533, 0x7156, 
  0x693C, 0x693D, 0x417B, 0x3833, 0x003F, 0x003F, 0x693E, 0x003F, 
  0x003F, 0x7159, 0x003F, 0x003F, 0x003F, 0x003F, 0x693F, 0x003F, 
  0x6940, 0x003F, 0x6941, 0x6942, 0x6943, 0x003F, 0x003F, 0x6944, 
  0x424D, 0x003F, 0x003F, 0x715A, 0x003F, 0x6945, 0x6946, 0x003F, 
  0x462D, 0x003F, 0x003F, 0x6947, 0x003F, 0x6948, 0x6949, 0x715B, 
  0x694A, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x7160, 0x003F, 
  0x715E, 0x694C, 0x715D, 0x715F, 0x694D, 0x715C, 0x003F, 0x694B, 
  0x003F, 0x003F, 0x694E, 0x694F, 0x6950, 0x7162, 0x6951, 0x003F, 
  0x003F, 0x6952, 0x003F, 0x003F, 0x6953, 0x7161, 0x6954, 0x7164, 
  0x003F, 0x003F, 0x3643, 0x7163, 0x003F, 0x6955, 0x003F, 0x7165, 
  0x003F, 0x003F, 0x7166, 0x003F, 0x7168, 0x7167, 0x003F, 0x003F, 
  0x003F, 0x7169, 0x716B, 0x716A, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x397C, 0x003F, 0x6956, 0x003F, 0x6957, 0x716C, 0x6958, 0x6959, 
  0x716D, 0x003F, 0x695A, 0x003F, 0x695B, 0x695C, 0x695D, 0x003F, 
  0x333C, 0x695E, 0x003F, 0x695F, 0x716E, 0x003F, 0x6960, 0x6961, 
  0x716F, 0x6962, 0x003F, 0x6963, 0x3F71, 0x003F, 0x6964, 0x003F, 
  0x6965, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x6966, 0x7170, 
  0x6967, 0x7171, 0x6968, 0x7172, 0x7173, 0x6969, 0x696A, 0x696B, 
  0x3962, 0x003F, 0x003F, 0x696C, 0x696D, 0x003F, 0x7174, 0x7175, 
  0x696E, 0x003F, 0x7176, 0x7177, 0x696F, 0x6970, 0x7178, 0x6971, 
  0x003F, 0x6972, 0x4831, 0x717A, 0x6973, 0x4926, 0x717B, 0x7179, 
  0x003F, 0x717D, 0x6974, 0x6975, 0x717C, 0x6976, 0x003F, 0x717E, 
  0x003F, 0x6977, 0x6978, 0x7221, 0x003F, 0x6979, 0x003F, 0x697A
};
static const unsigned uni2jis_tbl_9b[] = {
  0x697B, 0x697C, 0x697D, 0x697E, 0x6A21, 0x6A22, 0x7222, 0x003F, 
  0x6A23, 0x6A24, 0x003F, 0x6A25, 0x6A26, 0x6A27, 0x6A28, 0x003F, 
  0x6A29, 0x003F, 0x6A2A, 0x003F, 0x003F, 0x003F, 0x6A2B, 0x003F, 
  0x7223, 0x6A2C, 0x7224, 0x6A2D, 0x6A2E, 0x003F, 0x003F, 0x7225, 
  0x6A2F, 0x003F, 0x7226, 0x7227, 0x003F, 0x7228, 0x6A30, 0x7229, 
  0x722A, 0x722B, 0x722C, 0x6A31, 0x003F, 0x6A32, 0x722D, 0x722E, 
  0x003F, 0x5D35, 0x722F, 0x6A33, 0x6A34, 0x6A35, 0x003F, 0x6A36, 
  0x003F, 0x6A37, 0x6A38, 0x6478, 0x3534, 0x6A39, 0x003F, 0x003F, 
  0x003F, 0x3321, 0x3A32, 0x7231, 0x7230, 0x4C25, 0x003F, 0x003F, 
  0x6A3A, 0x003F, 0x003F, 0x6A3B, 0x6A3C, 0x7233, 0x7234, 0x7232, 
  0x003F, 0x7235, 0x003F, 0x003F, 0x4B62, 0x6A3D, 0x6A3E, 0x6A3F, 
  0x7236, 0x003F, 0x357B, 0x6A40, 0x003F, 0x003F, 0x6A41, 0x003F, 
  0x003F, 0x6A42, 0x003F, 0x6A43, 0x003F, 0x6A44, 0x6A45, 0x003F, 
  0x6A46, 0x003F, 0x6A47, 0x6A48, 0x6A49, 0x6A4A, 0x6A4B, 0x4F25, 
  0x003F, 0x003F, 0x003F, 0x6A4C, 0x7237, 0x6A4D, 0x003F, 0x6A4E, 
  0x6A4F, 0x6A50, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x6A51, 
  0x6A52, 0x003F, 0x003F, 0x7239, 0x6A53, 0x6A54, 0x6A55, 0x6A56, 
  0x003F, 0x6A57, 0x6A58, 0x6A59, 0x003F, 0x6A5A, 0x303E, 0x6A5B, 
  0x6A5C, 0x723A, 0x4A2B, 0x7238, 0x6A5D, 0x003F, 0x723B, 0x723C, 
  0x003F, 0x003F, 0x6A5E, 0x003F, 0x003F, 0x6A5F, 0x6A60, 0x723D, 
  0x723E, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x6A61, 0x6A62, 
  0x723F, 0x6A63, 0x4B6E, 0x3B2D, 0x6A64, 0x3A7A, 0x412F, 0x003F, 
  0x6A65, 0x6A66, 0x6A67, 0x003F, 0x7240, 0x003F, 0x003F, 0x6A68, 
  0x6A69, 0x7243, 0x003F, 0x6A6A, 0x6A6B, 0x003F, 0x6A6C, 0x6A6D, 
  0x7241, 0x6A6E, 0x003F, 0x003F, 0x003F, 0x003F, 0x7244, 0x6A6F, 
  0x6A70, 0x3871, 0x7242, 0x003F, 0x003F, 0x003F, 0x6A71, 0x7245, 
  0x6A72, 0x7246, 0x7247, 0x003F, 0x724B, 0x003F, 0x3B2A, 0x6A73, 
  0x6A74, 0x003F, 0x003F, 0x4264, 0x003F, 0x6A75, 0x003F, 0x6A76, 
  0x003F, 0x724C, 0x7249, 0x7248, 0x724A, 0x6A77, 0x003F, 0x6A78, 
  0x375F, 0x003F, 0x6A79, 0x6A7A, 0x003F, 0x003F, 0x003F, 0x6A7B, 
  0x7250, 0x724F, 0x724E, 0x6A7C, 0x003F, 0x3033, 0x003F, 0x6A7D, 
  0x6A7E, 0x6B21, 0x6B22, 0x003F, 0x003F, 0x6B23, 0x003F, 0x6B24
};
static const unsigned uni2jis_tbl_9c[] = {
  0x6B25, 0x003F, 0x6B26, 0x003F, 0x725A, 0x003F, 0x7256, 0x003F, 
  0x7257, 0x7253, 0x7259, 0x6B27, 0x7255, 0x3362, 0x003F, 0x6B28, 
  0x4F4C, 0x6B29, 0x7258, 0x7254, 0x7252, 0x7251, 0x6B2A, 0x003F, 
  0x6B2B, 0x6B2C, 0x6B2D, 0x725C, 0x6B2E, 0x003F, 0x6B2F, 0x003F, 
  0x003F, 0x725F, 0x6B30, 0x6B31, 0x725E, 0x725D, 0x6B32, 0x6B33, 
  0x6B34, 0x6B35, 0x6B36, 0x003F, 0x003F, 0x4949, 0x725B, 0x3073, 
  0x7260, 0x6B37, 0x7262, 0x003F, 0x003F, 0x6B38, 0x6B39, 0x6B3A, 
  0x003F, 0x336F, 0x724D, 0x3137, 0x003F, 0x6B3B, 0x7264, 0x003F, 
  0x003F, 0x6B3C, 0x003F, 0x6B3D, 0x6B3E, 0x6B3F, 0x7263, 0x7261, 
  0x432D, 0x6B40, 0x6B41, 0x003F, 0x003F, 0x003F, 0x6B42, 0x6B43, 
  0x6B44, 0x003F, 0x4B70, 0x6B45, 0x6B46, 0x003F, 0x6B47, 0x4E5A, 
  0x6B48, 0x003F, 0x7265, 0x6B49, 0x6B50, 0x6B4A, 0x6B4B, 0x6B4C, 
  0x7266, 0x003F, 0x003F, 0x6B4D, 0x003F, 0x003F, 0x003F, 0x7267, 
  0x6B52, 0x6B4E, 0x6B4F, 0x6B51, 0x003F, 0x003F, 0x6B53, 0x003F, 
  0x6B54, 0x003F, 0x6B55, 0x003F, 0x003F, 0x6B56, 0x7268, 0x6B57, 
  0x7269, 0x003F, 0x003F, 0x6B58, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x443B, 0x6B59, 0x726A, 
  0x003F, 0x4837, 0x003F, 0x726F, 0x726B, 0x003F, 0x003F, 0x003F, 
  0x726C, 0x003F, 0x6B5A, 0x4B31, 0x4C44, 0x003F, 0x4650, 0x6B5B, 
  0x003F, 0x6B5C, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_9d[] = {
  0x003F, 0x003F, 0x6B5E, 0x7270, 0x003F, 0x003F, 0x7271, 0x463E, 
  0x726E, 0x726D, 0x003F, 0x6B5D, 0x003F, 0x003F, 0x322A, 0x003F, 
  0x003F, 0x6B5F, 0x7279, 0x003F, 0x003F, 0x7278, 0x003F, 0x6B60, 
  0x6B61, 0x003F, 0x003F, 0x3175, 0x6B62, 0x6B63, 0x6B64, 0x7276, 
  0x003F, 0x003F, 0x003F, 0x7275, 0x003F, 0x003F, 0x7273, 0x003F, 
  0x337B, 0x003F, 0x7272, 0x3C32, 0x3229, 0x003F, 0x003F, 0x6B65, 
  0x6B66, 0x003F, 0x6B67, 0x6B68, 0x6B69, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x6B6A, 0x3963, 0x6B6B, 0x6B6D, 0x727C, 0x727B, 
  0x003F, 0x727A, 0x6B6E, 0x6B6F, 0x7277, 0x6B6C, 0x727D, 0x6B70, 
  0x727E, 0x003F, 0x6B71, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x7325, 0x7324, 0x003F, 0x6B72, 0x6B73, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x7326, 0x003F, 0x003F, 0x312D, 0x7321, 0x7322, 0x6B74, 
  0x3974, 0x4C39, 0x6B76, 0x6B75, 0x7323, 0x6B77, 0x003F, 0x003F, 
  0x003F, 0x6B78, 0x6B79, 0x6B7A, 0x4B32, 0x003F, 0x003F, 0x732B, 
  0x6B7B, 0x003F, 0x7327, 0x003F, 0x003F, 0x003F, 0x6B7C, 0x6B7D, 
  0x003F, 0x003F, 0x732C, 0x6B7E, 0x6C21, 0x003F, 0x6C22, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x6C23, 0x6C24, 0x003F, 0x6C25, 0x7329, 
  0x003F, 0x7328, 0x6C26, 0x003F, 0x003F, 0x6C27, 0x6C28, 0x375C, 
  0x003F, 0x003F, 0x6C29, 0x6C2A, 0x003F, 0x6C2B, 0x6C2C, 0x6C2D, 
  0x6C2E, 0x003F, 0x732D, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x6C2F, 0x003F, 0x003F, 0x732E, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x732F, 0x6C30, 0x732A, 0x6C31, 0x003F, 0x6C32, 0x7274, 
  0x003F, 0x6C33, 0x7330, 0x003F, 0x4461, 0x6C34, 0x003F, 0x003F, 
  0x7334, 0x6C35, 0x7335, 0x7333, 0x6C36, 0x003F, 0x003F, 0x6C37, 
  0x003F, 0x7332, 0x7338, 0x6C38, 0x7331, 0x003F, 0x7336, 0x6C39, 
  0x003F, 0x6C3A, 0x6C3B, 0x003F, 0x003F, 0x003F, 0x003F, 0x7337, 
  0x003F, 0x003F, 0x003F, 0x733A, 0x6C3C, 0x6C3D, 0x6C3E, 0x6C3F, 
  0x003F, 0x7339, 0x6C40, 0x003F, 0x003F, 0x003F, 0x6C41, 0x6C42, 
  0x6C43, 0x003F, 0x003F, 0x003F, 0x003F, 0x6C44, 0x733C, 0x6C45, 
  0x003F, 0x6C46, 0x003F, 0x6C47, 0x003F, 0x733D, 0x6C48, 0x733E, 
  0x6C49, 0x003F, 0x4F49, 0x6C4A, 0x6C4B, 0x003F, 0x003F, 0x003F, 
  0x733B, 0x426B, 0x3A6D, 0x003F, 0x003F, 0x733F, 0x6C4C, 0x003F
};
static const unsigned uni2jis_tbl_9e[] = {
  0x003F, 0x003F, 0x6C4E, 0x003F, 0x003F, 0x003F, 0x003F, 0x6C4F, 
  0x003F, 0x003F, 0x6C4D, 0x003F, 0x003F, 0x003F, 0x6C50, 0x003F, 
  0x6C51, 0x6C52, 0x6C53, 0x003F, 0x003F, 0x6C54, 0x6C55, 0x003F, 
  0x003F, 0x6C56, 0x7340, 0x7341, 0x6C57, 0x6C58, 0x7342, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x7343, 0x003F, 0x003F, 
  0x3834, 0x7344, 0x6C59, 0x003F, 0x6C5B, 0x7345, 0x003F, 0x3C2F, 
  0x6C5C, 0x7346, 0x6C5D, 0x6C5E, 0x6C5F, 0x6C60, 0x003F, 0x6C61, 
  0x7347, 0x003F, 0x003F, 0x7348, 0x7349, 0x003F, 0x6C62, 0x6C63, 
  0x003F, 0x734C, 0x734A, 0x4F3C, 0x003F, 0x734B, 0x6C64, 0x4E6F, 
  0x6C65, 0x003F, 0x003F, 0x6C66, 0x003F, 0x734D, 0x6C67, 0x4E5B, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x6C68, 0x734E, 0x477E, 0x003F, 
  0x6C69, 0x734F, 0x7351, 0x003F, 0x6C6A, 0x7352, 0x6C6B, 0x6C6C, 
  0x6C6D, 0x003F, 0x003F, 0x6C6E, 0x6C6F, 0x6C70, 0x003F, 0x003F, 
  0x7350, 0x396D, 0x4C4D, 0x4B63, 0x5677, 0x003F, 0x5D60, 0x4B7B, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x322B, 0x003F, 0x6C71, 0x003F, 
  0x6C72, 0x003F, 0x003F, 0x6C73, 0x7354, 0x3550, 0x7355, 0x7356, 
  0x7357, 0x003F, 0x3975, 0x003F, 0x7358, 0x6C74, 0x003F, 0x003F, 
  0x6054, 0x4C5B, 0x003F, 0x4263, 0x7359, 0x735B, 0x735A, 0x6C75, 
  0x735C, 0x003F, 0x003F, 0x003F, 0x6C76, 0x735D, 0x003F, 0x6C77, 
  0x735E, 0x003F, 0x003F, 0x003F, 0x6C78, 0x6C79, 0x6C7A, 0x735F, 
  0x6C7B, 0x6C7C, 0x6C7D, 0x003F, 0x7360, 0x6C7E, 0x7361, 0x7362, 
  0x6D21, 0x7363, 0x003F, 0x7364, 0x7365, 0x7366, 0x003F, 0x6D22
};
static const unsigned uni2jis_tbl_9f[] = {
  0x003F, 0x003F, 0x6D23, 0x6D24, 0x003F, 0x003F, 0x003F, 0x7367, 
  0x7368, 0x6D25, 0x003F, 0x003F, 0x003F, 0x003F, 0x4524, 0x6D26, 
  0x6D27, 0x6D28, 0x6D29, 0x385D, 0x6D2A, 0x736A, 0x6D2B, 0x6D2C, 
  0x003F, 0x6D2D, 0x6D2E, 0x6D2F, 0x003F, 0x003F, 0x003F, 0x6D30, 
  0x414D, 0x736B, 0x6D31, 0x003F, 0x003F, 0x003F, 0x6D32, 0x003F, 
  0x003F, 0x003F, 0x6D33, 0x6D34, 0x736C, 0x003F, 0x003F, 0x6D35, 
  0x003F, 0x6D36, 0x6D37, 0x003F, 0x6D38, 0x003F, 0x003F, 0x6D39, 
  0x003F, 0x6D3A, 0x6D3B, 0x4921, 0x6D3C, 0x6D3D, 0x736D, 0x6D3E, 
  0x003F, 0x6D3F, 0x003F, 0x6D40, 0x6D41, 0x6D42, 0x6D43, 0x6D44, 
  0x003F, 0x003F, 0x736E, 0x6337, 0x003F, 0x003F, 0x6C5A, 0x706D, 
  0x003F, 0x003F, 0x736F, 0x6D45, 0x7370, 0x6D46, 0x6D47, 0x6D48, 
  0x6D49, 0x003F, 0x6D4A, 0x003F, 0x003F, 0x6D4B, 0x6D4C, 0x7372, 
  0x7373, 0x7374, 0x4E70, 0x7371, 0x003F, 0x003F, 0x7375, 0x7376, 
  0x6D4D, 0x6D4E, 0x7378, 0x003F, 0x7377, 0x6D4F, 0x6D50, 0x6D51, 
  0x6D52, 0x6D53, 0x737A, 0x6D54, 0x003F, 0x6D55, 0x737B, 0x7379, 
  0x003F, 0x003F, 0x6D56, 0x003F, 0x003F, 0x6D57, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x4E36, 0x003F, 0x6D58, 
  0x6D59, 0x6D5A, 0x6D5B, 0x003F, 0x6D5C, 0x737C, 0x6D5D, 0x6D5E, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x737D, 0x6354, 0x6D5F, 0x003F, 
  0x737E, 0x6D60, 0x6D61, 0x6D62, 0x003F, 0x6D63, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
static const unsigned uni2jis_tbl_ff[] = {
  0x003F, 0x212A, 0x003F, 0x2174, 0x2170, 0x2173, 0x2175, 0x003F, 
  0x214A, 0x214B, 0x2176, 0x215C, 0x2124, 0x003F, 0x2125, 0x213F, 
  0x2330, 0x2331, 0x2332, 0x2333, 0x2334, 0x2335, 0x2336, 0x2337, 
  0x2338, 0x2339, 0x2127, 0x2128, 0x2163, 0x2161, 0x2164, 0x2129, 
  0x2177, 0x2341, 0x2342, 0x2343, 0x2344, 0x2345, 0x2346, 0x2347, 
  0x2348, 0x2349, 0x234A, 0x234B, 0x234C, 0x234D, 0x234E, 0x234F, 
  0x2350, 0x2351, 0x2352, 0x2353, 0x2354, 0x2355, 0x2356, 0x2357, 
  0x2358, 0x2359, 0x235A, 0x214E, 0x235C, 0x214F, 0x2130, 0x2132, 
  0x212E, 0x2361, 0x2362, 0x2363, 0x2364, 0x2365, 0x2366, 0x2367, 
  0x2368, 0x2369, 0x236A, 0x236B, 0x236C, 0x236D, 0x236E, 0x236F, 
  0x2370, 0x2371, 0x2372, 0x2373, 0x2374, 0x2375, 0x2376, 0x2377, 
  0x2378, 0x2379, 0x237A, 0x2150, 0x2143, 0x2151, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x2131, 0x003F, 0x216F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 
  0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F, 0x003F
};
const unsigned * uni2jis_tbls[] = {
  uni2jis_tbl_00,
  NULL,
  NULL,
  uni2jis_tbl_03,
  uni2jis_tbl_04,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  uni2jis_tbl_20,
  uni2jis_tbl_21,
  uni2jis_tbl_22,
  uni2jis_tbl_23,
  NULL,
  uni2jis_tbl_25,
  uni2jis_tbl_26,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  uni2jis_tbl_30,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  uni2jis_tbl_4e,
  uni2jis_tbl_4f,
  uni2jis_tbl_50,
  uni2jis_tbl_51,
  uni2jis_tbl_52,
  uni2jis_tbl_53,
  uni2jis_tbl_54,
  uni2jis_tbl_55,
  uni2jis_tbl_56,
  uni2jis_tbl_57,
  uni2jis_tbl_58,
  uni2jis_tbl_59,
  uni2jis_tbl_5a,
  uni2jis_tbl_5b,
  uni2jis_tbl_5c,
  uni2jis_tbl_5d,
  uni2jis_tbl_5e,
  uni2jis_tbl_5f,
  uni2jis_tbl_60,
  uni2jis_tbl_61,
  uni2jis_tbl_62,
  uni2jis_tbl_63,
  uni2jis_tbl_64,
  uni2jis_tbl_65,
  uni2jis_tbl_66,
  uni2jis_tbl_67,
  uni2jis_tbl_68,
  uni2jis_tbl_69,
  uni2jis_tbl_6a,
  uni2jis_tbl_6b,
  uni2jis_tbl_6c,
  uni2jis_tbl_6d,
  uni2jis_tbl_6e,
  uni2jis_tbl_6f,
  uni2jis_tbl_70,
  uni2jis_tbl_71,
  uni2jis_tbl_72,
  uni2jis_tbl_73,
  uni2jis_tbl_74,
  uni2jis_tbl_75,
  uni2jis_tbl_76,
  uni2jis_tbl_77,
  uni2jis_tbl_78,
  uni2jis_tbl_79,
  uni2jis_tbl_7a,
  uni2jis_tbl_7b,
  uni2jis_tbl_7c,
  uni2jis_tbl_7d,
  uni2jis_tbl_7e,
  uni2jis_tbl_7f,
  uni2jis_tbl_80,
  uni2jis_tbl_81,
  uni2jis_tbl_82,
  uni2jis_tbl_83,
  uni2jis_tbl_84,
  uni2jis_tbl_85,
  uni2jis_tbl_86,
  uni2jis_tbl_87,
  uni2jis_tbl_88,
  uni2jis_tbl_89,
  uni2jis_tbl_8a,
  uni2jis_tbl_8b,
  uni2jis_tbl_8c,
  uni2jis_tbl_8d,
  uni2jis_tbl_8e,
  uni2jis_tbl_8f,
  uni2jis_tbl_90,
  uni2jis_tbl_91,
  uni2jis_tbl_92,
  uni2jis_tbl_93,
  uni2jis_tbl_94,
  uni2jis_tbl_95,
  uni2jis_tbl_96,
  uni2jis_tbl_97,
  uni2jis_tbl_98,
  uni2jis_tbl_99,
  uni2jis_tbl_9a,
  uni2jis_tbl_9b,
  uni2jis_tbl_9c,
  uni2jis_tbl_9d,
  uni2jis_tbl_9e,
  uni2jis_tbl_9f,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  uni2jis_tbl_ff
};
#endif /* _ISO2022JP_HDR_ */
