#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <errno.h>

#include "mdmysqlconfig.h"
#include "mdmysql.h"

#include <mysql/mysql.h>
#include <mysql/errmsg.h>

extern int errno;

mdmysqlrec *get_user_mysql(mdmysqlconfig *cfg,char *username)
{
  MYSQL mysql_buf, *mysql=0;
  MYSQL_RES *result;
  MYSQL_ROW row;
  mdmysqlrec *rec = NULL;
  static const char query[]=
	"SELECT %s, %s, %s, %s, %s, %s, %s FROM %s WHERE %s = \"%s\"";
  char *querybuf;
  unsigned int querybuf_len;


#if MYSQL_VERSION_ID >= 32200
  mysql_init(&mysql_buf);
  mysql=mysql_real_connect(&mysql_buf, cfg->hostname, cfg->dbuser, cfg->dbpw,
			    NULL, cfg->port, cfg->socket, 0);
#else
	mysql=mysql_connect(&mysql_buf, server, userid, password);
#endif

  if ( !mysql )
    return NULL;
  if (mysql_select_db(mysql, cfg->database))
    {
      mysql_close(mysql);
      mysql=0;
      return NULL;
    }
  /* allocate memory for SQL query string */
  querybuf_len = sizeof(query) + 100 + 2 * strlen(cfg->uid_field)
	+ strlen(cfg->uidnumber_field) + strlen(cfg->gidnumber_field)
	+ strlen(cfg->homedir_field) + strlen(cfg->maildir_field)
	+ strlen(cfg->quota_field) + strlen(cfg->mailstatus_field)
	+ strlen(cfg->dbtable) + strlen(username);
  querybuf = malloc(querybuf_len);

  if (!querybuf)
    {
	/* malloc error*/
	mysql_close(mysql);
	return NULL;
    }

  /* prepare SQL query string */
  snprintf(querybuf, querybuf_len, query, cfg->uid_field,
	cfg->uidnumber_field, cfg->gidnumber_field, cfg->homedir_field,
	cfg->maildir_field, cfg->quota_field, cfg->mailstatus_field,
	cfg->dbtable, cfg->uid_field, username);

  if (mysql_query (mysql,querybuf))
    {
      mysql_close(mysql);
      free(querybuf);
      return NULL;
    }
  free(querybuf);
  
  rec = (mdmysqlrec*)malloc(sizeof(mdmysqlrec)+1);

  result = mysql_store_result (mysql);
  if (result)
    {
      if (mysql_num_rows(result))
        {
	  row = mysql_fetch_row (result);
	  rec->uid = strdup(row[0]);
	  rec->uidnumber=atoi(row[1]);
	  if (errno == ERANGE) rec->uidnumber = cfg->default_uidnumber;
	  rec->gidnumber=atoi(row[2]);
	  if (errno == ERANGE) rec->gidnumber = cfg->default_gidnumber;
	  rec->homedir=strdup(row[3]);
	  rec->maildir=strdup(row[4]);
	  rec->quota=strdup(row[5]);
	  rec->mailstatus=strdup(row[6]);

	  if (!rec->uid || !rec->homedir || !rec->maildir || !rec->mailstatus)
	    {
	      mysql_free_result(result);
	      return NULL;
	    }
	  
	}
	mysql_free_result(result);
    }

  return rec;

}

void free_mysql_rec(mdmysqlrec **rec)
{
  if ( rec[0]->uid )
    free(rec[0]->uid);

  if ( rec[0]->homedir )
    free(rec[0]->homedir);
  
  if ( rec[0]->maildir )
    free(rec[0]->maildir);

  if ( rec[0]->quota )
    free(rec[0]->quota);

  if ( rec[0]->mailstatus )
    free(rec[0]->mailstatus);

  free(*rec);

  *rec = NULL;
}
