/*
** Copyright 2000-2001 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"config.h"
#include	"cmlm.h"
#include	"cmlmbounce.h"
#include	"cmlmarchive.h"
#include	"cmlmsubunsub.h"
#include	"random128/random128.h"
#include	"dbobj.h"

#include	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include	<fcntl.h>
#include	<sysexits.h>
#include	<iostream>
#include	<fstream>
#include	<strstream>

#include <sys/types.h>
#if HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifndef WEXITSTATUS
#define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#endif
#ifndef WIFEXITED
#define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif

static const char rcsid[]="$Id: cmlmbounce.C,v 1.5 2001/08/05 20:00:33 mrsam Exp $";

static int handlebounce(CString, CString, unsigned long);
static CString mkbouncetoken(const char *addr, const char *pfix);

//
//  Initial bounce.  Determine address(es) that are bouncing.
//

int dobounce(const char *p)
{
unsigned long n=0;

	while (isdigit((int)(unsigned char) *p))
		n=n*10 + (*p++ - '0');

	if (*p && *p != '-')
	{
		cerr << "Invalid address." << endl;
		return (EX_SOFTWARE);
	}

	CString	t=mktmpfilename();
	CString	tname= TMP "/" + t;

	int tmpfile_fd=open(tname, O_RDWR|O_CREAT|O_TRUNC, 0666);

	if (tmpfile_fd < 0)
	{
		perror(tname);
		return (-1);
	}

	afxopipestream tmpfile_pipe(tmpfile_fd);

	int cin_fd=dup(0);

	if (cin_fd < 0)
	{
		perror("dup");
		exit(1);
	}

	int rc;

	{
		afxipipestream cin_copy(cin_fd);

		rc=copyio_noseek(cin_copy, tmpfile_pipe);

		if (cin_copy.bad())
			rc= -1;
	}

	if (rc == 0)
	{
		tmpfile_pipe.close();
		if (tmpfile_pipe.bad())
			rc= -1;
	}

	ifstream tmpfile(tname);

	if (rc || !tmpfile.is_open())
	{
		perror(tname);
		tmpfile.close();
		unlink(tname);
		return (rc);
	}

	if (*p)
	{
	CString addr=fromverp(p+1);
	int exitstatus=EX_SOFTWARE;

		tmpfile.close();
		if (addr.GetLength() > 0 && addr.Find('@') > 0)
			exitstatus=handlebounce(tname, addr, n);
		else
			cerr << "Invalid address" << endl;

		unlink(tname);
		return (exitstatus);
	}

	// No need to reinvent the wheel.  Run reformime.

int	pipefd[2];

	if (pipe(pipefd) < 0)
	{
		perror("pipe");
		return (EX_TEMPFAIL);
	}

	// No need to reinvent the wheel.  Run reformime.

pid_t	pid=fork();

	if (pid < 0)
	{
		perror("fork");
		close(pipefd[0]);
		close(pipefd[1]);
		return (EX_TEMPFAIL);
	}

	if (pid == 0)
	{
		close(0);
		if (dup(tmpfile_fd) < 0)
		{
			perror("dup");
			exit(EX_TEMPFAIL);
		}
		tmpfile.close();
		close(1);
		dup(pipefd[1]);
		close(pipefd[0]);
		close(pipefd[1]);
		execl(REFORMIME, "reformime", "-D", (char *)0);
		perror("execl");
		exit(EX_OSERR);
	}
	close(pipefd[1]);
	tmpfile.close();

unsigned	addrcnt=0;

	{
	afxipipestream reformime(pipefd[0]);
	CString	buf;

		while ((buf << reformime) == 0)
		{
		int	i=buf.Find(' ');

			if (i < 0)	continue;
			if (strncasecmp(buf, "f", 1))	continue;

			// failed

			buf=buf.Mid(i);
			buf.TrimLeft();
			buf.TrimRight();
			if (buf.GetLength() <= 0)	continue;
			rc=handlebounce(tname, buf, n);
			if (rc)
			{
				unlink (tname);
				return (rc);
			}
			++addrcnt;
		}
	}

int	exitstatus;

	while ( wait(&exitstatus) != pid)
		;

	if (WIFEXITED(exitstatus))
		exitstatus=WEXITSTATUS(exitstatus);
	else
		exitstatus=EX_SOFTWARE;

	unlink(tname);
	return (exitstatus);
}

//
//  This is called to handle a bounce to a single address.
//

static int handlebounce(CString tmpfilename, CString addr, unsigned long n)
{
ExclusiveLock bounce_lock(BOUNCESLOCK);
DbObj	dat;
char	*p=addr.GetBuffer(-1);
char	bufn[100];
struct	stat	stat_buf;

	ostrstream(bufn, sizeof(bufn)) << n << '\0';

	if ((p=strrchr(p, '@')) == 0)
	{
		cerr << "Invalid address." << endl;
		return (EX_SOFTWARE);
	}

	addr.ReleaseBuffer(-1);

	while (*p)
	{
		*p=tolower((int)(unsigned char)*p);
		++p;
	}

	// Validate bounce address as much as possible:
	// 1.  Must be a current subscriber address
	// 2.  Bounce must specify a message number that exists

	if (getinfo(addr, isfound))
		return (0);	// Not a subscriber (any more?)

	if (stat( Archive::filename(n), &stat_buf))
	{
		cerr << "Invalid bounce address." << endl;
		return (EX_SOFTWARE);
	}

	// Locate the directory where bounces for this address are kept

	if (dat.Open(BOUNCESDAT, "C"))
	{
		perror(BOUNCESDAT);
		return (EX_OSERR);
	}

CString	bouncedir, bouncedirp;
char	*q;
size_t	ql;

	if ((q=dat.Fetch(addr, addr.GetLength(), ql, "")) != 0)
	{
		memcpy(bouncedir.GetBuffer(ql), q, ql);
		bouncedir.ReleaseBuffer(ql);
		free(q);
		bouncedirp=BOUNCES "/" + bouncedir;
		if (stat(bouncedirp, &stat_buf))	// Stale entry
			q=0;
	}

	if (q == 0) // First bounce for this address -- create this directory
	{
		bouncedir=mktmpfilename();

		bouncedirp=BOUNCES "/" + bouncedir;

		if ( mkdir( bouncedirp, 0755))
		{
			perror(bouncedirp);
			return (EX_OSERR);
		}

	ofstream	addrfile(bouncedirp + "/.address");

		addrfile << addr << endl << flush;
		if (addrfile.fail())
		{
			perror(bouncedirp);
			return (EX_OSERR);
		}
		if (dat.Store(addr, addr.GetLength(), bouncedir,
			bouncedir.GetLength(), "R"))
			return (EX_SOFTWARE);
	}

	link(tmpfilename, bouncedirp + "/" + bufn);
	return (0);
}

//
//  Return the address associated with a bounce return address.

static CString getbounceaddr(const char *n)
{
CString	s;
CString	buf;

	if (strchr(n, '/'))	return (s);	// Script kiddies

	s= TMP "/";
	s += n;

ifstream	ifs(s);

	if (buf << ifs)
		buf="";
	ifs.close();

	if (buf.GetLength() > 0)
		unlink(s);
	return (buf);
}

//
//  Warning message bounces, send a probe.
//

int dobounce1(const char *n)
{
CString	addr=getbounceaddr(n);

	if (addr.GetLength() <= 0)
	{
		cerr << "Invalid address." << endl;
		return (EX_SOFTWARE);
	}

CString token(mkbouncetoken(addr, "bounce2-"));

	if (token.GetLength() <= 0)
		return (EX_SOFTWARE);

CString owner=get_verp_return(token, 0);
pid_t	p;
afxopipestream ack(sendmail_bcc(p, owner));

	ack << "From: " << myname() << " <" << owner << ">" << endl
		<< "To: " << cmdget("ADDRESS") << endl
		<< "Bcc: " << addr << endl;

	copy_report("warn2msg.tmpl", ack);

	ack.close();
	return (wait4sendmail(p));
}

int dobounce2(const char *n)
{
CString	addr=getbounceaddr(n);
CString	message;
CString	buf;

	if (addr.GetLength() <= 0)
	{
		cerr << "Invalid address." << endl;
		return (EX_SOFTWARE);
	}

	while ((buf << cin) == 0)
	{
		if (message.GetLength() + buf.GetLength() < 50000)
		{
			message += buf;
			message += '\n';
		}
	}
	return (docmdunsub_bounce(addr, message));
}

static CString mkbouncetoken(const char *addr, const char *pfix)
{
struct	stat	stat_buf;
ExclusiveLock tmp_lock(TMPLOCK);
CString	f;
CString	token;

	do
	{
		token=pfix;
		token += random128_alpha();
		f = TMP "/";
		f += token;

	} while (stat(f, &stat_buf) == 0);

	{
		ofstream	ofs(f);

		ofs << addr << endl << flush;
		if (ofs.fail())
		{
			perror(f);
			token="";
		}
		ofs.close();
		if (ofs.fail())
		{
			perror(f);
			token="";
		}
	}
	return (token);
}

//
//  Generate a warning bounce message.
//

int bouncewarning(CString addr, CString lastbounce, CString dir)
{
	int b_fd=open(lastbounce, O_RDONLY);

	if (b_fd < 0)
	{
		perror(lastbounce);
		return (EX_SOFTWARE);
	}

	afxipipestream bouncetxt(b_fd);

CString	boundary=mkboundary_msg(bouncetxt);

	bouncetxt.seekg(0);

CString token(mkbouncetoken(addr, "bounce1-"));

	if (token.GetLength() <= 0)
		return (EX_SOFTWARE);

CString owner=get_verp_return(token, 0);
pid_t	p;
afxopipestream ack(sendmail_bcc(p, owner));

	ack << "From: " << myname() << " <" << owner << ">" << endl
		<< "To: " << cmdget("ADDRESS") << endl
		<< "Bcc: " << addr << endl
		<< "Mime-Version: 1.0" << endl
		<< "Content-Type: multipart/mixed; boundary=\""
			<< boundary << "\"" << endl
		<< "Content-Transfer-Encoding: 8bit" << endl;

	copy_report("warn1headers.tmpl", ack);

	ack << endl << "This is a MIME formatted message." << endl
		<< endl << "--" << boundary << endl;

	copy_report("warn1text.tmpl", ack);

DIR	*dirp;
struct	dirent *de;

	dirp=opendir(dir);
	while (dirp && (de=readdir(dirp)) != 0)
	{
		if (de->d_name[0] == '.')	continue;

		ack << de->d_name << endl;
	}
	if (dirp)	closedir(dirp);

	copy_report("warn1text2.tmpl", ack);

	ack << endl << "--" << boundary << endl
		<< "Content-Type: message/rfc822" << endl << endl;

	if (copyio_noseek(bouncetxt, ack))
		perror(lastbounce);
	ack << endl << "--" << boundary << "--" << endl << flush;
	ack.close();

	return (wait4sendmail(p));
}
