/*
** Copyright 1998 - 2001 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"afx.h"
#include	<memory.h>
#include	<ctype.h>

static const char rcsid[]="$Id: string.C,v 2.2 2001/08/05 20:00:33 mrsam Exp $";

/////////////////////////////////////////////////////////////////////
//
// CString

CString::CString(const char * str) : buf((CStrBuf *)NULL)
{
	init(0, str);
}

CString::CString(const char * str, int cnt) : buf((CStrBuf *)NULL)
{
	init(cnt, str, cnt);
}

CString::CString(char ch, int len) : buf((CStrBuf *)NULL)
{
	init(len);

int i;
char * p=ptr();

	for (i=len; i; --i)
		*p++ = ch;
	*p=0;
}

void CString::init(int len, const char *p, int ncpy)
{
	if (p && ncpy < 0)
	{
		ncpy=strlen(p);
	}

	if (p && len <= ncpy)	len=ncpy;

	++len;	// Make sure we'll have space for terminating null.

	if (!buf || buf->refcnt > 1 || len > buf->size)
		// Must have our private copy in these situations
	{
	int size = sizeof(CStrBuf) + len*sizeof(char) + 32;

		size -= (size % 32);		// Allocate memory in blocks

	struct CStrBuf *newbuf = (struct CStrBuf *) new char[size];

		if (!newbuf)	AfxThrowMemoryException();

	struct CStrBuf *oldp=buf;

		buf=newbuf;

		buf->refcnt=1;
		buf->size= (size - sizeof(CStrBuf))/sizeof(char);
		buf->len=len-1;

		if (p)
			memcpy( ptr(), p, ncpy * sizeof(char));
		else if (oldp)
		{
			if (oldp->len > buf->len)
				memcpy(ptr(), (const char *)(oldp+1),
					buf->len * sizeof(char));
			else
			{
				memcpy(ptr(), (const char *)(oldp+1),
					oldp->len * sizeof(char));
			}
		}
		if (oldp && ! --oldp->refcnt)
		{
			delete[] (char *)oldp;
		}
	}
	else
	{
		if (p)
			memcpy( ptr(), p, ncpy * sizeof(char));
		buf->len=len-1;
	}
	ptr()[buf->len]=0;	// Append terminating null
}
char CString::operator[](int n) const
{
	if (n >= GetLength())	AfxThrowInternalException();
	return (ptr()[n]);
}

char &CString::operator[](int n)
{
	if (n >= GetLength())	AfxThrowInternalException();
	init (buf->len);
	return (ptr()[n]);
}

const CString &CString::operator+=(const CString &o)
{
int	l=GetLength();
int	ol=o.GetLength();

	if (ol == 0)	return (*this);

	init(l+ol);
	memcpy(ptr()+l, o.ptr(), ol);
	ptr()[l+ol]=0;
	return (*this);
}

const CString &CString::operator+=(const char * s)
{
int	l=GetLength();
int	ol=strlen(s);

	if (ol == 0)	return (*this);

	init(l+ol);
	memcpy(ptr()+l, s, ol);
	ptr()[l+ol]=0;
	return (*this);
}

const CString &CString::operator+=(char c)
{
int	l=GetLength();

	init(l+1);
	ptr()[l]=c;
	ptr()[l+1]=0;
	return (*this);
}

// Friendly addition functions

CString operator+(const CString &a, const CString &b)
{
CString c;
int al=a.GetLength(), bl=b.GetLength();

	c.init(al+bl);
	if (al)
		memcpy(c.ptr(), a.ptr(), al * sizeof(char));
	if (bl)
		memcpy(c.ptr()+al, b.ptr(), bl * sizeof(char));
	c.ptr()[al+bl]=0;
	return (c);
}

CString operator+(const CString &a, char b)
{
CString c;
int al=a.GetLength();

	c.init(al+1);
	if (al)
		memcpy(c.ptr(), a.ptr(), al * sizeof(char));
	c.ptr()[al]=b;
	c.ptr()[al+1]=0;
	return (c);
}

CString operator+(const CString &a, const char * b)
{
CString c;
int al=a.GetLength(), bl=b ? strlen(b):0;

	c.init(al+bl);
	if (al)
		memcpy(c.ptr(), a.ptr(), al * sizeof(char));
	if (bl)
		memcpy(c.ptr()+al, b, bl * sizeof(char));
	c.ptr()[al+bl]=0;
	return (c);
}

CString operator+(char a, const CString &b)
{
CString c;
int bl=b.GetLength();

	c.init(bl+1);
	c.ptr()[0]=a;
	if (bl)
		memcpy(c.ptr()+1, b.ptr(), bl * sizeof(char));
	c.ptr()[bl+1]=0;
	return (c);
}

CString operator+(const char * a, const CString &b)
{
CString c;
int bl=b.GetLength(), al=a ? strlen(a):0;

	c.init(al+bl);
	if (al)
		memcpy(c.ptr(), a, al * sizeof(char));
	if (bl)
		memcpy(c.ptr()+al, b.ptr(), bl * sizeof(char));
	c.ptr()[al+bl]=0;
	return (c);
}

CString CString::Mid(int start, int len) const
{
CString rc;
int l=GetLength();

	if (start < l)
	{
		if (len < 0)	len= l-start;

		if (len > l-start)	len=l-start;
		rc.init(len, ptr()+start, len);
	}
	return (rc + "");	// Make sure we won't return a NULL
}

CString CString::Left(int cnt) const
{
int l=GetLength();

	if (cnt > l)	cnt=l;

CString	rc;

	rc.init(cnt, ptr(), cnt);
	return (rc);
}

CString CString::Right(int cnt) const
{
int l=GetLength();

	if (cnt > l)	cnt=l;

CString	rc;

	rc.init(cnt, ptr() + l-cnt, cnt);
	return (rc);
}

void CString::TrimLeft()
{
int l=GetLength();
int i;

	init(l);	// Make sure we have our own copy

char * p=ptr();

	for (i=0; i<l; i++)
		if (!isspace(p[i]))
			break;
	if (i)
	{
		if (l > i)
			memmove(ptr(), ptr()+i, l-i);
		buf->len -= i;
		ptr()[buf->len]=0;
	}
}

void CString::TrimRight()
{
int l=GetLength();

	init(l);	// Make sure we have our own copy

int i,j;
char * p=ptr();

	for (i=j=0; i<l; i++)
		if (!isspace(p[i]))
			j=i+1;
	buf->len=j;
	ptr()[j]=0;
}

int CString::Find(char c) const
{
int i,l=GetLength();
const char * p=ptr();

	for (i=0; i<l; i++)
		if (*p++ == c)
			return (i);
	return (-1);
}

int CString::ReverseFind(char c) const
{
int i,l=GetLength();
char * p=ptr()+l;

	for (i=l; i--; )
		if (*--p == c)
			return (i);
	return (-1);
}

char * CString::GetBuffer(int minsize)
{
int l=GetLength();

	if (minsize < l)	minsize=l;
	init(minsize);
	if (l < minsize)
	{
		memset( ptr()+l, 0, (minsize-l)*sizeof(char));
		ptr()[minsize]=0;
	}
	return ( ptr() );
}

void CString::ReleaseBuffer(int len)
{
	if (len < 0)	len=strlen(ptr());
	if (len >= buf->size)	len=buf->size-1;
	buf->len=len;
	ptr()[len]=0;
}

char * CString::GetBufferSetLength(int len)
{
int l=GetLength();

	if (len < l)
		init(len);
	return (GetBuffer(len));
}

int CString::operator<< (std::istream &i)
{
char lbuf[80];
int cnt;

	(*this)="";

	while (i.get(lbuf, sizeof(lbuf)-1), cnt=i.gcount())
	{
		lbuf[cnt]=0;
		(*this) += lbuf;
	}
	return (i.get() == EOF && (*this).GetLength() == 0 ? EOF:0);
}

int CString::readline(std::istream &i, unsigned maxlen)
{
char	*p=GetBuffer(maxlen+1);
int	c;
unsigned n=0;

	while (maxlen)
	{
		if ((c=i.get()) == EOF)
			break;
		if (c == '\n')
		{
			i.putback(c);
			break;
		}
		*p++=c;
		--maxlen;
		++n;
	}
	ReleaseBuffer(n);
	return (n);
}

void CString::MakeUpper()
{
char * p=GetBuffer();

	while (*p)
	{
		*p=toupper(*p);
		++p;
	}
	ReleaseBuffer();
}

void CString::MakeLower()
{
char * p=GetBuffer();

	while (*p)
	{
		*p=tolower(*p);
		++p;
	}
}

